/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import net.guizhanss.ultimategenerators2.core.services.ConfigurationService;
import net.guizhanss.ultimategenerators2.core.services.IntegrationService;
import net.guizhanss.ultimategenerators2.core.services.ListenerService;
import net.guizhanss.ultimategenerators2.core.services.LocalizationService;
import net.guizhanss.ultimategenerators2.implementation.setup.UGItemSetup;
import net.guizhanss.ultimategenerators2.libs.bstats.bukkit.Metrics;
import net.guizhanss.ultimategenerators2.libs.guizhanlib.slimefun.addon.AbstractAddon;
import net.guizhanss.ultimategenerators2.libs.guizhanlib.updater.GuizhanBuildsUpdater;
import org.bukkit.plugin.Plugin;

public final class UltimateGenerators2
extends AbstractAddon {
    private static final String DEFAULT_LANG = "en";
    private ConfigurationService configService;
    private LocalizationService localization;
    private IntegrationService integrationService;
    private boolean debugEnabled = false;

    public UltimateGenerators2() {
        super("ybw0014", "UltimateGenerators2", "master", "auto-update");
    }

    private static UltimateGenerators2 inst() {
        return (UltimateGenerators2)((Object)UltimateGenerators2.getInstance());
    }

    @Nonnull
    public static ConfigurationService getConfigService() {
        return UltimateGenerators2.inst().configService;
    }

    @Nonnull
    public static LocalizationService getLocalization() {
        return UltimateGenerators2.inst().localization;
    }

    @Nonnull
    public static IntegrationService getIntegrationService() {
        return UltimateGenerators2.inst().integrationService;
    }

    public static void debug(@Nonnull String message, Object ... args) {
        Preconditions.checkNotNull((Object)message, (Object)"message cannot be null");
        if (UltimateGenerators2.inst().debugEnabled) {
            UltimateGenerators2.inst().getLogger().log(Level.INFO, "[DEBUG] " + message, args);
        }
    }

    @Override
    public void enable() {
        UltimateGenerators2.log(Level.INFO, "=====================", new Object[0]);
        UltimateGenerators2.log(Level.INFO, " UltimateGenerators2 ", new Object[0]);
        UltimateGenerators2.log(Level.INFO, "      by ybw0014     ", new Object[0]);
        UltimateGenerators2.log(Level.INFO, "=====================", new Object[0]);
        this.configService = new ConfigurationService(this);
        this.debugEnabled = this.configService.isDebug();
        UltimateGenerators2.log(Level.INFO, "Loading language...", new Object[0]);
        String lang = this.configService.getLang();
        this.localization = new LocalizationService(this, this.getFile());
        this.localization.addLanguage(lang);
        if (!lang.equals(DEFAULT_LANG)) {
            this.localization.addLanguage(DEFAULT_LANG);
        }
        UltimateGenerators2.log(Level.INFO, this.localization.getString("console.loaded-language"), lang);
        UGItemSetup.setup(this);
        this.integrationService = new IntegrationService(this);
        new ListenerService(this);
        this.setupMetrics();
    }

    @Override
    public void disable() {
    }

    private void setupMetrics() {
        new Metrics(this, 20496);
    }

    @Override
    protected void autoUpdate() {
        if (this.getPluginVersion().startsWith("Dev")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), this.getGithubRepo()).start();
        } else if (this.getPluginVersion().startsWith("Build")) {
            try {
                Class<?> clazz = Class.forName("net.guizhanss.ultimategenerators2.libs.guizhanlibplugin.updater.GuizhanUpdater");
                Method updaterStart = clazz.getDeclaredMethod("start", Plugin.class, File.class, String.class, String.class, String.class);
                updaterStart.invoke(null, new Object[]{this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch()});
            }
            catch (Exception ignored) {
                new GuizhanBuildsUpdater((Plugin)this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch()).start();
            }
        }
    }
}

