/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.utils.FireworkUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.ultimategenerators2.UltimateGenerators2;
import net.guizhanss.ultimategenerators2.implementation.UGItems;
import net.guizhanss.ultimategenerators2.utils.LocationUtils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class ClassifiedItemListener
implements Listener {
    public ClassifiedItemListener(@Nonnull UltimateGenerators2 plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void kapa(@Nonnull EntityDamageEvent e) {
        Item itemEntity;
        ItemStack item;
        Entity entity;
        if (e.getCause() == EntityDamageEvent.DamageCause.LAVA && (entity = e.getEntity()) instanceof Item && (item = (itemEntity = (Item)entity).getItemStack()).getAmount() == 8 && SlimefunUtils.isItemSimilar((ItemStack)item, (ItemStack)UGItems.LAMBDA_ELECTRICITY_STORAGE, (boolean)false)) {
            e.setCancelled(true);
            Location l = LocationUtils.getBlockCenter(itemEntity.getLocation());
            itemEntity.remove();
            this.generateItem(l, (ItemStack)UGItems.KAPA_ELECTRICITY_STORAGE, new Color[]{Color.BLACK, Color.BLACK, Color.GRAY, Color.SILVER});
        }
    }

    @EventHandler
    public void phi(@Nonnull EntityDamageEvent e) {
        Item itemEntity;
        ItemStack item;
        Entity entity;
        if (e.getCause() == EntityDamageEvent.DamageCause.LIGHTNING && (entity = e.getEntity()) instanceof Item && (item = (itemEntity = (Item)entity).getItemStack()).getAmount() == 8 && SlimefunUtils.isItemSimilar((ItemStack)item, (ItemStack)UGItems.KAPA_ELECTRICITY_STORAGE, (boolean)false)) {
            e.setCancelled(true);
            Location l = LocationUtils.getBlockCenter(itemEntity.getLocation());
            itemEntity.remove();
            this.generateItem(l, (ItemStack)UGItems.PHI_ELECTRICITY_STORAGE, new Color[]{Color.WHITE, Color.WHITE, Color.GRAY, Color.SILVER});
        }
    }

    @ParametersAreNonnullByDefault
    private void generateItem(Location l, ItemStack item, Color[] fireworkColors) {
        l.getWorld().playSound(l, Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
        Item newItem = l.getWorld().dropItemNaturally(l, item);
        l.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, l, 3);
        for (Color color : fireworkColors) {
            FireworkUtils.launchFirework((Location)l, (Color)color);
        }
        newItem.setGlowing(true);
        newItem.setInvulnerable(true);
        newItem.setCustomNameVisible(true);
        newItem.setCustomName(item.getItemMeta().getDisplayName());
    }
}

