/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.implementation.items.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.ultimategenerators2.implementation.UGItems;
import net.guizhanss.ultimategenerators2.implementation.items.abstracts.AMachine;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;

public class BiomassExtractionMachine
extends AMachine {
    private static final Set<Material> LEAVES = Tag.LEAVES.getValues();

    @ParametersAreNonnullByDefault
    public BiomassExtractionMachine(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    @Nonnull
    public ItemStack getProgressBar() {
        return new ItemStack(Material.SLIME_BALL);
    }

    @Override
    protected void registerDefaultRecipes() {
        this.registerRecipe(8, new ItemStack(Material.SLIME_BALL, 2));
        this.registerRecipe(8, new ItemStack(Material.NETHER_WART_BLOCK, 2));
        LEAVES.forEach(material -> this.registerRecipe(16, new ItemStack(material, 32)));
        this.registerRecipe(16, new ItemStack(Material.WHEAT_SEEDS, 16));
        this.registerRecipe(16, new ItemStack(Material.BEETROOT_SEEDS, 16));
        this.registerRecipe(16, new ItemStack(Material.MELON_SEEDS, 16));
        this.registerRecipe(16, new ItemStack(Material.PUMPKIN_SEEDS, 16));
    }

    private void registerRecipe(int ticks, @Nonnull ItemStack input) {
        this.registerRecipe(ticks, new ItemStack[]{input, new ItemStack(Material.BUCKET)}, (ItemStack)UGItems.BIOMASS_BUCKET);
    }
}

