/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.core.services;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.utils.FileUtils;
import net.guizhanss.ultimategenerators2.UltimateGenerators2;
import net.guizhanss.ultimategenerators2.libs.guizhanlib.slimefun.addon.SlimefunLocalization;

public final class LocalizationService
extends SlimefunLocalization {
    private static final String FOLDER_NAME = "lang";
    private final UltimateGenerators2 plugin;
    private final File jarFile;

    @ParametersAreNonnullByDefault
    public LocalizationService(UltimateGenerators2 plugin, File jarFile) {
        super(plugin);
        this.plugin = plugin;
        this.jarFile = jarFile;
        this.extractTranslations();
    }

    private void extractTranslations() {
        File translationsFolder = new File(this.plugin.getDataFolder(), FOLDER_NAME);
        if (!translationsFolder.exists()) {
            translationsFolder.mkdirs();
        }
        List translationFiles = FileUtils.listYamlFilesInJar((File)this.jarFile, (String)"lang/");
        for (String translationFile : translationFiles) {
            String filePath = FOLDER_NAME + File.separator + translationFile;
            File file = new File(this.plugin.getDataFolder(), filePath);
            if (file.exists()) continue;
            this.plugin.saveResource(filePath, true);
        }
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public String getString(String key, Object ... args) {
        return MessageFormat.format(this.getString(key), args);
    }
}

