/*
 * Decompiled with CFR 0.152.
 */
package me.sfiguz7.transcendence.implementation.items.machines;

import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.concurrent.ThreadLocalRandom;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.sfiguz7.transcendence.implementation.items.items.Polarizer;
import me.sfiguz7.transcendence.lists.TEItems;
import me.sfiguz7.transcendence.lists.TERecipeType;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class QuirpOscillator
extends SimpleSlimefunItem<BlockTicker>
implements InventoryBlock,
EnergyNetComponent {
    private static final int ENERGY_CONSUMPTION = 128;
    private int decrement = 20;
    private ItemStack[] quirps = new ItemStack[]{TEItems.QUIRP_UP, TEItems.QUIRP_DOWN, TEItems.QUIRP_LEFT, TEItems.QUIRP_RIGHT};
    private int[] chancesDefault = new int[]{25, 25, 25, 25};
    private final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 12, 13, 21, 22, 30, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private final int[] inputBorder = new int[0];
    private final int[] outputBorder = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};
    private final int[] polarizerBorder = new int[]{9, 10, 11, 18, 20, 27, 28, 29};

    public QuirpOscillator() {
        super(TEItems.transcendence, TEItems.QUIRP_OSCILLATOR, TERecipeType.NANOBOT_CRAFTER, new ItemStack[]{SlimefunItems.BLISTERING_INGOT_3, SlimefunItems.REINFORCED_PLATE, SlimefunItems.BLISTERING_INGOT_3, SlimefunItems.SYNTHETIC_EMERALD, SlimefunItems.NETHERSTAR_REACTOR, SlimefunItems.SYNTHETIC_EMERALD, SlimefunItems.BLISTERING_INGOT_3, SlimefunItems.REINFORCED_PLATE, SlimefunItems.BLISTERING_INGOT_3});
        this.createPreset((SlimefunItem)this, this::constructMenu);
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : this.border) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.inputBorder) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.outputBorder) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.polarizerBorder) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.PURPLE_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == Material.AIR;
                }
            });
        }
    }

    public int[] getInputSlots() {
        return new int[0];
    }

    public int[] getOutputSlots() {
        return new int[]{24, 25};
    }

    private int getPolarizerSlot() {
        return 19;
    }

    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 512;
    }

    public BlockTicker getItemHandler() {
        return new BlockTicker(){

            public void uniqueTick() {
                if (QuirpOscillator.this.decrement == 1) {
                    QuirpOscillator.this.decrement = 10;
                    return;
                }
                QuirpOscillator.this.decrement--;
            }

            public void tick(Block b, SlimefunItem sf, Config data) {
                if (b.getWorld().getEnvironment() != World.Environment.THE_END) {
                    return;
                }
                if (QuirpOscillator.this.decrement != 10) {
                    return;
                }
                BlockMenu menu = BlockStorage.getInventory((Block)b);
                ItemStack output = this.getQuirp(menu);
                if (ChargableBlock.getCharge((Block)b) >= 128) {
                    if (!menu.fits(output, QuirpOscillator.this.getOutputSlots())) {
                        return;
                    }
                    ChargableBlock.addCharge((Block)b, (int)-128);
                    menu.pushItem(output, QuirpOscillator.this.getOutputSlots());
                }
            }

            private ItemStack getQuirp(BlockMenu menu) {
                int index = ThreadLocalRandom.current().nextInt(100);
                int accruedchance = 0;
                int[] chances = this.getChances(menu);
                for (int i = 0; i < QuirpOscillator.this.quirps.length; ++i) {
                    if (index >= (accruedchance += chances[i])) continue;
                    return QuirpOscillator.this.quirps[i];
                }
                return new ItemStack(Material.AIR);
            }

            private int[] getChances(BlockMenu menu) {
                ItemStack pol = menu.getItemInSlot(QuirpOscillator.this.getPolarizerSlot());
                if (SlimefunUtils.isItemSimilar((ItemStack)pol, (ItemStack)TEItems.VERTICAL_POLARIZER, (boolean)true)) {
                    return Polarizer.getChances(Polarizer.Type.VERTICAL);
                }
                if (SlimefunUtils.isItemSimilar((ItemStack)pol, (ItemStack)TEItems.HORIZONTAL_POLARIZER, (boolean)true)) {
                    return Polarizer.getChances(Polarizer.Type.HORIZONTAL);
                }
                return QuirpOscillator.this.chancesDefault;
            }

            public boolean isSynchronized() {
                return true;
            }
        };
    }
}

