/*
 * Decompiled with CFR 0.152.
 */
package me.sfiguz7.transcendence.implementation.items.items;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.sfiguz7.transcendence.TranscEndence;
import me.sfiguz7.transcendence.lists.TEItems;
import me.sfiguz7.transcendence.lists.TERecipeType;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Daxi
extends SlimefunItem {
    private final Type type;
    private static final TranscEndence INSTANCE = TranscEndence.getInstance();
    private static final FileConfiguration CONFIG = INSTANCE.getConfig();

    public Daxi(Type type) {
        super(TEItems.transcendence, type.slimefunItem, TERecipeType.NANOBOT_CRAFTER, type.recipe);
        this.type = type;
    }

    public void preRegister() {
        ItemUseHandler itemUseHandler = this::onItemRightClick;
        this.addItemHandler(new ItemHandler[]{itemUseHandler});
    }

    private void onItemRightClick(PlayerRightClickEvent event) {
        Player p = event.getPlayer();
        UUID uuid = p.getUniqueId();
        Map<UUID, Set<Type>> activePlayers = TranscEndence.getRegistry().getDaxiEffectPlayers();
        activePlayers.computeIfAbsent(uuid, k -> {
            HashSet set = new HashSet();
            return set;
        });
        Set<Type> effects = activePlayers.get(uuid);
        if (effects.contains((Object)this.type)) {
            p.sendMessage(ChatColor.LIGHT_PURPLE + CONFIG.getString("options.already-have-daxi-effect"));
            return;
        }
        effects.add(this.type);
        this.startAnimation(p);
        Daxi.applyEffect(p, this.type);
        p.sendMessage(ChatColor.LIGHT_PURPLE + CONFIG.getString("options.daxi-message-intro") + "\n" + this.type.message);
        event.cancel();
        event.getItem().setAmount(event.getItem().getAmount() - 1);
    }

    private void startAnimation(Player p) {
        int i;
        Location l = p.getLocation();
        int lasttick = 105;
        Location locas1 = l.clone().add(1.0, -0.8, 0.0);
        Location locas2 = l.clone().add(0.0, -0.8, 1.0);
        Location locas3 = l.clone().add(-1.0, -0.8, 0.0);
        Location locas4 = l.clone().add(0.0, -0.8, -1.0);
        ArmorStand as1 = (ArmorStand)p.getWorld().spawnEntity(locas1, EntityType.ARMOR_STAND);
        ArmorStand as2 = (ArmorStand)p.getWorld().spawnEntity(locas2, EntityType.ARMOR_STAND);
        ArmorStand as3 = (ArmorStand)p.getWorld().spawnEntity(locas3, EntityType.ARMOR_STAND);
        ArmorStand as4 = (ArmorStand)p.getWorld().spawnEntity(locas4, EntityType.ARMOR_STAND);
        Vector vas1 = new Vector(1.0, -0.8, 0.0);
        Vector vas2 = new Vector(1.0, -0.8, 1.0);
        Vector vas3 = new Vector(-1.0, -0.8, 0.0);
        Vector vas4 = new Vector(1.0, -0.8, -1.0);
        ArmorStand[] armorstands = new ArmorStand[]{as1, as2, as3, as4};
        Vector[] armorstandslocations = new Vector[]{vas1, vas2, vas3, vas4};
        for (ArmorStand as : armorstands) {
            TranscEndence.getRegistry().getDaxiArmorStands().add(as);
        }
        for (i = 0; i < 4; ++i) {
            armorstands[i].getEquipment().setHelmet(this.type.zotsAnimation[i]);
            armorstands[i].setSmall(true);
            armorstands[i].setCanPickupItems(false);
            armorstands[i].setVisible(false);
        }
        for (i = 0; i < lasttick; ++i) {
            INSTANCE.getServer().getScheduler().runTaskLater((Plugin)INSTANCE, () -> this.moveArmorStands(armorstands, armorstandslocations), (long)i);
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        INSTANCE.getServer().getScheduler().runTaskLater((Plugin)INSTANCE, () -> {
            for (ArmorStand armorStand : armorstands) {
                TranscEndence.getRegistry().getDaxiArmorStands().remove(armorStand);
                armorStand.remove();
            }
            for (ArmorStand armorStand : this.type.colors) {
                for (int i = 0; i < 25; ++i) {
                    float xRand = (random.nextFloat() - 0.5f) * 3.2f;
                    float yRand = (random.nextFloat() - 0.5f) * 3.2f;
                    float zRand = (random.nextFloat() - 0.5f) * 3.2f;
                    p.getWorld().spawnParticle(Particle.REDSTONE, l.getX() + (double)xRand, l.getY() + 2.0 + (double)yRand, l.getZ() + (double)zRand, i, (Object)new Particle.DustOptions((Color)armorStand, 1.0f));
                }
            }
            p.getWorld().playSound(l, Sound.ENTITY_ZOMBIE_VILLAGER_CURE, 1.0f, 1.0f);
        }, (long)lasttick);
    }

    private void moveArmorStands(ArmorStand[] as, Vector[] asv) {
        Vector yIncr = new Vector(0.0, 0.03, 0.0);
        for (int i = 0; i < 4; ++i) {
            Vector v = asv[i].clone().rotateAroundY(40.0).add(yIncr).subtract(asv[i]).normalize();
            as[i].setVelocity(v);
            asv[i] = asv[i].add(v);
        }
    }

    public static void applyEffect(Player p, Type type) {
        p.addPotionEffect(new PotionEffect(type.effect, Integer.MAX_VALUE, type.level));
    }

    public static void reapplyEffects(Player p) {
        UUID uuid;
        Map<UUID, Set<Type>> activePlayers = TranscEndence.getRegistry().getDaxiEffectPlayers();
        Set<Type> types = activePlayers.get(uuid = p.getUniqueId());
        if (types != null) {
            for (Type type : types) {
                Daxi.applyEffect(p, type);
            }
        }
    }

    static /* synthetic */ FileConfiguration access$600() {
        return CONFIG;
    }

    public static enum Type {
        STRENGTH(TEItems.DAXI_STRENGTH, new ItemStack[]{TEItems.ZOT_UP_2, TEItems.ZOT_UP_2, TEItems.ZOT_UP_2, TEItems.ZOT_UP_2}, new ItemStack[]{TEItems.ZOT_UP, TEItems.ZOT_UP, TEItems.ZOT_UP, TEItems.ZOT_UP}, new Color[]{Color.RED, Color.RED, Color.FUCHSIA, Color.FUCHSIA}, PotionEffectType.INCREASE_DAMAGE, Daxi.access$600().getInt("daxi-effects.strength-level"), Daxi.access$600().getString("options.daxi-message-strength")),
        ABSORPTION(TEItems.DAXI_ABSORPTION, new ItemStack[]{TEItems.ZOT_DOWN_2, TEItems.ZOT_DOWN_2, TEItems.ZOT_DOWN_2, TEItems.ZOT_DOWN_2}, new ItemStack[]{TEItems.ZOT_DOWN, TEItems.ZOT_DOWN, TEItems.ZOT_DOWN, TEItems.ZOT_DOWN}, new Color[]{Color.YELLOW, Color.YELLOW, Color.ORANGE, Color.ORANGE}, PotionEffectType.ABSORPTION, Daxi.access$600().getInt("daxi-effects.absorption-level"), Daxi.access$600().getString("options.daxi-message-absorption")),
        FORTITUDE(TEItems.DAXI_FORTITUDE, new ItemStack[]{TEItems.ZOT_LEFT_2, TEItems.ZOT_LEFT_2, TEItems.ZOT_LEFT_2, TEItems.ZOT_LEFT_2}, new ItemStack[]{TEItems.ZOT_LEFT, TEItems.ZOT_LEFT, TEItems.ZOT_LEFT, TEItems.ZOT_LEFT}, new Color[]{Color.LIME, Color.LIME, Color.GREEN, Color.GREEN}, PotionEffectType.DAMAGE_RESISTANCE, Daxi.access$600().getInt("daxi-effects.fortitude-level"), Daxi.access$600().getString("options.daxi-message-fortitude")),
        SATURATION(TEItems.DAXI_SATURATION, new ItemStack[]{TEItems.ZOT_RIGHT_2, TEItems.ZOT_RIGHT_2, TEItems.ZOT_RIGHT_2, TEItems.ZOT_RIGHT_2}, new ItemStack[]{TEItems.ZOT_RIGHT, TEItems.ZOT_RIGHT, TEItems.ZOT_RIGHT, TEItems.ZOT_RIGHT}, new Color[]{Color.AQUA, Color.AQUA, Color.TEAL, Color.TEAL}, PotionEffectType.SATURATION, Daxi.access$600().getInt("daxi-effects.saturation-level"), Daxi.access$600().getString("options.daxi-message-saturation")),
        REGENERATION(TEItems.DAXI_REGENERATION, new ItemStack[]{TEItems.ZOT_UP_2, TEItems.ZOT_LEFT_2, TEItems.ZOT_RIGHT_2, TEItems.ZOT_DOWN_2}, new ItemStack[]{TEItems.ZOT_UP, TEItems.ZOT_LEFT, TEItems.ZOT_RIGHT, TEItems.ZOT_DOWN}, new Color[]{Color.RED, Color.YELLOW, Color.LIME, Color.AQUA}, PotionEffectType.REGENERATION, Daxi.access$600().getInt("daxi-effects.regeneration-level"), Daxi.access$600().getString("options.daxi-message-regeneration"));

        private final SlimefunItemStack slimefunItem;
        private final ItemStack[] zotsAnimation;
        private final Color[] colors;
        private final ItemStack[] recipe;
        private final PotionEffectType effect;
        private final int level;
        private final String message;
        public static final Type[] values;

        private Type(SlimefunItemStack itemStack, ItemStack[] zots, ItemStack[] zotsAnimation, Color[] colors, PotionEffectType effect, int level, String message) {
            this.slimefunItem = itemStack;
            this.zotsAnimation = zotsAnimation;
            this.colors = colors;
            this.recipe = new ItemStack[]{TEItems.STABLE_BLOCK, zots[0], TEItems.STABLE_BLOCK, zots[1], TEItems.STABLE_INGOT, zots[2], TEItems.STABLE_BLOCK, zots[3], TEItems.STABLE_BLOCK};
            this.effect = effect;
            this.level = level - 1;
            this.message = message;
        }

        public int getTypeEffectLevel() {
            return this.level;
        }

        static {
            values = Type.values();
        }
    }
}

