/*
 * Decompiled with CFR 0.152.
 */
package me.sfiguz7.transcendence.implementation.items.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Arrays;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.sfiguz7.transcendence.TranscEndence;
import me.sfiguz7.transcendence.implementation.utils.interfaces.TEInventoryBlock;
import me.sfiguz7.transcendence.lists.TEItems;
import me.sfiguz7.transcendence.lists.TERecipeType;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class ZotOverloader
extends SimpleSlimefunItem<BlockTicker>
implements TEInventoryBlock,
EnergyNetComponent {
    private static final int ENERGY_CONSUMPTION = 1024;
    private static final int ZOT_SLOT = 25;
    private final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private final int[] inputBorder = new int[]{9, 10, 11, 12, 13, 14, 18, 23, 27, 28, 29, 30, 31, 32};
    private final int[] slotsBorder = new int[]{15, 16, 17, 24, 26, 33, 34, 35};
    private final ItemStack[] allowedSlotsItems = new ItemStack[]{TEItems.ZOT_UP, TEItems.ZOT_DOWN, TEItems.ZOT_LEFT, TEItems.ZOT_RIGHT};
    private final ItemStack[] allowedInputItems = new ItemStack[]{TEItems.QUIRP_UP, TEItems.QUIRP_DOWN, TEItems.QUIRP_LEFT, TEItems.QUIRP_RIGHT};

    public ZotOverloader() {
        super(TEItems.transcendence, TEItems.ZOT_OVERLOADER, TERecipeType.NANOBOT_CRAFTER, new ItemStack[]{TEItems.QUIRP_CONDENSATE, TEItems.QUIRP_UP, TEItems.QUIRP_CONDENSATE, TEItems.QUIRP_LEFT, TEItems.STABLE_BLOCK, TEItems.QUIRP_RIGHT, TEItems.QUIRP_CONDENSATE, TEItems.QUIRP_DOWN, TEItems.QUIRP_CONDENSATE});
        this.createPreset((SlimefunItem)this, this::constructMenu);
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : this.border) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.inputBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.slotsBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{19, 20, 21, 22};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 2048;
    }

    public BlockTicker getItemHandler() {
        return new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                if (b.getWorld().getEnvironment() != World.Environment.THE_END) {
                    return;
                }
                if (ZotOverloader.this.getCharge(b.getLocation()) >= 1024) {
                    BlockMenu menu = BlockStorage.getInventory((Block)b);
                    ItemStack zot = menu.getItemInSlot(25);
                    if (!this.isValidProduct(zot)) {
                        return;
                    }
                    int requiredCharge = TranscEndence.getInstance().getZotRequiredCharge();
                    NamespacedKey chargeKey = new NamespacedKey((Plugin)TranscEndence.getInstance(), "charge");
                    ItemMeta zotMeta = zot.getItemMeta();
                    int zotCharge = PersistentDataAPI.getInt((PersistentDataHolder)zotMeta, (NamespacedKey)chargeKey);
                    if (zotCharge >= requiredCharge) {
                        return;
                    }
                    this.processInputSlots(b, menu, zot, zotMeta, zotCharge, chargeKey, requiredCharge);
                }
            }

            private boolean isValidProduct(ItemStack zot) {
                return zot != null && ZotOverloader.this.isAllowed(zot, ZotOverloader.this.allowedSlotsItems) && zot.getAmount() == 1;
            }

            private void processInputSlots(Block b, BlockMenu menu, ItemStack zot, ItemMeta zotMeta, int zotCharge, NamespacedKey chargeKey, int requiredCharge) {
                for (int inputSlot : ZotOverloader.this.getInputSlots()) {
                    ItemStack inputItem = menu.getItemInSlot(inputSlot);
                    if (!this.isValidInput(inputItem)) continue;
                    String inpSpin = inputItem.getItemMeta().getDisplayName().split(" ")[1];
                    String zotSpin = zot.getItemMeta().getDisplayName().split(" ")[1];
                    int inpToBeRemoved = ZotOverloader.this.inpRemoveCalc(inpSpin, zotSpin);
                    if (inputItem.getAmount() < inpToBeRemoved) break;
                    this.handleInputRemoval(b, menu, zot, zotMeta, zotCharge, chargeKey, requiredCharge, inputSlot, inputItem, inpToBeRemoved);
                    break;
                }
            }

            private boolean isValidInput(ItemStack inputItem) {
                return inputItem != null && ZotOverloader.this.isAllowed(inputItem, ZotOverloader.this.allowedInputItems);
            }

            private void handleInputRemoval(Block b, BlockMenu menu, ItemStack zot, ItemMeta zotMeta, int zotCharge, NamespacedKey chargeKey, int requiredCharge, int inputSlot, ItemStack inputItem, int inpToBeRemoved) {
                if (zotCharge == requiredCharge - 1) {
                    menu.replaceExistingItem(25, ZotOverloader.this.getZot(zotMeta.getDisplayName().split(" ")[1]));
                } else {
                    this.updateZotMeta(zotMeta, zotCharge, requiredCharge);
                }
                PersistentDataAPI.setInt((PersistentDataHolder)zotMeta, (NamespacedKey)chargeKey, (int)zotCharge);
                zot.setItemMeta(zotMeta);
                ZotOverloader.this.removeCharge(b.getLocation(), 1024);
                if (inputItem.getAmount() == inpToBeRemoved) {
                    menu.replaceExistingItem(inputSlot, null);
                } else {
                    inputItem.setAmount(inputItem.getAmount() - inpToBeRemoved);
                }
            }

            private void updateZotMeta(ItemMeta zotMeta, int zotCharge, int requiredCharge) {
                zotMeta.setLore(Arrays.asList(ChatColor.BLUE + "Concentrated matter", ChatColor.GRAY + "Charge: " + ChatColor.YELLOW + ++zotCharge + "/" + requiredCharge));
            }

            public boolean isSynchronized() {
                return true;
            }
        };
    }

    private boolean isAllowed(ItemStack item, ItemStack[] allowed) {
        for (ItemStack i : allowed) {
            if (!SlimefunUtils.isItemSimilar((ItemStack)item, (ItemStack)i, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private ItemStack getZot(String zotSpin) {
        if (zotSpin.compareTo("Up") == 0) {
            return TEItems.ZOT_UP_2;
        }
        if (zotSpin.compareTo("Down") == 0) {
            return TEItems.ZOT_DOWN_2;
        }
        if (zotSpin.compareTo("Left") == 0) {
            return TEItems.ZOT_LEFT_2;
        }
        return TEItems.ZOT_RIGHT_2;
    }

    private int inpRemoveCalc(String inpSpin, String zotSpin) {
        int inpToBeRemoved = 1;
        if (inpSpin.compareTo(zotSpin) != 0) {
            inpToBeRemoved = 16;
        }
        return inpToBeRemoved;
    }

    public BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
                Block b = e.getBlock();
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), ZotOverloader.this.getInputSlots());
                    inv.dropItems(b.getLocation(), ZotOverloader.this.getOutputSlots());
                }
            }
        };
    }
}

