/*
 * Decompiled with CFR 0.152.
 */
package me.sfiguz7.transcendence.implementation.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.sfiguz7.transcendence.TranscEndence;
import me.sfiguz7.transcendence.implementation.items.items.Daxi;

public class SaveUtils {
    private static final File path = TranscEndence.getInstance().getDataFolder();
    private static final File daxiEffectPlayersFile = new File(path, "daxiEffectPlayers.dat");
    private static final File toggledPlayersFile = new File(path, "toggledPlayers.dat");

    public static void writeData() {
        DataOutputStream dos;
        try {
            dos = new DataOutputStream(new FileOutputStream(daxiEffectPlayersFile));
            try {
                Map<UUID, Set<Daxi.Type>> daxiEffectPlayers = TranscEndence.getRegistry().getDaxiEffectPlayers();
                dos.writeInt(daxiEffectPlayers.size());
                for (Map.Entry<UUID, Set<Daxi.Type>> entry : daxiEffectPlayers.entrySet()) {
                    dos.writeLong(entry.getKey().getMostSignificantBits());
                    dos.writeLong(entry.getKey().getLeastSignificantBits());
                    Set<Daxi.Type> types = entry.getValue();
                    dos.writeByte(types.size());
                    for (Daxi.Type type : types) {
                        dos.writeByte(type.ordinal());
                    }
                }
                dos.flush();
            }
            finally {
                dos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            dos = new DataOutputStream(new FileOutputStream(toggledPlayersFile));
            try {
                Set<UUID> toggledPlayers = TranscEndence.getRegistry().getToggledPlayers();
                dos.writeInt(toggledPlayers.size());
                for (UUID uuid : toggledPlayers) {
                    dos.writeLong(uuid.getMostSignificantBits());
                    dos.writeLong(uuid.getLeastSignificantBits());
                }
                dos.flush();
            }
            finally {
                dos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void readData() {
        int i;
        int size;
        DataInputStream dis;
        if (daxiEffectPlayersFile.exists()) {
            try {
                dis = new DataInputStream(new FileInputStream(daxiEffectPlayersFile));
                try {
                    Map<UUID, Set<Daxi.Type>> daxiEffectPlayers = TranscEndence.getRegistry().getDaxiEffectPlayers();
                    size = dis.readInt();
                    for (i = 0; i < size; ++i) {
                        UUID uuid = new UUID(dis.readLong(), dis.readLong());
                        int len = dis.readByte();
                        HashSet<Daxi.Type> types = new HashSet<Daxi.Type>();
                        for (int typeI = 0; typeI < len; ++typeI) {
                            types.add(Daxi.Type.values[dis.readByte()]);
                        }
                        daxiEffectPlayers.put(uuid, types);
                    }
                }
                finally {
                    dis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (toggledPlayersFile.exists()) {
            try {
                dis = new DataInputStream(new FileInputStream(toggledPlayersFile));
                try {
                    Set<UUID> toggledPlayers = TranscEndence.getRegistry().getToggledPlayers();
                    size = dis.readInt();
                    for (i = 0; i < size; ++i) {
                        toggledPlayers.add(new UUID(dis.readLong(), dis.readLong()));
                    }
                }
                finally {
                    dis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

