/*
 * Decompiled with CFR 0.152.
 */
package me.sfiguz7.transcendence.implementation.items.machines;

import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.sfiguz7.transcendence.TranscEndence;
import me.sfiguz7.transcendence.lists.TEItems;
import me.sfiguz7.transcendence.lists.TERecipeType;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class ZotOverloader
extends SimpleSlimefunItem<BlockTicker>
implements InventoryBlock,
EnergyNetComponent {
    private static final int ENERGY_CONSUMPTION = 1024;
    private final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private final int[] inputBorder = new int[]{9, 10, 11, 12, 13, 14, 18, 23, 27, 28, 29, 30, 31, 32};
    private final int[] slotsBorder = new int[]{15, 16, 17, 24, 26, 33, 34, 35};
    private final ItemStack[] allowedSlotsItems = new ItemStack[]{TEItems.ZOT_UP, TEItems.ZOT_DOWN, TEItems.ZOT_LEFT, TEItems.ZOT_RIGHT};
    private final ItemStack[] allowedInputItems = new ItemStack[]{TEItems.QUIRP_UP, TEItems.QUIRP_DOWN, TEItems.QUIRP_LEFT, TEItems.QUIRP_RIGHT};

    public ZotOverloader() {
        super(TEItems.transcendence, TEItems.ZOT_OVERLOADER, TERecipeType.NANOBOT_CRAFTER, new ItemStack[]{TEItems.QUIRP_CONDENSATE, TEItems.QUIRP_UP, TEItems.QUIRP_CONDENSATE, TEItems.QUIRP_LEFT, TEItems.QUIRP_OSCILLATOR, TEItems.QUIRP_RIGHT, TEItems.QUIRP_CONDENSATE, TEItems.QUIRP_DOWN, TEItems.QUIRP_CONDENSATE});
        this.createPreset((SlimefunItem)this, this::constructMenu);
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : this.border) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.inputBorder) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.slotsBorder) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.RED_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
    }

    public int[] getInputSlots() {
        return new int[]{19, 20, 21, 22};
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    private int getSlot() {
        return 25;
    }

    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 2048;
    }

    public BlockTicker getItemHandler() {
        return new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                if (b.getWorld().getEnvironment() != World.Environment.THE_END) {
                    return;
                }
                if (ChargableBlock.getCharge((Block)b) >= 1024) {
                    int zotCharge;
                    BlockMenu menu = BlockStorage.getInventory((Block)b);
                    ItemStack zot = menu.getItemInSlot(ZotOverloader.this.getSlot());
                    if (zot == null || !ZotOverloader.this.isAllowed(zot, ZotOverloader.this.allowedSlotsItems) || zot.getAmount() != 1) {
                        return;
                    }
                    int requiredCharge = 1000;
                    NamespacedKey chargeKey = new NamespacedKey((Plugin)TranscEndence.getInstance(), "charge");
                    ItemMeta zotMeta = zot.getItemMeta();
                    if (!PersistentDataAPI.hasInt((PersistentDataHolder)zotMeta, (NamespacedKey)chargeKey)) {
                        PersistentDataAPI.setInt((PersistentDataHolder)zotMeta, (NamespacedKey)chargeKey, (int)0);
                    }
                    if ((zotCharge = PersistentDataAPI.getInt((PersistentDataHolder)zotMeta, (NamespacedKey)chargeKey)) >= requiredCharge) {
                        return;
                    }
                    ItemStack[] input = new ItemStack[4];
                    int j = 0;
                    for (int i : ZotOverloader.this.getInputSlots()) {
                        input[j] = menu.getItemInSlot(i);
                        if (input[j] == null) {
                            ++j;
                            continue;
                        }
                        NamespacedKey slotKey = new NamespacedKey((Plugin)TranscEndence.getInstance(), "slot");
                        ItemMeta itemMeta = input[j].getItemMeta();
                        PersistentDataAPI.setInt((PersistentDataHolder)itemMeta, (NamespacedKey)slotKey, (int)i);
                        input[j].setItemMeta(itemMeta);
                        ++j;
                    }
                    for (ItemStack inp : input) {
                        if (inp == null || !ZotOverloader.this.isAllowed(inp, ZotOverloader.this.allowedInputItems)) continue;
                        String inpSpin = inp.getItemMeta().getDisplayName().split(" ")[1];
                        String zotSpin = zot.getItemMeta().getDisplayName().split(" ")[1];
                        int inpToBeRemoved = ZotOverloader.this.inpRemoveCalc(inpSpin, zotSpin);
                        if (inp.getAmount() < inpToBeRemoved) continue;
                        NamespacedKey slotKey = new NamespacedKey((Plugin)TranscEndence.getInstance(), "slot");
                        ItemMeta inpMeta = inp.getItemMeta();
                        int slot = PersistentDataAPI.getInt((PersistentDataHolder)inpMeta, (NamespacedKey)slotKey);
                        List lore = zot.getItemMeta().getLore();
                        if (zotCharge == requiredCharge - 1) {
                            menu.replaceExistingItem(ZotOverloader.this.getSlot(), ZotOverloader.this.getZot(zotSpin));
                        } else {
                            lore.set(1, lore.get(1).toString().split(": ")[0] + ": " + ChatColor.YELLOW + ++zotCharge + "/" + requiredCharge);
                            zotMeta.setLore(lore);
                        }
                        PersistentDataAPI.setInt((PersistentDataHolder)zotMeta, (NamespacedKey)chargeKey, (int)zotCharge);
                        zot.setItemMeta(zotMeta);
                        ChargableBlock.addCharge((Block)b, (int)-1024);
                        if (inp.getAmount() == inpToBeRemoved) {
                            menu.replaceExistingItem(slot, null);
                            break;
                        }
                        inp.setAmount(inp.getAmount() - inpToBeRemoved);
                        break;
                    }
                }
            }

            public boolean isSynchronized() {
                return true;
            }
        };
    }

    private boolean isAllowed(ItemStack item, ItemStack[] allowed) {
        for (ItemStack i : allowed) {
            if (!SlimefunUtils.isItemSimilar((ItemStack)item, (ItemStack)i, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private ItemStack getZot(String zotSpin) {
        if (zotSpin.compareTo("Up") == 0) {
            return TEItems.ZOT_UP_2;
        }
        if (zotSpin.compareTo("Down") == 0) {
            return TEItems.ZOT_DOWN_2;
        }
        if (zotSpin.compareTo("Left") == 0) {
            return TEItems.ZOT_LEFT_2;
        }
        return TEItems.ZOT_RIGHT_2;
    }

    private int inpRemoveCalc(String inpSpin, String zotSpin) {
        int inpToBeRemoved = 1;
        if (inpSpin.compareTo(zotSpin) != 0) {
            inpToBeRemoved = 16;
        }
        return inpToBeRemoved;
    }
}

