/*
 * Decompiled with CFR 0.152.
 */
package dev.walshy.sfdebug.commands;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class DumpCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("Usage: /dump <threads> [options]");
        } else if (args[0].equalsIgnoreCase("threads")) {
            boolean stack = this.hasArgument(args, "stack", "s");
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                Thread thread = entry.getKey();
                StackTraceElement[] stackTrace = entry.getValue();
                sb.append(thread.getName()).append(" (").append((Object)thread.getState()).append(")").append((String)(thread.getThreadGroup() != null ? " - " + thread.getThreadGroup().getName() : "")).append("\n");
                if (!stack) continue;
                for (StackTraceElement element : stackTrace) {
                    sb.append("    ").append(element).append("\n");
                }
            }
            sender.sendMessage(sb.toString());
        }
        return true;
    }

    private boolean hasArgument(String[] args, String arg) {
        return this.hasArgument(args, arg, null);
    }

    private boolean hasArgument(@Nonnull String[] args, @Nonnull String arg, @Nullable String shorthand) {
        for (String s : args) {
            if (!s.equalsIgnoreCase(arg) && (shorthand == null || !s.equalsIgnoreCase(shorthand))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private String getArgument(String[] args, String arg) {
        return this.getArgument(args, arg, null);
    }

    @Nullable
    private String getArgument(@Nonnull String[] args, @Nonnull String arg, @Nullable String shorthand) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(arg) && (shorthand == null || !args[i].equalsIgnoreCase(shorthand)) || i + 1 >= args.length) continue;
            return args[i + 1];
        }
        return null;
    }
}

