/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme;

import com.github.relativobr.supreme.Supreme;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.localization.Localization;
import net.guizhanss.guizhanlib.utils.ChatUtil;
import net.guizhanss.guizhanlib.utils.StringUtil;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SupremeLocalization
extends Localization {
    public SupremeLocalization(Supreme plugin) {
        super(plugin);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public String getString(String key, Object ... args) {
        return MessageFormat.format(this.getString(key), args);
    }

    @Nonnull
    public String getCategoryName(@Nonnull String categoryId) {
        Validate.notNull((Object)categoryId, (String)"Category Id cannot be null");
        return this.getString("categories." + StringUtil.dehumanize(categoryId).toLowerCase(Locale.ROOT));
    }

    @Nonnull
    public String getItemName(@Nonnull String itemId) {
        Validate.notNull((Object)itemId, (String)"Item Id cannot be null");
        return this.getString("items." + StringUtil.dehumanize(itemId).toLowerCase(Locale.ROOT) + ".name");
    }

    @Nonnull
    public String[] getItemLore(@Nonnull String itemId) {
        Validate.notNull((Object)itemId, (String)"Item Id cannot be null");
        return this.getStringArray("items." + StringUtil.dehumanize(itemId).toLowerCase(Locale.ROOT) + ".lore");
    }

    @Nonnull
    public String getResearchName(@Nonnull String researchId) {
        Validate.notNull((Object)researchId, (String)"Research Id cannot be null");
        return this.getString("researches." + StringUtil.dehumanize(researchId).toLowerCase(Locale.ROOT));
    }

    @ParametersAreNonnullByDefault
    public void sendMessage(Player p, String messageKey, Object ... args) {
        Validate.notNull((Object)p, (String)"Player cannot be null");
        Validate.notNull((Object)messageKey, (String)"Message key cannot be null");
        ChatUtil.send((CommandSender)p, MessageFormat.format(this.getString("messages." + messageKey), args));
    }

    @ParametersAreNonnullByDefault
    public void sendActionbarMessage(Player p, String messageKey, Object ... args) {
        Validate.notNull((Object)p, (String)"Player cannot be null");
        Validate.notNull((Object)messageKey, (String)"Message key cannot be null");
        String message = MessageFormat.format(this.getString("messages." + messageKey), args);
        BaseComponent[] components = TextComponent.fromLegacyText((String)ChatUtil.color(message));
        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
    }
}

