/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.generic.machine;

import com.github.relativobr.supreme.Supreme;
import com.github.relativobr.supreme.generic.recipe.AbstractItemRecipe;
import com.github.relativobr.supreme.generic.recipe.InventoryRecipe;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotHopperable;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class GenericMachine
extends AContainer
implements NotHopperable,
RecipeDisplayItem {
    private final Map<Block, MachineRecipe> processing = new HashMap<Block, MachineRecipe>();
    private final Map<Block, Integer> progressTime = new HashMap<Block, Integer>();
    private final Map<Block, Map<ItemStack, Integer>> consumedItemsMap = new HashMap<Block, Map<ItemStack, Integer>>();
    private final Map<Block, Integer> attemptCount = new HashMap<Block, Integer>();
    public List<AbstractItemRecipe> machineRecipes = new ArrayList<AbstractItemRecipe>();
    private Integer timeProcess;
    private String machineIdentifier = "MediumContainerMachine";

    @ParametersAreNonnullByDefault
    public GenericMachine(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{this.onBlockBreak()});
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                GenericMachine.this.constructMenu(this);
            }

            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return GenericMachine.this.getOutputSlots();
                }
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return GenericMachine.this.getOutputSlots();
                }
                int fullSlots = 0;
                LinkedList<Integer> slots = new LinkedList<Integer>();
                for (int slot : GenericMachine.this.getInputSlots()) {
                    ItemStack stack = menu.getItemInSlot(slot);
                    if (stack == null || !SlimefunUtils.isItemSimilar((ItemStack)stack, (ItemStack)item, (boolean)false, (boolean)true)) continue;
                    if (stack.getAmount() >= stack.getMaxStackSize()) {
                        ++fullSlots;
                    }
                    slots.add(slot);
                }
                if (slots.isEmpty()) {
                    return GenericMachine.this.getInputSlots();
                }
                if (fullSlots == slots.size()) {
                    return new int[0];
                }
                slots.sort(GenericMachine.this.compareSlots(menu));
                int[] array = new int[slots.size()];
                for (int i = 0; i < slots.size(); ++i) {
                    array[i] = (Integer)slots.get(i);
                }
                return array;
            }
        };
    }

    @Nonnull
    protected BlockBreakHandler onBlockBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    GenericMachine.this.revertConsumedItem(b, inv);
                    inv.dropItems(b.getLocation(), GenericMachine.this.getInputSlots());
                    inv.dropItems(b.getLocation(), GenericMachine.this.getOutputSlots());
                }
                GenericMachine.this.removeMapBlock(b);
            }
        };
    }

    protected void updateStatusReset(BlockMenu menu) {
        menu.replaceExistingItem(this.getStatusSlot(), this.getDisplayOrInfo(null, " "));
    }

    protected void updateStatusInvalidInput(BlockMenu menu) {
        menu.replaceExistingItem(this.getStatusSlot(), this.getDisplayOrWarn(null, "&cInput a valid material to start"));
    }

    protected void updateStatusOutputFull(BlockMenu menu) {
        menu.replaceExistingItem(this.getStatusSlot(), this.getDisplayOrWarn(null, "&cOutput is full"));
    }

    protected void updateStatusConnectEnergy(BlockMenu menu, ItemStack itemStack) {
        menu.replaceExistingItem(this.getStatusSlot(), this.getDisplayOrWarn(itemStack, "&cConnect energy to continue"));
    }

    protected void updateStatusLoadMaterial(BlockMenu menu, ItemStack itemStack, int attempts, int progressCount, int totalProgress) {
        CustomItemStack infoDetail = new CustomItemStack(itemStack, "&cLoad more material to start", new String[]{"", "&7Attempts: &e" + attempts + " &7/ &e" + Supreme.getSupremeOptions().getMachineMaxAttemptConsumed(), "&7Progress: &e" + progressCount + " &7/ &e" + totalProgress, ""});
        menu.replaceExistingItem(this.getStatusSlot(), (ItemStack)infoDetail);
    }

    public GenericMachine setMachineRecipes(@Nonnull List<AbstractItemRecipe> machineRecipes) {
        this.machineRecipes = machineRecipes;
        return this;
    }

    public GenericMachine setTimeProcess(int timeProcess) {
        this.timeProcess = timeProcess;
        return this;
    }

    public int getTimeProcess() {
        if (this.timeProcess == null) {
            this.timeProcess = 15;
        }
        return this.timeProcess;
    }

    @Nonnull
    private Comparator<Integer> compareSlots(@Nonnull DirtyChestMenu menu) {
        return Comparator.comparingInt(slot -> menu.getItemInSlot(slot.intValue()).getAmount());
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : this.getBorderSlots()) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getInputBorderSlots()) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.CYAN_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getOutputBorderSlots()) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(this.getStatusSlot(), (ItemStack)new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    if (cursor == null) {
                        return true;
                    }
                    return cursor.getType() == Material.AIR;
                }
            });
        }
    }

    public ItemStack getProgressBar() {
        return new ItemStack(Material.PISTON);
    }

    public int[] getInputSlots() {
        return InventoryRecipe.MEDIUM_INPUT;
    }

    public int[] getOutputSlots() {
        return InventoryRecipe.MEDIUM_OUTPUT;
    }

    public int getStatusSlot() {
        return 23;
    }

    public int[] getBorderSlots() {
        return InventoryRecipe.MEDIUM_BORDER;
    }

    public int[] getInputBorderSlots() {
        return InventoryRecipe.MEDIUM_INPUT_BORDER;
    }

    public int[] getOutputBorderSlots() {
        return InventoryRecipe.MEDIUM_OUTPUT_BORDER;
    }

    @Nonnull
    public String getMachineIdentifier() {
        return Objects.nonNull(this.machineIdentifier) ? this.machineIdentifier : "MachineIdentifier";
    }

    public GenericMachine setMachineIdentifier(@Nonnull String machineIdentifier) {
        this.machineIdentifier = machineIdentifier;
        return this;
    }

    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        if (inv == null) {
            return;
        }
        if (this.isProcessing(b)) {
            this.doProcessing(b, inv);
        } else {
            this.nextProcessing(b, inv);
        }
    }

    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>();
        this.machineRecipes.forEach(recipe -> {
            displayRecipes.add((ItemStack)new CustomItemStack(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]));
            displayRecipes.add(recipe.getFirstItemOutput());
        });
        return displayRecipes;
    }

    protected MachineRecipe findNextRecipe(BlockMenu inv) {
        for (AbstractItemRecipe recipe : this.machineRecipes) {
            if (!this.matchingRecipe(recipe.getInputNotNull(), inv)) continue;
            return new MachineRecipe(this.getTimeProcess(), recipe.getInputNotNull(), recipe.getOutputNotNull());
        }
        return null;
    }

    protected int getProgressTime(Block b) {
        return this.progressTime.get(b) != null ? this.progressTime.get(b).intValue() : this.getTimeProcess();
    }

    protected MachineRecipe getProcessing(Block b) {
        return this.processing.get(b);
    }

    protected Map<ItemStack, Integer> getConsumedItems(Block b) {
        return this.consumedItemsMap.get(b);
    }

    protected boolean isProcessing(Block b) {
        return this.getProcessing(b) != null;
    }

    protected boolean notHasSpaceOutput(BlockMenu inv, ItemStack[] result) {
        int requiredSpace = result.length;
        int availableSpace = 0;
        for (int slot : this.getOutputSlots()) {
            ItemStack itemInSlot = inv.getItemInSlot(slot);
            if (itemInSlot == null) {
                ++availableSpace;
            } else {
                for (ItemStack stack : result) {
                    if (!SlimefunUtils.isItemSimilar((ItemStack)itemInSlot, (ItemStack)stack, (boolean)false, (boolean)false) || itemInSlot.getAmount() >= itemInSlot.getMaxStackSize()) continue;
                    ++availableSpace;
                    break;
                }
            }
            if (availableSpace < requiredSpace) continue;
            return false;
        }
        return true;
    }

    private void nextProcessing(Block b, BlockMenu inv) {
        MachineRecipe next = this.findNextRecipe(inv);
        if (next != null) {
            this.processing.put(b, next);
            this.progressTime.put(b, next.getTicks());
            this.consumedItemsMap.put(b, new HashMap());
            this.attemptCount.put(b, 0);
        } else if (this.getInputSlots().length <= 5) {
            this.updateStatusReset(inv);
        } else {
            this.updateStatusInvalidInput(inv);
        }
    }

    private void removeMapBlock(Block b) {
        this.progressTime.remove(b);
        this.processing.remove(b);
        this.attemptCount.remove(b);
        this.consumedItemsMap.remove(b);
    }

    private void doProcessing(Block b, BlockMenu inv) {
        ItemStack[] result = this.getProcessing(b).getOutput();
        if (result == null || result.length == 0) {
            this.removeMapBlock(b);
            this.updateStatusReset(inv);
            return;
        }
        if (this.getCharge(b.getLocation()) < this.getEnergyConsumption()) {
            this.updateStatusConnectEnergy(inv, null);
            return;
        }
        this.removeCharge(b.getLocation(), this.getEnergyConsumption());
        int ticks = this.getProcessing(b).getTicks();
        int ticksRemaining = this.getProgressTime(b);
        if (ticks == ticksRemaining) {
            this.startProcessTicks(b, inv, ticksRemaining);
        } else if (ticksRemaining == 0) {
            this.endProcessTicks(b, inv, result);
        } else {
            this.doProcessTicks(b, inv, ticks, ticksRemaining, result[0]);
        }
    }

    private void startProcessTicks(Block b, BlockMenu inv, int ticksRemaining) {
        int attempts = this.attemptCount.getOrDefault(b, 0) + 1;
        if (this.consumptionRecipe(b, inv)) {
            this.progressTime.put(b, Math.max(ticksRemaining - this.getSpeed(), 0));
            this.attemptCount.put(b, 0);
            this.consumedItemsMap.put(b, new HashMap());
        } else if (attempts >= Supreme.getSupremeOptions().getMachineMaxAttemptConsumed()) {
            this.revertConsumedItem(b, inv);
            this.removeMapBlock(b);
            this.updateStatusInvalidInput(inv);
        } else {
            this.attemptCount.put(b, attempts);
            int progressCount = this.getConsumedItems(b).values().stream().mapToInt(Integer::intValue).sum();
            int totalProgress = Arrays.stream(this.getProcessing(b).getInput()).mapToInt(ItemStack::getAmount).sum();
            this.updateStatusLoadMaterial(inv, this.getProcessing(b).getOutput()[0], attempts, progressCount, totalProgress);
        }
    }

    private void revertConsumedItem(Block b, BlockMenu inv) {
        for (Map.Entry<ItemStack, Integer> consumedEntry : this.getConsumedItems(b).entrySet()) {
            int stackSize;
            ItemStack consumedItem = consumedEntry.getKey();
            if (consumedItem == null || consumedItem.getType() == Material.AIR) continue;
            int maxStackSize = consumedItem.getMaxStackSize();
            for (int amount = consumedEntry.getValue().intValue(); amount > 0; amount -= stackSize) {
                stackSize = Math.min(maxStackSize, amount);
                ItemStack returnItem = consumedItem.clone();
                returnItem.setAmount(stackSize);
                inv.pushItem(returnItem, this.getInputSlots());
            }
        }
        this.getConsumedItems(b).clear();
    }

    private void endProcessTicks(Block b, BlockMenu inv, ItemStack[] result) {
        if (this.notHasSpaceOutput(inv, result)) {
            this.updateStatusOutputFull(inv);
            return;
        }
        for (ItemStack itemStack : result) {
            inv.pushItem(itemStack.clone(), this.getOutputSlots());
        }
        this.removeMapBlock(b);
        this.updateStatusReset(inv);
    }

    private void doProcessTicks(Block b, BlockMenu inv, int ticks, int ticksRemaining, ItemStack result) {
        this.progressTime.put(b, Math.max(ticksRemaining - this.getSpeed(), 0));
        ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)this.getStatusSlot(), (int)ticksRemaining, (int)ticks, (ItemStack)result);
    }

    private boolean consumptionRecipe(Block b, BlockMenu inv) {
        HashMap<ItemStack, Integer> requiredItems = new HashMap<ItemStack, Integer>();
        for (ItemStack item : this.getProcessing(b).getInput()) {
            requiredItems.merge(item.clone(), item.getAmount(), Integer::sum);
        }
        boolean consumeFailure = false;
        for (Map.Entry entry : requiredItems.entrySet()) {
            ItemStack requiredItem = (ItemStack)entry.getKey();
            int requiredAmount = (Integer)entry.getValue();
            int foundAmount = 0;
            for (Map.Entry<ItemStack, Integer> consumedEntry : this.getConsumedItems(b).entrySet()) {
                if (!SlimefunUtils.isItemSimilar((ItemStack)consumedEntry.getKey(), (ItemStack)requiredItem, (boolean)false, (boolean)false)) continue;
                foundAmount += consumedEntry.getValue().intValue();
            }
            for (Object slot : (Object)this.getInputSlots()) {
                ItemStack inputItem;
                if (inv.getItemInSlot((int)slot) == null || !SlimefunUtils.isItemSimilar((ItemStack)(inputItem = inv.getItemInSlot((int)slot).clone()), (ItemStack)requiredItem, (boolean)false, (boolean)false)) continue;
                int amountToConsume = Math.min(inputItem.getAmount(), requiredAmount - foundAmount);
                if (amountToConsume > 0) {
                    inv.consumeItem((int)slot, amountToConsume);
                    this.getConsumedItems(b).merge(inputItem, amountToConsume, Integer::sum);
                }
                if ((foundAmount += amountToConsume) >= requiredAmount) break;
            }
            if (foundAmount >= requiredAmount) continue;
            consumeFailure = true;
            break;
        }
        return !consumeFailure;
    }

    private boolean matchingRecipe(ItemStack[] recipe, BlockMenu inv) {
        HashSet<ItemStack> uniqueItems = new HashSet<ItemStack>(Arrays.asList(recipe));
        return uniqueItems.stream().allMatch(item -> this.isItemPresentInSlots((ItemStack)item, inv));
    }

    private boolean isItemPresentInSlots(ItemStack item, BlockMenu inv) {
        for (int slot : this.getInputSlots()) {
            ItemStack itemInSlot = inv.getItemInSlot(slot);
            if (itemInSlot == null || !SlimefunUtils.isItemSimilar((ItemStack)itemInSlot, (ItemStack)item, (boolean)false, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private ItemStack getDisplayOrInfo(ItemStack itemStack, String name) {
        return new CustomItemStack(itemStack != null ? itemStack : new ItemStack(Material.BLACK_STAINED_GLASS_PANE), name, new String[0]);
    }

    private ItemStack getDisplayOrWarn(ItemStack itemStack, String name) {
        return new CustomItemStack(itemStack != null ? itemStack : new ItemStack(Material.RED_STAINED_GLASS_PANE), name, new String[0]);
    }
}

