/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.generators;

import com.github.relativobr.supreme.resource.SupremeComponents;
import com.github.relativobr.supreme.util.ItemGroups;
import com.github.relativobr.supreme.util.ItemUtil;
import com.github.relativobr.supreme.util.SupremeItemStack;
import com.github.relativobr.supreme.util.UtilEnergy;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineTier;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.AbstractEnergyProvider;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Sheep;
import org.bukkit.inventory.ItemStack;

public class GeneratorMob
extends AbstractEnergyProvider {
    public static final int BASIC_GENERATOR_MOB_ENERGY = 50;
    public static final int BASIC_GENERATOR_MOB_BUFFER = 1000;
    public static final int MEDIUM_GENERATOR_MOB_ENERGY = 200;
    public static final int MEDIUM_GENERATOR_MOB_BUFFER = 4000;
    public static final int ADVANCED_GENERATOR_MOB_ENERGY = 800;
    public static final int ADVANCED_GENERATOR_MOB_BUFFER = 16000;
    public static final SlimefunItemStack GENERATOR_MOB_BASIC = new SupremeItemStack("SUPREME_GENERATOR_MOB_BASIC", Material.COMPOSTER, false, LoreBuilder.machine((MachineTier)MachineTier.BASIC, (MachineType)MachineType.GENERATOR), UtilEnergy.energyBuffer(ItemUtil.getValueGeneratorsWithLimit(1000)), UtilEnergy.energyPowerPerSecond(ItemUtil.getValueGeneratorsWithLimit(50)));
    public static final ItemStack[] RECIPE_GENERATOR_MOB_BASIC = new ItemStack[]{SlimefunItems.SMALL_CAPACITOR, SlimefunItems.SILICON, SlimefunItems.SMALL_CAPACITOR, SlimefunItems.ALUMINUM_INGOT, SlimefunItems.ELECTRIC_MOTOR, SlimefunItems.ALUMINUM_INGOT, SlimefunItems.SMALL_CAPACITOR, SlimefunItems.ALUMINUM_INGOT, SlimefunItems.SMALL_CAPACITOR};
    public static final SlimefunItemStack GENERATOR_MOB_MEDIUM = new SupremeItemStack("SUPREME_GENERATOR_MOB_MEDIUM", Material.COMPOSTER, false, LoreBuilder.machine((MachineTier)MachineTier.BASIC, (MachineType)MachineType.GENERATOR), UtilEnergy.energyBuffer(ItemUtil.getValueGeneratorsWithLimit(4000)), UtilEnergy.energyPowerPerSecond(ItemUtil.getValueGeneratorsWithLimit(200)));
    public static final ItemStack[] RECIPE_GENERATOR_MOB_MEDIUM = new ItemStack[]{GENERATOR_MOB_BASIC, SlimefunItems.FERROSILICON, GENERATOR_MOB_BASIC, SlimefunItems.REINFORCED_PLATE, SupremeComponents.SYNTHETIC_RUBY, SlimefunItems.REINFORCED_PLATE, GENERATOR_MOB_BASIC, SlimefunItems.ALUMINUM_BRONZE_INGOT, GENERATOR_MOB_BASIC};
    public static final SlimefunItemStack GENERATOR_MOB_ADVANCED = new SupremeItemStack("SUPREME_GENERATOR_MOB_ADVANCED", Material.COMPOSTER, false, LoreBuilder.machine((MachineTier)MachineTier.BASIC, (MachineType)MachineType.GENERATOR), UtilEnergy.energyBuffer(ItemUtil.getValueGeneratorsWithLimit(16000)), UtilEnergy.energyPowerPerSecond(ItemUtil.getValueGeneratorsWithLimit(800)));
    public static final ItemStack[] RECIPE_GENERATOR_MOB_ADVANCED = new ItemStack[]{GENERATOR_MOB_MEDIUM, SlimefunItems.CARBONADO, GENERATOR_MOB_MEDIUM, SlimefunItems.HEATING_COIL, SlimefunItems.PLUTONIUM, SlimefunItems.HEATING_COIL, GENERATOR_MOB_MEDIUM, SupremeComponents.INDUCTIVE_MACHINE, GENERATOR_MOB_MEDIUM};
    protected static final Map<BlockPosition, UUID> cachedMob = new ConcurrentHashMap<BlockPosition, UUID>();
    private int energy;
    private int buffer;
    private int mobRange = 3;

    public GeneratorMob(SlimefunItemStack item, ItemStack[] recipe) {
        super(ItemGroups.ELECTRIC_CATEGORY, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
    }

    public final GeneratorMob setEnergy(int value) {
        this.energy = value;
        return this;
    }

    public final GeneratorMob setBuffer(int value) {
        this.buffer = value;
        return this;
    }

    public final GeneratorMob setMobRange(int value) {
        this.mobRange = value;
        return this;
    }

    @Nonnull
    public ItemStack getProgressBar() {
        return new ItemStack(Material.OBSERVER);
    }

    public int getEnergyProduction() {
        return this.energy;
    }

    protected void registerDefaultFuelTypes() {
    }

    @ParametersAreNonnullByDefault
    public int getGeneratedOutput(Location l, Config config) {
        return this.isAnimalNearby(l) ? this.getEnergyProduction() : 0;
    }

    public int getCapacity() {
        return this.buffer;
    }

    public int[] getInputSlots() {
        return new int[0];
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    @ParametersAreNonnullByDefault
    private boolean isAnimalNearby(@Nonnull Location l) {
        BlockPosition p = new BlockPosition(l);
        this.updateSet(p, l);
        return cachedMob.containsKey(p);
    }

    private boolean isAnimalNearby(@Nonnull Location l, @Nullable UUID uuid) {
        return uuid != null && Bukkit.getEntity((UUID)uuid) != null && l.distanceSquared(Bukkit.getEntity((UUID)uuid).getLocation()) <= Math.pow(this.mobRange, 2.0);
    }

    @ParametersAreNonnullByDefault
    private boolean isValidAnimal(Entity n) {
        return n instanceof Cow || n instanceof Sheep || n instanceof Pig;
    }

    private UUID locateNearbyMob(@Nonnull Location l) {
        return l.getWorld().getNearbyEntities(l, (double)this.mobRange, (double)this.mobRange, (double)this.mobRange, this::isValidAnimal).stream().findFirst().map(Entity::getUniqueId).orElse(null);
    }

    @ParametersAreNonnullByDefault
    private void updateSet(@Nonnull BlockPosition p, @Nonnull Location l) {
        Slimefun.runSync(() -> {
            UUID uuid = cachedMob.getOrDefault(p, this.locateNearbyMob(l));
            if (this.isAnimalNearby(l, uuid)) {
                cachedMob.put(p, uuid);
            } else {
                cachedMob.remove(p);
            }
        });
    }
}

