/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.utils;

import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.WordUtils;

public final class StringUtil {
    @Nonnull
    public static String humanize(@Nonnull String str) {
        Validate.notNull((Object)str, (String)"the string should not be null");
        StringBuilder builder = new StringBuilder();
        str = str.toLowerCase(Locale.ROOT).replace(" ", "_");
        String[] segments = Pattern.compile("_").split(str);
        builder.append(WordUtils.capitalize((String)segments[0]));
        for (int i = 1; i < segments.length; ++i) {
            builder.append(" ");
            builder.append(WordUtils.capitalize((String)segments[i]));
        }
        return builder.toString();
    }

    @Nonnull
    public static String dehumanize(@Nonnull String str) {
        Validate.notNull((Object)str, (String)"the string should not be null");
        return str.toUpperCase(Locale.ROOT).replace(" ", "_").replace("-", "_");
    }

    private StringUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

