/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.localization;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public final class Language {
    private final String lang;
    private final File currentFile;
    private final FileConfiguration currentConfig;

    @ParametersAreNonnullByDefault
    public Language(String lang, File currentFile, FileConfiguration defaultConfig) {
        Validate.notNull((Object)lang, (String)"Language key cannot be null");
        Validate.notNull((Object)currentFile, (String)"currentFile cannot be null");
        Validate.notNull((Object)defaultConfig);
        this.lang = lang;
        this.currentFile = currentFile;
        this.currentConfig = YamlConfiguration.loadConfiguration((File)currentFile);
        this.currentConfig.setDefaults((Configuration)defaultConfig);
        this.save();
    }

    @Nonnull
    public String getName() {
        return this.lang;
    }

    public FileConfiguration getLang() {
        return this.currentConfig;
    }

    public void save() {
        try {
            this.currentConfig.save(this.currentFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

