/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.machine.tech;

import com.github.relativobr.supreme.Supreme;
import com.github.relativobr.supreme.generic.machine.SimpleItemContainerMachine;
import com.github.relativobr.supreme.generic.recipe.AbstractItemRecipe;
import com.github.relativobr.supreme.generic.recipe.InventoryRecipe;
import com.github.relativobr.supreme.machine.tech.MobTechGeneric;
import com.github.relativobr.supreme.resource.SupremeComponents;
import com.github.relativobr.supreme.resource.mobtech.MobTech;
import com.github.relativobr.supreme.util.ItemGroups;
import com.github.relativobr.supreme.util.SupremeItemStack;
import com.github.relativobr.supreme.util.UtilEnergy;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineTier;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineType;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactivity;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.UnplaceableBlock;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.springframework.scheduling.annotation.Async;

@Async
public class TechGenerator
extends SimpleItemContainerMachine
implements Radioactive {
    public static final SlimefunItemStack TECH_GENERATOR = new SupremeItemStack("SUPREME_TECH_GENERATOR", Material.LOOM, "&bTech Generator", "", "&fUsing power and bees/golem/zombie, ", "&fslowly generates materials.", "", LoreBuilder.radioactive((Radioactivity)Radioactivity.LOW), "", LoreBuilder.machine((MachineTier)MachineTier.END_GAME, (MachineType)MachineType.MACHINE), UtilEnergy.energyPowerPerTick(2000), "", "&3Supreme Machine");
    public static final ItemStack[] RECIPE_TECH_GENERATOR = new ItemStack[]{SupremeComponents.INDUCTIVE_MACHINE, SupremeComponents.SYNTHETIC_RUBY, SupremeComponents.INDUCTIVE_MACHINE, SlimefunItems.REINFORCED_ALLOY_INGOT, new ItemStack(Material.LOOM), SlimefunItems.REINFORCED_ALLOY_INGOT, SupremeComponents.CARRIAGE_MACHINE, SlimefunItems.HEATING_COIL, SupremeComponents.CARRIAGE_MACHINE};
    public static final List<AbstractItemRecipe> receitasParaProduzir = new ArrayList<AbstractItemRecipe>();
    private Map<Block, ItemStack> processing = new HashMap<Block, ItemStack>();
    private Map<Block, Integer> progressTime = new HashMap<Block, Integer>();
    private int speed = 1;

    public TechGenerator(SlimefunItemStack item, ItemStack[] recipe) {
        super(ItemGroups.MACHINES_CATEGORY, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
    }

    public static void addRecipesToProcess(ItemStack input, ItemStack output) {
        receitasParaProduzir.add(new AbstractItemRecipe(input, output));
    }

    public static void preSetup(Supreme plugin, SlimefunItemStack item, Material input, Material output) {
        TechGenerator.preSetup(plugin, 1, item, new ItemStack(input), new ItemStack(output));
    }

    public static void preSetup(Supreme plugin, SlimefunItemStack item, ItemStack input, ItemStack output) {
        TechGenerator.preSetup(plugin, 1, item, input, output);
    }

    public static void preSetup(Supreme plugin, int tierCard, SlimefunItemStack item, ItemStack input, ItemStack output) {
        TechGenerator.preSetup(plugin, tierCard, item, input, input, output);
    }

    public static void preSetup(Supreme plugin, int tierCard, SlimefunItemStack item, ItemStack input1, ItemStack input2, ItemStack output) {
        new UnplaceableBlock(ItemGroups.CARDS_CATEGORY, item, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{new ItemStack(input1), new ItemStack(input2), new ItemStack(input1), new ItemStack(input2), TechGenerator.getCardTier(tierCard), new ItemStack(input2), new ItemStack(input1), new ItemStack(input2), new ItemStack(input1)}).register((SlimefunAddon)plugin);
        TechGenerator.addRecipesToProcess((ItemStack)item, output);
    }

    @Nonnull
    private static ItemStack getCardTier(int tierCard) {
        if (tierCard >= 3) {
            return SupremeComponents.CENTER_CARD_ULTIMATE;
        }
        if (tierCard == 2) {
            return SupremeComponents.CENTER_CARD_ADVANCED;
        }
        return SupremeComponents.CENTER_CARD_SIMPLE;
    }

    private static void invalidStatus(BlockMenu menu, String txt) {
        for (int i : InventoryRecipe.TECH_GENERATOR_PROGRESS_BAR_SLOT) {
            menu.replaceExistingItem(i, (ItemStack)new CustomItemStack(Material.RED_STAINED_GLASS_PANE, txt, new String[0]));
        }
    }

    private static void invalidStatus(BlockMenu menu, Material material, String txt) {
        for (int i : InventoryRecipe.TECH_GENERATOR_PROGRESS_BAR_SLOT) {
            menu.replaceExistingItem(i, (ItemStack)new CustomItemStack(material, txt, new String[0]));
        }
    }

    public List<AbstractItemRecipe> getRecipeShow() {
        return receitasParaProduzir.stream().filter(o -> o.getInput() != null).sorted((o1, o2) -> Integer.compare(o1.getInput().length, o2.getInput().length)).collect(Collectors.toList());
    }

    public List<AbstractItemRecipe> getRecipeProcess() {
        return receitasParaProduzir.stream().filter(o -> o.getInput() != null).sorted((o1, o2) -> Integer.compare(o2.getInput().length, o1.getInput().length)).collect(Collectors.toList());
    }

    @Override
    public int[] getInputSlots() {
        return InventoryRecipe.TECH_GENERATOR_INPUT_SLOTS;
    }

    @Override
    public int[] getOutputSlots() {
        return InventoryRecipe.TECH_GENERATOR_OUTPUT_SLOTS;
    }

    @Override
    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : InventoryRecipe.TECH_GENERATOR_BORDER) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : InventoryRecipe.TECH_GENERATOR_BORDER_IN) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.BLUE_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : InventoryRecipe.TECH_GENERATOR_BORDER_OUT) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : InventoryRecipe.TECH_GENERATOR_PROGRESS_BAR_SLOT) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : InventoryRecipe.TECH_GENERATOR_OUTPUT_SLOTS) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    if (cursor == null) {
                        return true;
                    }
                    return cursor.getType() == Material.AIR;
                }
            });
        }
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                TechGenerator.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    @Override
    public void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        if (inv == null) {
            return;
        }
        ItemStack itemProduction = this.processing.get(b);
        if (itemProduction == null) {
            ItemStack validRecipeItem = this.validRecipeItem(inv);
            if (validRecipeItem != null) {
                TechGenerator.invalidStatus(inv, validRecipeItem.getType(), " ");
                this.processing.put(b, validRecipeItem);
                this.progressTime.put(b, this.getTimeProcess() * 2);
            } else {
                TechGenerator.invalidStatus(inv, "&cCards unidentified");
            }
        } else if (this.getProgressTime(b) <= 0) {
            this.checkCloneOutput(inv, itemProduction.clone());
            this.processing.put(b, null);
            this.progressTime.put(b, 0);
            TechGenerator.invalidStatus(inv, Material.BLACK_STAINED_GLASS_PANE, " ");
        } else {
            ItemStack validRecipeItem = this.validRecipeItem(inv);
            if (SlimefunUtils.isItemSimilar((ItemStack)validRecipeItem, (ItemStack)itemProduction, (boolean)false, (boolean)false)) {
                this.processTicks(b, inv, itemProduction);
            } else {
                this.processing.put(b, null);
                this.progressTime.put(b, 0);
                TechGenerator.invalidStatus(inv, Material.BLACK_STAINED_GLASS_PANE, " ");
            }
        }
    }

    private void checkCloneOutput(BlockMenu inv, ItemStack itemStack) {
        itemStack.setAmount(Supreme.getSupremeOptions().getMaxAmountTechGenerator());
        inv.pushItem(itemStack, this.getOutputSlots());
        this.buildSlotProcess(inv.getItemInSlot(this.getInputSlots()[1]), itemStack, inv);
        this.buildSlotProcess(inv.getItemInSlot(this.getInputSlots()[2]), itemStack, inv);
        this.buildSlotProcess(inv.getItemInSlot(this.getInputSlots()[3]), itemStack, inv);
        this.buildSlotProcess(inv.getItemInSlot(this.getInputSlots()[4]), itemStack, inv);
    }

    private void buildSlotProcess(ItemStack input, ItemStack itemStack, BlockMenu inv) {
        MobTech mobTech;
        SlimefunItem slimefunItem;
        if (input != null && itemStack != null && (slimefunItem = SlimefunItem.getByItem((ItemStack)input)) instanceof MobTech && ((mobTech = (MobTech)slimefunItem).getMobTechType() == MobTechGeneric.MobTechType.ROBOTIC_CLONING || mobTech.getMobTechType() == MobTechGeneric.MobTechType.MUTATION_LUCK)) {
            int amount = Math.min(input.getAmount() * mobTech.getMobTechTier(), Supreme.getSupremeOptions().getMaxAmountTechGenerator());
            itemStack.setAmount(amount);
            inv.pushItem(itemStack, this.getOutputSlots());
            if (mobTech.getMobTechTier() >= 4) {
                inv.pushItem(itemStack, this.getOutputSlots());
            }
            if (mobTech.getMobTechTier() >= 6) {
                inv.pushItem(itemStack, this.getOutputSlots());
            }
            if (mobTech.getMobTechTier() >= 9) {
                inv.pushItem(itemStack, this.getOutputSlots());
            }
        }
    }

    @Override
    public int getProgressTime(Block b) {
        return this.progressTime.get(b) != null ? this.progressTime.get(b) : this.getTimeProcess() * 2;
    }

    private void processTicks(Block b, BlockMenu inv, ItemStack result) {
        int ticksLeft = this.getProgressTime(b);
        if (ticksLeft > 0) {
            if (this.takeCharge(b.getLocation(), inv)) {
                int time = this.checkUpTime(ticksLeft, inv);
                if (time < 0) {
                    time = 0;
                }
                this.progressTime.put(b, time);
                int ticksTotal = this.getTimeProcess() * 2;
                for (int i : InventoryRecipe.TECH_GENERATOR_PROGRESS_BAR_SLOT) {
                    ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)i, (int)Math.round(ticksLeft / this.getSpeed()), (int)Math.round(ticksTotal / this.getSpeed()), (ItemStack)result);
                }
            } else {
                int downConsumption = this.checkDownConsumption(this.getEnergyConsumption(), inv);
                TechGenerator.invalidStatus(inv, "&cNo power on the machine (" + downConsumption + " J/tick)");
            }
        } else {
            TechGenerator.invalidStatus(inv, "&cMachine time failure");
        }
    }

    private int checkUpTime(int time, BlockMenu inv) {
        time -= this.getSpeed();
        time = this.checkTimeSlot(inv.getItemInSlot(this.getInputSlots()[1]), time);
        time = this.checkTimeSlot(inv.getItemInSlot(this.getInputSlots()[2]), time);
        time = this.checkTimeSlot(inv.getItemInSlot(this.getInputSlots()[3]), time);
        time = this.checkTimeSlot(inv.getItemInSlot(this.getInputSlots()[4]), time);
        return time;
    }

    private int checkTimeSlot(ItemStack input, int time) {
        SlimefunItem slimefunItem;
        if (input != null && (slimefunItem = SlimefunItem.getByItem((ItemStack)input)) instanceof MobTech) {
            int roundTimeAmount = Math.round((float)input.getAmount() * 0.015625f);
            MobTech mobTech = (MobTech)slimefunItem;
            time = mobTech.getMobTechType() == MobTechGeneric.MobTechType.ROBOTIC_ACCELERATION || mobTech.getMobTechType() == MobTechGeneric.MobTechType.MUTATION_BERSERK ? (time -= (mobTech.getMobTechTier() + 1) * roundTimeAmount) : (time -= roundTimeAmount);
        }
        return time;
    }

    protected boolean takeCharge(@Nonnull Location l, BlockMenu inv) {
        Validate.notNull((Object)l, (String)"Can't attempt to take charge from a null location!");
        if (this.isChargeable()) {
            int consumption;
            int charge = this.getCharge(l);
            if (charge < (consumption = this.checkDownConsumption(this.getEnergyConsumption(), inv))) {
                return false;
            }
            this.setCharge(l, charge - consumption);
            return true;
        }
        return true;
    }

    private int checkDownConsumption(int consumption, BlockMenu inv) {
        consumption = this.checkConsumptionSlot(inv.getItemInSlot(this.getInputSlots()[1]), consumption);
        consumption = this.checkConsumptionSlot(inv.getItemInSlot(this.getInputSlots()[2]), consumption);
        consumption = this.checkConsumptionSlot(inv.getItemInSlot(this.getInputSlots()[3]), consumption);
        consumption = this.checkConsumptionSlot(inv.getItemInSlot(this.getInputSlots()[4]), consumption);
        return Math.max(consumption, 1);
    }

    private int checkConsumptionSlot(ItemStack input, int consumption) {
        if (input != null && !input.getType().isAir() && input.getItemMeta() != null) {
            NamespacedKey tier = new NamespacedKey((Plugin)Supreme.inst(), "mob_tech_tier");
            NamespacedKey type = new NamespacedKey((Plugin)Supreme.inst(), "mob_tech_type");
            ItemMeta itemMeta = input.getItemMeta();
            if (PersistentDataAPI.hasInt((PersistentDataHolder)itemMeta, (NamespacedKey)tier) && PersistentDataAPI.hasString((PersistentDataHolder)itemMeta, (NamespacedKey)type)) {
                int adjustEnergy;
                MobTechGeneric.MobTechType mobTechType = MobTechGeneric.MobTechType.valueOf(PersistentDataAPI.getString((PersistentDataHolder)itemMeta, (NamespacedKey)type));
                int mobTechTier = PersistentDataAPI.getInt((PersistentDataHolder)itemMeta, (NamespacedKey)tier);
                float perceptual = (float)((mobTechTier + 1) * input.getAmount()) * 0.15625f;
                if (mobTechType == MobTechGeneric.MobTechType.ROBOTIC_EFFICIENCY || mobTechType == MobTechGeneric.MobTechType.MUTATION_INTELLIGENCE) {
                    adjustEnergy = Math.round((float)consumption / 100.0f * perceptual);
                    consumption -= adjustEnergy;
                }
                if (mobTechType == MobTechGeneric.MobTechType.ROBOTIC_ACCELERATION || mobTechType == MobTechGeneric.MobTechType.MUTATION_BERSERK) {
                    adjustEnergy = Math.round((float)consumption / 100.0f * perceptual);
                    consumption += adjustEnergy;
                }
            } else {
                SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)input);
                if (slimefunItem instanceof MobTech) {
                    PersistentDataAPI.setInt((PersistentDataHolder)itemMeta, (NamespacedKey)tier, (int)((MobTech)slimefunItem).getMobTechTier());
                    PersistentDataAPI.setString((PersistentDataHolder)itemMeta, (NamespacedKey)type, (String)((MobTech)slimefunItem).getMobTechType().name());
                    input.setItemMeta(itemMeta);
                }
            }
        }
        return consumption;
    }

    @Nullable
    private ItemStack validRecipeItem(BlockMenu inv) {
        for (AbstractItemRecipe produce : this.getRecipeProcess()) {
            if (!SlimefunUtils.isItemSimilar((ItemStack)inv.getItemInSlot(this.getInputSlots()[0]), (ItemStack)produce.getFirstItemInput(), (boolean)false, (boolean)true)) continue;
            return produce.getFirstItemOutput();
        }
        return null;
    }

    @Override
    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>();
        for (AbstractItemRecipe recipe : this.getRecipeShow()) {
            if (recipe == null) continue;
            ItemStack itemStack = recipe.getFirstItemOutput().clone();
            itemStack.setAmount(Supreme.getSupremeOptions().getMaxAmountTechGenerator());
            displayRecipes.add(recipe.getFirstItemInput());
            displayRecipes.add(itemStack);
        }
        return displayRecipes;
    }

    public int getSpeed() {
        return this.speed;
    }

    public TechGenerator setSpeed(int speed) {
        this.speed = speed;
        return this;
    }

    @Nonnull
    public Radioactivity getRadioactivity() {
        return Radioactivity.LOW;
    }
}

