/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.localization;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.localization.Language;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Localization {
    private boolean initialized = false;
    private final JavaPlugin plugin;
    private final String langFolderName;
    private final File langFolder;
    private final List<String> languages = new LinkedList<String>();
    private final Map<String, Language> langMap = new LinkedHashMap<String, Language>();

    @ParametersAreNonnullByDefault
    public Localization(JavaPlugin plugin) {
        this(plugin, "lang");
    }

    @ParametersAreNonnullByDefault
    public Localization(JavaPlugin plugin, String folderName) {
        Validate.notNull((Object)plugin, (String)"The plugin instance should not be null");
        Validate.notNull((Object)folderName, (String)"The folder name should not be null");
        this.plugin = plugin;
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdir();
        }
        this.langFolderName = folderName;
        this.langFolder = new File(plugin.getDataFolder(), "/" + folderName);
        if (!this.langFolder.exists()) {
            this.langFolder.mkdir();
        }
        this.initialized = true;
    }

    @ParametersAreNonnullByDefault
    public Localization(JavaPlugin plugin, String folderName, String langFile) {
        this(plugin, folderName);
        this.addLanguage(langFile);
    }

    public void addLanguage(@Nonnull String langFilename) {
        Validate.notNull((Object)langFilename, (String)"The language file name should not be null");
        File langFile = new File(this.langFolder, langFilename + ".yml");
        String resourcePath = this.langFolderName + "/" + langFilename + ".yml";
        if (!langFile.exists()) {
            try {
                this.plugin.saveResource(resourcePath, false);
            }
            catch (IllegalArgumentException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "jar\u5305\u4e2d\u7684\u8bed\u8a00\u6587\u4ef6 {0} \u4e0d\u5b58\u5728!", resourcePath);
                return;
            }
        }
        this.languages.add(langFilename);
        InputStreamReader defaultReader = new InputStreamReader(this.plugin.getResource(resourcePath), StandardCharsets.UTF_8);
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)defaultReader);
        this.langMap.put(langFilename, new Language(langFilename, langFile, (FileConfiguration)defaultConfig));
    }

    @Nonnull
    public String getString(@Nonnull String path) {
        Validate.notNull((Object)path, (String)"path cannot be null");
        if (!this.initialized) {
            throw new IllegalStateException("Localization service is not initialized");
        }
        for (String lang : this.languages) {
            String localization = this.langMap.get(lang).getLang().getString(path);
            if (localization == null) continue;
            return localization;
        }
        return "";
    }

    @Nonnull
    public List<String> getStringList(@Nonnull String path) {
        Validate.notNull((Object)path, (String)"path cannot be null");
        if (!this.initialized) {
            throw new IllegalStateException("Localization service is not initialized");
        }
        for (String lang : this.languages) {
            List localization = this.langMap.get(lang).getLang().getStringList(path);
            if (localization.isEmpty()) continue;
            return localization;
        }
        return new ArrayList<String>();
    }

    @Nonnull
    public String[] getStringArray(@Nonnull String path) {
        return this.getStringList(path).toArray(new String[0]);
    }
}

