/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.machine.multiblock;

import com.github.relativobr.supreme.Supreme;
import com.github.relativobr.supreme.util.ItemGroups;
import com.github.relativobr.supreme.util.SupremeItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MultiBlockCoreFabricator
extends MultiBlockMachine
implements NotPlaceable {
    public static final SlimefunItemStack CORE_FABRICATOR = new SupremeItemStack("SUPREME_MULTIBLOCK_CORE", Material.SHROOMLIGHT, "&eCore Fabricator", "", "&7&oYou can craft core here!", "", "&aMultiBlock Machine");
    public static final RecipeType MACHINE_CORE_FABRICATOR = new RecipeType(new NamespacedKey((Plugin)Supreme.inst(), "SUPREME_MULTIBLOCK_CORE_KEY"), (ItemStack)CORE_FABRICATOR);

    @ParametersAreNonnullByDefault
    public MultiBlockCoreFabricator() {
        super(ItemGroups.MACHINES_CATEGORY, CORE_FABRICATOR, new ItemStack[]{new ItemStack(Material.SHROOMLIGHT), new ItemStack(Material.ORANGE_STAINED_GLASS), new ItemStack(Material.SHROOMLIGHT), new ItemStack(Material.IRON_BARS), new ItemStack(Material.IRON_TRAPDOOR), new ItemStack(Material.IRON_BARS), new ItemStack(Material.GOLD_BLOCK), new ItemStack(Material.DISPENSER), new ItemStack(Material.GOLD_BLOCK)}, new ItemStack[0], BlockFace.SELF);
    }

    public static RecipeType getMachine() {
        return MACHINE_CORE_FABRICATOR;
    }

    public void onInteract(Player p, Block b) {
        Block dispenser = b.getRelative(BlockFace.DOWN);
        if (!dispenser.isEmpty()) {
            Inventory inv = ((Dispenser)dispenser.getState()).getInventory();
            List inputs = RecipeType.getRecipeInputList((MultiBlockMachine)this);
            block0: for (ItemStack[] input : inputs) {
                for (int i = 0; i < inv.getContents().length; ++i) {
                    if (!SlimefunUtils.isItemSimilar((ItemStack)inv.getContents()[i], (ItemStack)input[i], (boolean)false, (boolean)true)) continue block0;
                }
                ItemStack output = RecipeType.getRecipeOutputList((MultiBlockMachine)this, (ItemStack[])input);
                SlimefunItem outputItem = SlimefunItem.getByItem((ItemStack)output);
                if (outputItem == null || outputItem.canUse(p, true)) {
                    int i;
                    Inventory outputInv = this.findOutputInventory(output, dispenser, inv);
                    boolean canFit = false;
                    for (i = 0; i < inv.getContents().length; ++i) {
                        if (inv.getContents()[i] == null && inv.getContents()[i].getAmount() != inv.getContents()[i].getMaxStackSize() && outputInv == null) continue;
                        canFit = true;
                    }
                    if (!canFit) {
                        Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
                        return;
                    }
                    for (i = 0; i < inv.getContents().length; ++i) {
                        ItemStack item = inv.getItem(i);
                        if (item == null) continue;
                        ItemUtils.consumeItem((ItemStack)item, (int)input[i].getAmount(), (boolean)false);
                    }
                    Bukkit.getScheduler().runTaskLater((Plugin)Supreme.inst(), () -> p.getWorld().playSound(dispenser.getLocation(), Sound.BLOCK_LAVA_EXTINGUISH, 1.0f, 1.0f), 55L);
                    for (i = 1; i < 7; ++i) {
                        Bukkit.getScheduler().runTaskLater((Plugin)Supreme.inst(), () -> p.getWorld().playSound(dispenser.getLocation(), Sound.BLOCK_METAL_PLACE, 7.0f, 1.0f), (long)i * 5L);
                    }
                    if (outputInv != null) {
                        outputInv.addItem(new ItemStack[]{output});
                    } else {
                        inv.addItem(new ItemStack[]{output});
                    }
                }
                return;
            }
        }
        Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.pattern-not-found", true);
    }
}

