/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.machine;

import com.github.relativobr.supreme.generic.machine.SimpleItemWithLargeContainerMachine;
import com.github.relativobr.supreme.generic.recipe.AbstractItemRecipe;
import com.github.relativobr.supreme.machine.recipe.VirtualGardenMachineRecipe;
import com.github.relativobr.supreme.resource.SupremeComponents;
import com.github.relativobr.supreme.resource.magical.SupremeAttribute;
import com.github.relativobr.supreme.resource.magical.SupremeCetrus;
import com.github.relativobr.supreme.util.SupremeItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineTier;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.springframework.scheduling.annotation.Async;

@Async
public class VirtualGarden
extends SimpleItemWithLargeContainerMachine {
    public static final SlimefunItemStack VIRTUAL_GARDEN_MACHINE = new SupremeItemStack("SUPREME_VIRTUAL_GARDEN_I", Material.STRIPPED_WARPED_HYPHAE, "&bVirtual Garden", "", "&fThis machine allows you to", "&fcultivate some resources.", "", LoreBuilder.machine((MachineTier)MachineTier.ADVANCED, (MachineType)MachineType.MACHINE), LoreBuilder.speed((float)1.0f), LoreBuilder.powerBuffer((int)1000), LoreBuilder.powerPerSecond((int)20), "", "&3Supreme Machine");
    public static final ItemStack[] RECIPE_VIRTUAL_GARDEN_MACHINE = new ItemStack[]{SupremeComponents.SYNTHETIC_RUBY, new ItemStack(Material.STRIPPED_WARPED_HYPHAE), SupremeComponents.SYNTHETIC_RUBY, SupremeComponents.RUSTLESS_MACHINE, SupremeComponents.PETRIFIER_MACHINE, SupremeComponents.RUSTLESS_MACHINE, SupremeComponents.ADAMANTIUM_PLATE, SlimefunItems.PROGRAMMABLE_ANDROID_2_FARMER, SupremeComponents.ADAMANTIUM_PLATE};
    public static final SlimefunItemStack VIRTUAL_GARDEN_MACHINE_II = new SupremeItemStack("SUPREME_VIRTUAL_GARDEN_II", Material.STRIPPED_WARPED_HYPHAE, "&bVirtual Garden II", "", "&fThis machine allows you to", "&fcultivate some resources.", "", LoreBuilder.machine((MachineTier)MachineTier.END_GAME, (MachineType)MachineType.MACHINE), LoreBuilder.speed((float)5.0f), LoreBuilder.powerBuffer((int)5000), LoreBuilder.powerPerSecond((int)100), "", "&3Supreme Machine");
    public static final ItemStack[] RECIPE_VIRTUAL_GARDEN_MACHINE_II = new ItemStack[]{SupremeComponents.CONVEYANCE_MACHINE, SupremeCetrus.CETRUS_LUMIUM, SupremeComponents.CONVEYANCE_MACHINE, SupremeComponents.INDUCTOR_MACHINE, VIRTUAL_GARDEN_MACHINE, SupremeComponents.INDUCTOR_MACHINE, SupremeComponents.THORNERITE, SupremeCetrus.CETRUS_AQUA, SupremeComponents.THORNERITE};
    public static final SlimefunItemStack VIRTUAL_GARDEN_MACHINE_III = new SupremeItemStack("SUPREME_VIRTUAL_GARDEN_III", Material.STRIPPED_WARPED_HYPHAE, "&bVirtual Garden III", "", "&fThis machine allows you to", "&fcultivate some resources.", "", LoreBuilder.machine((MachineTier)MachineTier.END_GAME, (MachineType)MachineType.MACHINE), LoreBuilder.speed((float)15.0f), LoreBuilder.powerBuffer((int)15000), LoreBuilder.powerPerSecond((int)300), "", "&3Supreme Machine");
    public static final ItemStack[] RECIPE_VIRTUAL_GARDEN_MACHINE_III = new ItemStack[]{SupremeComponents.THORNERITE, SupremeAttribute.getFortune(), SupremeComponents.THORNERITE, SupremeComponents.SUPREME, VIRTUAL_GARDEN_MACHINE_II, SupremeComponents.SUPREME, SupremeComponents.CRYSTALLIZER_MACHINE, SupremeCetrus.CETRUS_LUMIUM, SupremeComponents.CRYSTALLIZER_MACHINE};
    public static Map<Block, MachineRecipe> processing = new HashMap<Block, MachineRecipe>();
    public static Map<Block, Integer> progress = new HashMap<Block, Integer>();
    private final Set<VirtualGardenMachineRecipe> virtualGardenMachineRecipes = new HashSet<VirtualGardenMachineRecipe>();

    @ParametersAreNonnullByDefault
    public VirtualGarden(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    protected void registerDefaultRecipes() {
        this.recipes.clear();
        VirtualGardenMachineRecipe.getAllRecipe().stream().filter(Objects::nonNull).forEach(recipe -> this.addProduce(new VirtualGardenMachineRecipe((AbstractItemRecipe)recipe)));
    }

    public void addProduce(@Nonnull VirtualGardenMachineRecipe produce) {
        Validate.notNull((Object)((Object)produce), (String)"A produce cannot be null");
        this.virtualGardenMachineRecipes.add(produce);
    }

    @Override
    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>();
        VirtualGardenMachineRecipe.getAllRecipe().stream().filter(Objects::nonNull).forEach(recipe -> {
            displayRecipes.add((ItemStack)new CustomItemStack(recipe.getFirstMaterialInput(), null, new String[]{"&fRequires &bto cultivate"}));
            displayRecipes.add(new ItemStack(recipe.getFirstMaterialOutput()));
        });
        return displayRecipes;
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                VirtualGarden.this.tick(b);
            }

            public boolean isSynchronized() {
                return true;
            }
        }});
    }

    @Nonnull
    public String getRecipeSectionLabel(@Nonnull Player p) {
        return "&7Cultivate:";
    }

    @Override
    protected MachineRecipe findNextRecipe(@Nonnull BlockMenu inv) {
        int[] inputSlots;
        for (int slot : inputSlots = this.getInputSlots()) {
            for (VirtualGardenMachineRecipe produce : this.virtualGardenMachineRecipes) {
                ItemStack itemInSlot = inv.getItemInSlot(slot);
                ItemStack itemInInput = produce.getInput()[0];
                if (itemInSlot == null || itemInInput == null || itemInSlot.getType() != itemInInput.getType() || !InvUtils.fits((Inventory)inv.toInventory(), (ItemStack)produce.getOutput()[0], (int[])this.getOutputSlots())) continue;
                return produce;
            }
        }
        return null;
    }

    @Override
    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        if (this.isProcessing(b)) {
            if (this.takeCharge(b.getLocation())) {
                int timeleft = progress.get(b);
                if (timeleft > 0) {
                    ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)this.getStatusSlot(), (int)timeleft, (int)processing.get(b).getTicks(), (ItemStack)this.getProgressBar());
                    int time = timeleft - this.getSpeed();
                    if (time < 0) {
                        time = 0;
                    }
                    progress.put(b, time);
                } else {
                    inv.replaceExistingItem(this.getStatusSlot(), (ItemStack)new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
                    for (ItemStack output : processing.get(b).getOutput()) {
                        if (output == null) continue;
                        ItemStack clone = output.clone();
                        clone.setAmount(1);
                        inv.pushItem(clone, this.getOutputSlots());
                    }
                    progress.remove(b);
                    processing.remove(b);
                }
            }
        } else {
            MachineRecipe next = this.findNextRecipe(inv);
            if (next != null) {
                processing.put(b, next);
                progress.put(b, next.getTicks());
            }
        }
    }

    @Override
    @Nonnull
    public String getMachineIdentifier() {
        return "VIRTUAL_GARDEN";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.IRON_HOE);
    }

    @Override
    public MachineRecipe getProcessing(Block b) {
        return processing.get(b);
    }

    @Override
    public boolean isProcessing(Block b) {
        return this.getProcessing(b) != null;
    }
}

