/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.resource.mobtech;

import com.github.relativobr.supreme.Supreme;
import com.github.relativobr.supreme.machine.tech.MobTechGeneric;
import com.github.relativobr.supreme.machine.tech.TechMutation;
import com.github.relativobr.supreme.machine.tech.TechRobotic;
import com.github.relativobr.supreme.resource.SupremeComponents;
import com.github.relativobr.supreme.resource.mobtech.BeeTech;
import com.github.relativobr.supreme.resource.mobtech.IronGolemTech;
import com.github.relativobr.supreme.resource.mobtech.ZombieTech;
import com.github.relativobr.supreme.tools.MobCollectorTools;
import com.github.relativobr.supreme.util.ItemGroups;
import com.github.relativobr.supreme.util.ItemUtil;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactivity;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MobTech
extends SlimefunItem
implements Radioactive,
NotPlaceable {
    private Integer mobTechTier;
    private MobTechGeneric.MobTechType mobTechType;

    public MobTech(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    public static void preSetup(Supreme plugin, MobTechGeneric item) {
        if (MobTechGeneric.MobTechType.SIMPLE == item.getMobTechType()) {
            MobTech mobTech = new MobTech(ItemGroups.COMPONENTS_CATEGORY, ItemUtil.buildItemFromMobTechDTO(item, 0), RecipeType.NULL, new ItemStack[]{MobCollectorTools.MOB_COLLECTOR_I});
            mobTech.setMobTechType(item.getMobTechType());
            mobTech.setMobTechTier(0);
            mobTech.register(plugin);
        } else {
            if (MobTechGeneric.MobTechType.ROBOTIC_ACCELERATION == item.getMobTechType() || MobTechGeneric.MobTechType.ROBOTIC_CLONING == item.getMobTechType() || MobTechGeneric.MobTechType.ROBOTIC_EFFICIENCY == item.getMobTechType()) {
                MobTech.buildRobotic(plugin, item);
            }
            if (MobTechGeneric.MobTechType.MUTATION_BERSERK == item.getMobTechType() || MobTechGeneric.MobTechType.MUTATION_INTELLIGENCE == item.getMobTechType() || MobTechGeneric.MobTechType.MUTATION_LUCK == item.getMobTechType()) {
                MobTech.buildMutation(plugin, item);
            }
        }
    }

    private static void buildRobotic(Supreme plugin, MobTechGeneric item) {
        MobTech mobTech = new MobTech(ItemGroups.TECHMOB_CATEGORY, ItemUtil.buildItemFromMobTechDTO(item, 1), RecipeType.ENHANCED_CRAFTING_TABLE, MobTech.getRoboticStartRecipe(item));
        mobTech.setMobTechType(item.getMobTechType());
        mobTech.setMobTechTier(1);
        mobTech.register(plugin);
        for (int i = 2; i <= 9; ++i) {
            TechRobotic.addRecipe((ItemStack)ItemUtil.buildItemFromMobTechDTO(item, i - 1), (ItemStack)ItemUtil.buildItemFromMobTechDTO(item, i));
            mobTech = new MobTech(ItemGroups.TECHMOB_CATEGORY, ItemUtil.buildItemFromMobTechDTO(item, i), RecipeType.NULL, new ItemStack[]{TechRobotic.TECH_ROBOTIC});
            mobTech.setMobTechType(item.getMobTechType());
            mobTech.setMobTechTier(i);
            mobTech.register(plugin);
        }
    }

    private static ItemStack[] getRoboticStartRecipe(MobTechGeneric mobTech) {
        MobTechGeneric.MobTechType mobTechType = mobTech.getMobTechType();
        ItemStack itemStack = MobTech.getItemStackMobTechSimpleRobotic(mobTech);
        if (itemStack == null) {
            return null;
        }
        if (MobTechGeneric.MobTechType.ROBOTIC_ACCELERATION == mobTechType) {
            return new ItemStack[]{SlimefunItems.PLASTIC_SHEET, SlimefunItems.FIRE_RUNE, SlimefunItems.PLASTIC_SHEET, SlimefunItems.PLASTIC_SHEET, SlimefunItems.ANDROID_MEMORY_CORE, SlimefunItems.PLASTIC_SHEET, SupremeComponents.SYNTHETIC_RUBY, itemStack, SupremeComponents.SYNTHETIC_RUBY};
        }
        if (MobTechGeneric.MobTechType.ROBOTIC_CLONING == mobTechType) {
            return new ItemStack[]{SlimefunItems.PLASTIC_SHEET, SlimefunItems.RAINBOW_RUNE, SlimefunItems.PLASTIC_SHEET, SlimefunItems.PLASTIC_SHEET, SlimefunItems.ANDROID_MEMORY_CORE, SlimefunItems.PLASTIC_SHEET, SupremeComponents.SYNTHETIC_RUBY, itemStack, SupremeComponents.SYNTHETIC_RUBY};
        }
        if (MobTechGeneric.MobTechType.ROBOTIC_EFFICIENCY == mobTechType) {
            return new ItemStack[]{SlimefunItems.PLASTIC_SHEET, SlimefunItems.LIGHTNING_RUNE, SlimefunItems.PLASTIC_SHEET, SlimefunItems.PLASTIC_SHEET, SlimefunItems.ANDROID_MEMORY_CORE, SlimefunItems.PLASTIC_SHEET, SupremeComponents.SYNTHETIC_RUBY, itemStack, SupremeComponents.SYNTHETIC_RUBY};
        }
        return null;
    }

    private static ItemStack getItemStackMobTechSimpleRobotic(MobTechGeneric mobTech) {
        ItemStack itemStack = null;
        if (mobTech.getId().contains("_BEE")) {
            itemStack = new ItemStack(Material.HONEYCOMB);
        } else if (mobTech.getId().contains("_GOLEM")) {
            itemStack = new ItemStack(Material.POPPY);
        } else if (mobTech.getId().contains("_ZOMBIE")) {
            itemStack = new ItemStack(Material.ROTTEN_FLESH);
        }
        return itemStack;
    }

    private static SlimefunItemStack getItemStackMobTechSimpleMutation(MobTechGeneric mobTech) {
        SlimefunItemStack itemStack = null;
        if (mobTech.getId().contains("_BEE")) {
            itemStack = ItemUtil.buildItemFromMobTechDTO(BeeTech.SIMPLE_BEE, 0);
        } else if (mobTech.getId().contains("_GOLEM")) {
            itemStack = ItemUtil.buildItemFromMobTechDTO(IronGolemTech.SIMPLE_GOLEM, 0);
        } else if (mobTech.getId().contains("_ZOMBIE")) {
            itemStack = ItemUtil.buildItemFromMobTechDTO(ZombieTech.SIMPLE_ZOMBIE, 0);
        }
        return itemStack;
    }

    private static void buildMutation(Supreme plugin, MobTechGeneric item) {
        MobTech mobTech = new MobTech(ItemGroups.TECHMOB_CATEGORY, ItemUtil.buildItemFromMobTechDTO(item, 1), RecipeType.NULL, new ItemStack[]{TechMutation.TECH_MUTATION_I});
        mobTech.setMobTechType(item.getMobTechType());
        mobTech.setMobTechTier(1);
        mobTech.register(plugin);
        SlimefunItemStack simpleInput = MobTech.getItemStackMobTechSimpleMutation(item);
        if (simpleInput == null) {
            return;
        }
        SlimefunItemStack geneMutation = MobTech.getMutationStartRecipe(item.getMobTechType());
        if (geneMutation != null) {
            TechMutation.addRecipeTechMutation(simpleInput, geneMutation, MobTechGeneric.MobTechType.MUTATION_BERSERK == item.getMobTechType() ? 25 : 20, ItemUtil.buildItemFromMobTechDTO(item, 1));
        }
        for (int i = 2; i <= 9; ++i) {
            SlimefunItemStack inputTier = ItemUtil.buildItemFromMobTechDTO(item, i - 1);
            SlimefunItemStack itemStack = ItemUtil.buildItemFromMobTechDTO(item, i);
            TechMutation.addRecipeTechMutation(inputTier, inputTier, MobTechGeneric.MobTechType.MUTATION_BERSERK == item.getMobTechType() ? 25 : 20, itemStack);
            mobTech = new MobTech(ItemGroups.TECHMOB_CATEGORY, itemStack, RecipeType.NULL, new ItemStack[]{TechMutation.TECH_MUTATION_I});
            mobTech.setMobTechType(item.getMobTechType());
            mobTech.setMobTechTier(i);
            mobTech.register(plugin);
        }
    }

    private static SlimefunItemStack getMutationStartRecipe(MobTechGeneric.MobTechType mobTechType) {
        if (MobTechGeneric.MobTechType.MUTATION_BERSERK == mobTechType) {
            return SupremeComponents.GENE_BERSERK;
        }
        if (MobTechGeneric.MobTechType.MUTATION_INTELLIGENCE == mobTechType) {
            return SupremeComponents.GENE_INTELLIGENCE;
        }
        if (MobTechGeneric.MobTechType.MUTATION_LUCK == mobTechType) {
            return SupremeComponents.GENE_LUCK;
        }
        return null;
    }

    @Nonnull
    public Radioactivity getRadioactivity() {
        Radioactivity radioactivity;
        switch (this.mobTechType) {
            case MUTATION_INTELLIGENCE: 
            case MUTATION_BERSERK: 
            case MUTATION_LUCK: {
                radioactivity = Radioactivity.VERY_DEADLY;
                break;
            }
            case ROBOTIC_CLONING: 
            case ROBOTIC_ACCELERATION: 
            case ROBOTIC_EFFICIENCY: {
                radioactivity = Radioactivity.HIGH;
                break;
            }
            default: {
                radioactivity = Radioactivity.LOW;
            }
        }
        return radioactivity;
    }

    public void setMobTechTier(Integer mobTechTier) {
        this.mobTechTier = mobTechTier;
    }

    public Integer getMobTechTier() {
        return this.mobTechTier;
    }

    public void setMobTechType(MobTechGeneric.MobTechType mobTechType) {
        this.mobTechType = mobTechType;
    }

    public MobTechGeneric.MobTechType getMobTechType() {
        return this.mobTechType;
    }
}

