/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.machine;

import com.github.relativobr.supreme.Supreme;
import com.github.relativobr.supreme.resource.SupremeComponents;
import com.github.relativobr.supreme.util.ItemGroups;
import com.github.relativobr.supreme.util.UtilEnergy;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineTier;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.springframework.scheduling.annotation.Async;

@Async
public class CheckInventory
extends SlimefunItem
implements InventoryBlock {
    public static final SlimefunItemStack CHECK_INVENTORY = new SlimefunItemStack("SUPREME_CHECK_INVENTORY", Material.REDSTONE_LAMP, "&bCheckInventory", new String[]{"", "&fChecks if the nearby chest has the filter item", "&fall faces are being considered (find first)", "&fif found, this block will light up", LoreBuilder.machine((MachineTier)MachineTier.ADVANCED, (MachineType)MachineType.MACHINE), LoreBuilder.speed((float)1.0f), UtilEnergy.energyPowerPerSecond(0), "", "&3Supreme Machine"});
    private static final ItemStack[] RECIPE_CHECK_INVENTORY = new ItemStack[]{SupremeComponents.ALLOY_AURUM, new ItemStack(Material.REDSTONE_LAMP), SupremeComponents.ALLOY_AURUM, SupremeComponents.INDUCTIVE_MACHINE, SupremeComponents.SYNTHETIC_RUBY, SupremeComponents.INDUCTIVE_MACHINE, new ItemStack(Material.REDSTONE_BLOCK), new ItemStack(Material.COMPARATOR), new ItemStack(Material.REDSTONE_BLOCK)};
    private static int MAIN_SLOT = 13;
    private static int[] BORDER_SLOT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private int countDelayTick = 0;
    private static boolean light = false;

    public static void setup(Supreme plugin) {
        new CheckInventory(ItemGroups.MACHINES_CATEGORY, CHECK_INVENTORY, RecipeType.ENHANCED_CRAFTING_TABLE, RECIPE_CHECK_INVENTORY).register(plugin);
    }

    @ParametersAreNonnullByDefault
    public CheckInventory(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{this.onBlockBreak()});
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                CheckInventory.this.constructMenu(this);
            }

            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return CheckInventory.this.getInputSlots();
                }
                return CheckInventory.this.getOutputSlots();
            }
        };
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                CheckInventory.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    private void tick(Block b) {
        if (this.countDelayTick < 8) {
            ++this.countDelayTick;
            return;
        }
        this.countDelayTick = 0;
        if (!BlockStorage.hasInventory((Block)b) || !(b.getBlockData() instanceof Lightable)) {
            BlockStorage.clearBlockInfo((Block)b);
            return;
        }
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        ItemStack itemStack = inv.getItemInSlot(MAIN_SLOT);
        if (itemStack == null) {
            if (CheckInventory.isLight()) {
                CheckInventory.changeLightable(b, false);
            }
            return;
        }
        Block blockTarget = Stream.of(b.getRelative(BlockFace.DOWN), b.getRelative(BlockFace.UP), b.getRelative(BlockFace.NORTH), b.getRelative(BlockFace.EAST), b.getRelative(BlockFace.SOUTH), b.getRelative(BlockFace.WEST)).filter(x -> Material.TRAPPED_CHEST.equals((Object)x.getType()) || Material.CHEST.equals((Object)x.getType()) || Material.BARREL.equals((Object)x.getType())).findFirst().orElse(null);
        CheckInventory.checkItemInInventory(itemStack, b, blockTarget);
    }

    public static void checkItemInInventory(@Nonnull ItemStack itemStack, @Nonnull Block block, Block blockTarget) {
        if (blockTarget != null) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Supreme.inst(), () -> {
                BlockState targetState = blockTarget.getState();
                if (targetState instanceof InventoryHolder) {
                    Inventory targetInv = ((InventoryHolder)targetState).getInventory();
                    int amountMatch = Arrays.stream(targetInv.getContents()).filter(Objects::nonNull).filter(itemInv -> SlimefunUtils.isItemSimilar((ItemStack)itemStack, (ItemStack)itemInv, (boolean)false, (boolean)false)).mapToInt(ItemStack::getAmount).sum();
                    CheckInventory.changeLightable(block, itemStack.getAmount() <= amountMatch);
                } else {
                    CheckInventory.changeLightable(block, false);
                }
            }, 1L);
        }
    }

    private static void changeLightable(Block b, boolean status) {
        CheckInventory.setLight(status);
        if (b.getBlockData() instanceof Lightable) {
            Lightable lightable = (Lightable)b.getBlockData();
            lightable.setLit(status);
            b.setBlockData((BlockData)lightable);
        }
    }

    private void constructMenu(BlockMenuPreset menu) {
        for (int slot : BORDER_SLOT) {
            this.buildMenuBorder(menu, slot);
        }
    }

    private void buildMenuBorder(BlockMenuPreset menu, int slot) {
        menu.addItem(slot, (ItemStack)new CustomItemStack(Material.WHITE_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        menu.addMenuClickHandler(slot, ChestMenuUtils.getEmptyClickHandler());
    }

    public int[] getInputSlots() {
        return new int[]{MAIN_SLOT};
    }

    public int[] getOutputSlots() {
        return new int[]{MAIN_SLOT};
    }

    @Nonnull
    protected BlockBreakHandler onBlockBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), CheckInventory.this.getInputSlots());
                    inv.dropItems(b.getLocation(), CheckInventory.this.getOutputSlots());
                }
            }
        };
    }

    public static boolean isLight() {
        return light;
    }

    public static void setLight(boolean light) {
        CheckInventory.light = light;
    }
}

