/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.machine;

import com.github.relativobr.supreme.Supreme;
import com.github.relativobr.supreme.generic.recipe.InventoryRecipe;
import com.github.relativobr.supreme.util.ItemUtil;
import com.github.relativobr.supreme.util.SupremeQuarryOutput;
import com.github.relativobr.supreme.util.UtilEnergy;
import com.github.relativobr.supreme.util.UtilMachine;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class AbstractQuarry
extends SlimefunItem
implements EnergyNetComponent {
    private static final DecimalFormat FORMAT = new DecimalFormat("###,###,##0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private int tickDelayThreshold = 0;
    private int energyConsumed = -1;
    private int energyCapacity = -1;
    private int energyCharge = 0;
    private boolean enabled = true;
    private boolean effect = true;
    private int delaySpeed = 1;
    private SupremeQuarryOutput output;

    @ParametersAreNonnullByDefault
    public AbstractQuarry(ItemGroup category, SlimefunItemStack machine, ItemStack[] recipe) {
        super(category, machine, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.addItemHandler(new ItemHandler[]{this.onPlace(), this.onRightClick()});
    }

    @Nonnull
    public static String format(double number) {
        return FORMAT.format(number);
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                AbstractQuarry.this.tick(b);
            }

            public boolean isSynchronized() {
                return true;
            }
        }});
    }

    private void tick(Block b) {
        Block targetBlock = b.getRelative(BlockFace.DOWN);
        if (this.isInvalidInventory(targetBlock) || !this.enabled || this.getCharge(b.getLocation()) < this.getEnergyConsumption()) {
            return;
        }
        BlockState state = targetBlock.getState();
        if (state instanceof InventoryHolder) {
            ItemStack material;
            if (this.tickDelayThreshold < Supreme.getSupremeOptions().getCustomTickerDelay() * this.delaySpeed) {
                ++this.tickDelayThreshold;
                return;
            }
            this.tickDelayThreshold = 0;
            Inventory inv = ((InventoryHolder)state).getInventory();
            if (inv.firstEmpty() != -1 && (material = ItemUtil.getItemQuarry(this.getOutput(), UtilMachine.getRandomInt())) != null) {
                ItemStack itemStack = material.clone();
                itemStack.setAmount(1);
                inv.addItem(new ItemStack[]{itemStack});
                if (this.effect) {
                    Location loc = b.getLocation().add(0.5, 0.8, 0.5);
                    b.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, loc, 6);
                }
                this.removeCharge(b.getLocation(), this.getEnergyConsumption());
                this.energyCharge = this.getCharge(b.getLocation());
            }
        }
    }

    @Nonnull
    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            public void onPlayerPlace(BlockPlaceEvent e) {
                Block b = e.getBlockPlaced();
                BlockStorage.addBlockInfo((Block)b, (String)"owner", (String)e.getPlayer().getUniqueId().toString());
            }
        };
    }

    @Nonnull
    public BlockUseHandler onRightClick() {
        return e -> {
            e.cancel();
            Player p = e.getPlayer();
            Block b = (Block)e.getClickedBlock().get();
            this.energyCharge = this.getCharge(b.getLocation());
            if (this.isInvalidInventory(b.getRelative(BlockFace.DOWN))) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.CARGO_NODES.must-be-placed");
            } else if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"owner").equals(p.getUniqueId().toString()) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b, Interaction.INTERACT_BLOCK)) {
                this.showMachine(p, b);
            } else {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "inventory.no-access");
            }
        };
    }

    @ParametersAreNonnullByDefault
    protected void showMachine(Player p, Block b) {
        Validate.notNull((Object)p, (String)"The Player should not be null");
        Validate.notNull((Object)b, (String)"The Block should not be null");
        ChestMenu menu = new ChestMenu(this.getItemName());
        menu.setPlayerInventoryClickable(false);
        menu.setEmptySlotsClickable(false);
        ChestMenuUtils.drawBackground((ChestMenu)menu, (int[])InventoryRecipe.QUARRY_BORDER);
        ChestMenuUtils.drawBackground((ChestMenu)menu, (int[])InventoryRecipe.QUARRY_OUTPUT);
        ChestMenuUtils.drawBackground((ChestMenu)menu, (int[])InventoryRecipe.QUARRY_OUTPUT_BORDER);
        for (int i = 0; i < InventoryRecipe.QUARRY_INPUT_BORDER.length; ++i) {
            int slot2 = InventoryRecipe.QUARRY_INPUT_BORDER[i];
            menu.addItem(slot2, ChestMenuUtils.getInputSlotTexture(), ChestMenuUtils.getEmptyClickHandler());
        }
        String powerPerSecond = LoreBuilder.powerPerSecond((int)this.getEnergyConsumption());
        String powerCharged = LoreBuilder.powerCharged((int)this.energyCharge, (int)this.getCapacity());
        String infoSpeed = UtilEnergy.timePerItem(Supreme.getSupremeOptions().getCustomTickerDelay() * this.delaySpeed / 2);
        if (this.energyCharge < this.getEnergyConsumption() || !this.enabled) {
            menu.addItem(23, (ItemStack)new CustomItemStack(Material.OBSIDIAN, ChatColor.RED + "NOT-ACTIVE", new String[]{powerPerSecond, powerCharged, infoSpeed}));
            menu.addMenuClickHandler(23, ChestMenuUtils.getEmptyClickHandler());
        } else {
            menu.addItem(23, (ItemStack)new CustomItemStack(Material.GLOWSTONE, ChatColor.GREEN + "ACTIVE", new String[]{powerPerSecond, powerCharged, infoSpeed}));
            menu.addMenuClickHandler(23, ChestMenuUtils.getEmptyClickHandler());
        }
        if (this.enabled) {
            menu.addItem(21, (ItemStack)new CustomItemStack(Material.EMERALD_BLOCK, Slimefun.getLocalization().getMessages(p, "messages.auto-crafting.tooltips.enabled")));
            menu.addMenuClickHandler(21, (pl, item, slot, action) -> {
                this.enabled = false;
                this.showMachine(p, b);
                return false;
            });
        } else {
            menu.addItem(21, (ItemStack)new CustomItemStack(Material.REDSTONE_BLOCK, Slimefun.getLocalization().getMessages(p, "messages.auto-crafting.tooltips.disabled")));
            menu.addMenuClickHandler(21, (pl, item, slot, action) -> {
                this.enabled = true;
                this.showMachine(p, b);
                return false;
            });
        }
        p.playSound(p.getLocation(), Sound.BLOCK_BARREL_OPEN, 1.0f, 1.0f);
        menu.open(new Player[]{p});
    }

    protected boolean isInvalidInventory(@Nonnull Block block) {
        Material type = block.getType();
        switch (type) {
            case CHEST: 
            case TRAPPED_CHEST: 
            case BARREL: {
                return false;
            }
        }
        return !SlimefunTag.SHULKER_BOXES.isTagged(type);
    }

    public int getCapacity() {
        return this.energyCapacity;
    }

    @Nonnull
    public final AbstractQuarry setCapacity(int capacity) {
        Validate.isTrue((capacity > 0 ? 1 : 0) != 0, (String)"The capacity must be greater than zero!");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    public int getEnergyConsumption() {
        return this.energyConsumed;
    }

    @Nonnull
    public final AbstractQuarry setEnergyConsumption(int energyConsumption) {
        Validate.isTrue((energyConsumption > 0 ? 1 : 0) != 0, (String)"The energy consumption must be greater than zero!");
        Validate.isTrue((this.energyCapacity > 0 ? 1 : 0) != 0, (String)"You must specify the capacity before you can set the consumption amount.");
        Validate.isTrue((energyConsumption <= this.energyCapacity ? 1 : 0) != 0, (String)("The energy consumption cannot be higher than the capacity (" + this.energyCapacity + ')'));
        this.energyConsumed = energyConsumption;
        return this;
    }

    @Nonnull
    public final EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public SupremeQuarryOutput getOutput() {
        return this.output;
    }

    public AbstractQuarry setOutput(SupremeQuarryOutput output) {
        this.output = output;
        return this;
    }

    public AbstractQuarry setEffect(boolean effect) {
        this.effect = effect;
        return this;
    }

    public AbstractQuarry setDelaySpeed(int delaySpeed) {
        this.delaySpeed = delaySpeed;
        return this;
    }
}

