/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.util;

import com.github.relativobr.supreme.Supreme;
import com.github.relativobr.supreme.util.CompatibilySupremeLegacy;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EnchantsAndEffectsUtil {
    public static void addGearThorniumEnchants(SlimefunItemStack ... items) {
        ConfigurationSection typeSection = Supreme.inst().getConfig().getConfigurationSection("supreme-enchant");
        if (typeSection == null) {
            Supreme.inst().log(Level.SEVERE, "Config section \"supreme-enchant\" missing, Check your config and report this!");
            return;
        }
        for (SlimefunItemStack item : items) {
            ArrayList<String> lore;
            ItemMeta meta = item.getItemMeta();
            if (meta.hasLore()) {
                lore = meta.getLore();
            } else {
                lore = new ArrayList<String>();
                lore.add("");
            }
            lore.add(ChatColor.AQUA + "Soulbound");
            String itemPath = CompatibilySupremeLegacy.getNewIdSupremeLegacy(item.getItemId()).toLowerCase();
            EnchantsAndEffectsUtil.buildLoreEffects(lore, itemPath);
            meta.setLore(lore);
            ConfigurationSection itemSection = typeSection.getConfigurationSection(itemPath);
            if (itemSection != null) {
                meta.setUnbreakable(itemSection.getBoolean("unbreakable"));
                for (Map.Entry<Enchantment, Integer> entry : EnchantsAndEffectsUtil.getEnchants(itemSection).entrySet()) {
                    meta.addEnchant(entry.getKey(), entry.getValue().intValue(), true);
                }
            } else {
                Supreme.inst().log(Level.SEVERE, "Config section for " + itemPath + " missing, Check your config and report this!");
            }
            item.setItemMeta(meta);
        }
    }

    public static void addGearBasicEnchants(SlimefunItemStack ... items) {
        ConfigurationSection typeSection = Supreme.inst().getConfig().getConfigurationSection("supreme-enchant");
        if (typeSection == null) {
            Supreme.inst().log(Level.SEVERE, "Config section \"supreme-enchant\" missing, Check your config and report this!");
            return;
        }
        for (SlimefunItemStack item : items) {
            ArrayList<String> lore;
            ItemMeta meta = item.getItemMeta();
            if (meta.hasLore()) {
                lore = meta.getLore();
            } else {
                lore = new ArrayList<String>();
                lore.add("");
            }
            lore.add(ChatColor.AQUA + "Soulbound");
            String itemPath = CompatibilySupremeLegacy.getNewIdSupremeLegacy(item.getItemId()).toLowerCase();
            meta.setLore(lore);
            ConfigurationSection itemSection = typeSection.getConfigurationSection(itemPath);
            if (itemSection != null) {
                meta.setUnbreakable(itemSection.getBoolean("unbreakable"));
                for (Map.Entry<Enchantment, Integer> entry : EnchantsAndEffectsUtil.getEnchants(itemSection).entrySet()) {
                    meta.addEnchant(entry.getKey(), entry.getValue().intValue(), true);
                }
            } else {
                Supreme.inst().log(Level.SEVERE, "Config section for " + itemPath + " missing, Check your config and report this!");
            }
            item.setItemMeta(meta);
        }
    }

    @Nonnull
    private static Map<Enchantment, Integer> getEnchants(@Nonnull ConfigurationSection section) {
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        for (String path : section.getKeys(false)) {
            Enchantment e = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)path));
            if (e == null) continue;
            int level = section.getInt(path);
            if (level > 0 && level <= 100) {
                enchants.put(e, level);
                continue;
            }
            if (level == 0) continue;
            enchants.put(e, 1);
        }
        return enchants;
    }

    public static PotionEffect[] getPotionEffects(SlimefunItemStack item) {
        PotionEffect[] effect = new PotionEffect[]{};
        ConfigurationSection typeSectionEffects = Supreme.inst().getConfig().getConfigurationSection("supreme-effect");
        if (typeSectionEffects == null) {
            Supreme.inst().log(Level.SEVERE, "Config section \"supreme-enchant\" missing, Check your config and report this!");
            return effect;
        }
        String itemPath = CompatibilySupremeLegacy.getNewIdSupremeLegacy(item.getItemId()).toLowerCase();
        if (itemPath.contains("adamantium") || itemPath.contains("aurum") || itemPath.contains("titanium")) {
            return effect;
        }
        int amplifier = EnchantsAndEffectsUtil.getAmplifier(typeSectionEffects, itemPath);
        if (itemPath.contains("helmet")) {
            effect = EnchantsAndEffectsUtil.getEffects(effect, amplifier, typeSectionEffects.getConfigurationSection("helmet"));
        } else if (itemPath.contains("chestplate")) {
            effect = EnchantsAndEffectsUtil.getEffects(effect, amplifier, typeSectionEffects.getConfigurationSection("chestplate"));
        } else if (itemPath.contains("leggings")) {
            effect = EnchantsAndEffectsUtil.getEffects(effect, amplifier, typeSectionEffects.getConfigurationSection("leggings"));
        } else if (itemPath.contains("boots")) {
            effect = EnchantsAndEffectsUtil.getEffects(effect, amplifier, typeSectionEffects.getConfigurationSection("boots"));
        }
        return effect;
    }

    private static void buildLoreEffects(List<String> lore, String itemPath) {
        block6: {
            String amplifier;
            ConfigurationSection typeSectionEffects;
            block8: {
                block7: {
                    block5: {
                        typeSectionEffects = Supreme.inst().getConfig().getConfigurationSection("supreme-effect");
                        if (typeSectionEffects == null) {
                            Supreme.inst().log(Level.SEVERE, "Config section \"supreme-enchant\" missing, Check your config and report this!");
                            return;
                        }
                        amplifier = EnchantsAndEffectsUtil.buildLoreAmplifier(EnchantsAndEffectsUtil.getAmplifier(typeSectionEffects, itemPath));
                        if (!itemPath.contains("helmet")) break block5;
                        for (String nameEffect : EnchantsAndEffectsUtil.getNamesEffects(typeSectionEffects.getConfigurationSection("helmet"))) {
                            lore.add(ChatColor.DARK_PURPLE + nameEffect + amplifier);
                        }
                        break block6;
                    }
                    if (!itemPath.contains("chestplate")) break block7;
                    for (String nameEffect : EnchantsAndEffectsUtil.getNamesEffects(typeSectionEffects.getConfigurationSection("chestplate"))) {
                        lore.add(ChatColor.DARK_PURPLE + nameEffect + amplifier);
                    }
                    break block6;
                }
                if (!itemPath.contains("leggings")) break block8;
                for (String nameEffect : EnchantsAndEffectsUtil.getNamesEffects(typeSectionEffects.getConfigurationSection("leggings"))) {
                    lore.add(ChatColor.DARK_PURPLE + nameEffect + amplifier);
                }
                break block6;
            }
            if (!itemPath.contains("boots")) break block6;
            for (String nameEffect : EnchantsAndEffectsUtil.getNamesEffects(typeSectionEffects.getConfigurationSection("boots"))) {
                lore.add(ChatColor.DARK_PURPLE + nameEffect + amplifier);
            }
        }
    }

    private static String buildLoreAmplifier(int amplifier) {
        switch (amplifier) {
            case 0: {
                return " I";
            }
            case 1: {
                return " II";
            }
            case 2: {
                return " III";
            }
            case 3: {
                return " IV";
            }
            case 4: {
                return " V";
            }
            case 5: {
                return " VI";
            }
            case 6: {
                return " VII";
            }
            case 7: {
                return " VIII";
            }
            case 8: {
                return " IX";
            }
            case 9: {
                return " X";
            }
        }
        return "";
    }

    private static int getAmplifier(ConfigurationSection typeSection, String itemPath) {
        int amplifier = 0;
        if (itemPath.endsWith("supreme")) {
            amplifier = typeSection.getInt("amplifier_supreme", 3);
        } else if (itemPath.endsWith("legendary")) {
            amplifier = typeSection.getInt("amplifier_legendary", 3);
        } else if (itemPath.endsWith("epic")) {
            amplifier = typeSection.getInt("amplifier_epic", 2);
        } else if (itemPath.endsWith("rare")) {
            amplifier = typeSection.getInt("amplifier_rare", 2);
        } else if (itemPath.endsWith("magic")) {
            amplifier = typeSection.getInt("amplifier_magic", 1);
        } else if (itemPath.endsWith("thornium")) {
            amplifier = typeSection.getInt("amplifier_thornium", 1);
        }
        if (--amplifier > 10) {
            amplifier = 10;
        }
        if (amplifier < 0) {
            amplifier = 0;
        }
        return amplifier;
    }

    private static PotionEffect[] getEffects(PotionEffect[] effect, int amplifier, ConfigurationSection section) {
        if (section != null) {
            ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
            for (String key : section.getKeys(true)) {
                PotionEffectType potionEffectType = PotionEffectType.getByName((String)key);
                if (!section.getBoolean(key) || potionEffectType == null) continue;
                potionEffects.add(new PotionEffect(potionEffectType, 600, amplifier, false, false, false));
            }
            if (potionEffects.size() > 0) {
                effect = potionEffects.toArray(new PotionEffect[0]);
            }
        }
        return effect;
    }

    private static List<String> getNamesEffects(ConfigurationSection section) {
        ArrayList<String> names = new ArrayList<String>();
        if (section != null) {
            for (String key : section.getKeys(true)) {
                PotionEffectType potionEffectType = PotionEffectType.getByName((String)key);
                if (!section.getBoolean(key) || potionEffectType == null) continue;
                String name = potionEffectType.getName();
                name = name.replace("_", " ");
                name = name.substring(0, 1).toUpperCase().concat(name.substring(1).toLowerCase());
                names.add(name);
            }
        }
        return names;
    }
}

