/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.util;

import com.github.relativobr.supreme.Supreme;
import com.github.relativobr.supreme.util.CompatibilySupremeLegacyItem;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;

public class CompatibilySupremeLegacy {
    public static String getOldIdSupremeLegacy(String newId) {
        if (Supreme.getSupremeOptions().isUseLegacySupremeexpansionItemId()) {
            Optional<CompatibilySupremeLegacyItem> legacyItem;
            if (Supreme.getLegacyItem().isEmpty()) {
                Supreme.inst().log(Level.WARNING, "get Legacy Items error");
            }
            if ((legacyItem = Supreme.getLegacyItem().stream().filter(x -> x.getNewSupremeID().equals(newId)).findFirst()).isPresent()) {
                return legacyItem.get().getOldSupremeID();
            }
        }
        return newId;
    }

    public static String getNewIdSupremeLegacy(String oldId) {
        if (Supreme.getSupremeOptions().isUseLegacySupremeexpansionItemId()) {
            Optional<CompatibilySupremeLegacyItem> legacyItem;
            if (Supreme.getLegacyItem().isEmpty()) {
                Supreme.inst().log(Level.WARNING, "get Legacy Items error");
            }
            if ((legacyItem = Supreme.getLegacyItem().stream().filter(x -> x.getOldSupremeID().equals(oldId)).findFirst()).isPresent()) {
                return legacyItem.get().getNewSupremeID();
            }
        }
        return oldId;
    }

    private static CompatibilySupremeLegacyItem addSupremeLegacyItem(String newSupremeID, String oldSupremeID) {
        return new CompatibilySupremeLegacyItem(newSupremeID, oldSupremeID);
    }

    private static CompatibilySupremeLegacyItem addSupremeLegacyItemWithReplace(String newSupremeID, String oldString) {
        return CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace(newSupremeID, oldString, "SUPREME_");
    }

    private static CompatibilySupremeLegacyItem addSupremeLegacyItemWithReplace(String newSupremeID, String oldString, String newString) {
        return new CompatibilySupremeLegacyItem(newSupremeID, newSupremeID.replaceAll(newString, oldString));
    }

    private static CompatibilySupremeLegacyItem addSupremeLegacyItemRemovePrefix(String newSupremeID) {
        return CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix(newSupremeID, "SUPREME_");
    }

    private static CompatibilySupremeLegacyItem addSupremeLegacyItemRemovePrefix(String newSupremeID, String prefix) {
        return new CompatibilySupremeLegacyItem(newSupremeID, newSupremeID.substring(prefix.length()));
    }

    public static void loadComponents(List<CompatibilySupremeLegacyItem> result) {
        String resourcePrefix = "RESOURCE_";
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_SUPREME"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_SUPREME_NUGGET"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_THORNIUM_BIT", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_THORNIUM_DUST", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_THORNIUM_INGOT", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_THORNIUM_BIT_SYNTHETIC", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_THORNIUM_DUST_SYNTHETIC", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_THORNIUM_INGOT_SYNTHETIC", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_THORNIUM_CARBONADO", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_THORNIUM_ENERGIZED", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ALLOY_ZIRCONIUM", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ZIRCONIUM_PLATE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ALLOY_TITANIUM", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_TITANIUM_PLATE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ALLOY_IRIDIUM", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_IRIDIUM_PLATE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ALLOY_AURUM", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AURUM_PLATE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ALLOY_MANGANESE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_MANGANESE_PLATE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ALLOY_PLATINUM", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_PLATINUM_PLATE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ALLOY_ADAMANTIUM", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ADAMANTIUM_PLATE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SYNTHETIC_AMETHYST", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SYNTHETIC_RUBY", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_THORNERITE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_INDUCTIVE_MACHINE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_INDUCTOR_MACHINE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_RUSTLESS_MACHINE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_STAINLESS_MACHINE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CARRIAGE_MACHINE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CONVEYANCE_MACHINE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_PETRIFIER_MACHINE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CRYSTALLIZER_MACHINE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_BLEND_MACHINE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_CORE_OF_LIFE"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_CORE_OF_DEATH"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_CORE_OF_COLOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_CORE_OF_BLOCK"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_CORE_OF_NATURE"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_CORE_OF_ALLOY"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_CETRUS_LUX"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_CETRUS_VENTUS"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_CETRUS_LUMIUM"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_CETRUS_AQUA"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_CETRUS_IGNIS"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_ATTRIBUTE_MAGIC"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_ATTRIBUTE_BOMB"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_ATTRIBUTE_FORTUNE"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_ATTRIBUTE_IMPETUS"));
    }

    public static void loadGear(List<CompatibilySupremeLegacyItem> result) {
        String armorPrefix = "ARMOR_";
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ADAMANTIUM_HELMET", "ARMOR_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AURUM_HELMET", "ARMOR_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_TITANIUM_HELMET", "ARMOR_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ADAMANTIUM_CHESTPLATE", "ARMOR_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AURUM_CHESTPLATE", "ARMOR_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_TITANIUM_CHESTPLATE", "ARMOR_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ADAMANTIUM_LEGGINGS", "ARMOR_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AURUM_LEGGINGS", "ARMOR_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_TITANIUM_LEGGINGS", "ARMOR_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ADAMANTIUM_BOOTS", "ARMOR_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AURUM_BOOTS", "ARMOR_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_TITANIUM_BOOTS", "ARMOR_"));
        String armorThorniumPrefix = "ARMOR_THORNIUM_";
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_BOOTS_THORNIUM", "ARMOR_THORNIUM_BOOTS"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_BOOTS_MAGIC", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_BOOTS_RARE", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_BOOTS_EPIC", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_BOOTS_LEGENDARY", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_BOOTS_SUPREME", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_CHESTPLATE_THORNIUM", "ARMOR_THORNIUM_CHESTPLATE"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CHESTPLATE_MAGIC", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CHESTPLATE_RARE", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CHESTPLATE_EPIC", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CHESTPLATE_LEGENDARY", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CHESTPLATE_SUPREME", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_HELMET_THORNIUM", "ARMOR_THORNIUM_HELMET"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_HELMET_MAGIC", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_HELMET_RARE", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_HELMET_EPIC", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_HELMET_LEGENDARY", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_HELMET_SUPREME", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_LEGGINGS_THORNIUM", "ARMOR_THORNIUM_LEGGINGS"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_LEGGINGS_MAGIC", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_LEGGINGS_RARE", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_LEGGINGS_EPIC", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_LEGGINGS_LEGENDARY", "ARMOR_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_LEGGINGS_SUPREME", "ARMOR_THORNIUM_"));
        String toolsPrefix = "TOOLS_";
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ADAMANTIUM_AXE", "TOOLS_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AURUM_AXE", "TOOLS_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_TITANIUM_AXE", "TOOLS_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ADAMANTIUM_PICKAXE", "TOOLS_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AURUM_PICKAXE", "TOOLS_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_TITANIUM_PICKAXE", "TOOLS_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ADAMANTIUM_SHOVEL", "TOOLS_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AURUM_SHOVEL", "TOOLS_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_TITANIUM_SHOVEL", "TOOLS_"));
        String toolsThorniumPrefix = "TOOLS_THORNIUM_";
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_AXE_THORNIUM", "TOOLS_THORNIUM_AXE"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AXE_MAGIC", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AXE_RARE", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AXE_EPIC", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AXE_LEGENDARY", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AXE_SUPREME", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_PICKAXE_THORNIUM", "TOOLS_THORNIUM_PICKAXE"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_PICKAXE_MAGIC", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_PICKAXE_RARE", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_PICKAXE_EPIC", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_PICKAXE_LEGENDARY", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_PICKAXE_SUPREME", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_SHOVEL_THORNIUM", "TOOLS_THORNIUM_SHOVEL"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SHOVEL_MAGIC", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SHOVEL_RARE", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SHOVEL_EPIC", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SHOVEL_LEGENDARY", "TOOLS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SHOVEL_SUPREME", "TOOLS_THORNIUM_"));
        String weaponsPrefix = "WEAPONS_";
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_ADAMANTIUM_SWORD", "WEAPONS_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_AURUM_SWORD", "WEAPONS_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_TITANIUM_SWORD", "WEAPONS_"));
        String weaponsThorniumPrefix = "WEAPONS_THORNIUM_";
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_BOW_THORNIUM", "WEAPONS_THORNIUM_BOW"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_BOW_MAGIC", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_BOW_RARE", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_BOW_EPIC", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_BOW_LEGENDARY", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_BOW_SUPREME", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_SHIELD_THORNIUM", "WEAPONS_THORNIUM_SHIELD"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SHIELD_MAGIC", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SHIELD_RARE", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SHIELD_EPIC", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SHIELD_LEGENDARY", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SHIELD_SUPREME", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_SWORD_THORNIUM", "WEAPONS_THORNIUM_SWORD"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SWORD_MAGIC", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SWORD_RARE", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SWORD_EPIC", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SWORD_LEGENDARY", "WEAPONS_THORNIUM_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_SWORD_SUPREME", "WEAPONS_THORNIUM_"));
    }

    public static void loadGenerators(List<CompatibilySupremeLegacyItem> result) {
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_AURUM_CAPACITOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_TITANIUM_CAPACITOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_ADAMANTIUM_CAPACITOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_THORNIUM_CAPACITOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_SUPREME_CAPACITOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_BASIC_IGNIS_GENERATOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_IGNIS_GENERATOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_BASIC_VENTUS_GENERATOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_VENTUS_GENERATOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_BASIC_AQUA_GENERATOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_AQUA_GENERATOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_BASIC_LUX_GENERATOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_LUX_GENERATOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_BASIC_LUMIUM_GENERATOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_LUMIUM_GENERATOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_THORNIUM_GENERATOR"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_SUPREME_GENERATOR"));
    }

    public static void loadMachines(List<CompatibilySupremeLegacyItem> result) {
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_ELECTRIC_CORE_I", "ELECTRIC_CORE_MACHINE"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_ELECTRIC_CORE_II", "ELECTRIC_CORE_MACHINE_II"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_ELECTRIC_CORE_III", "ELECTRIC_CORE_MACHINE_III"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_COAL_QUARRY"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_IRON_QUARRY"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_GOLD_QUARRY"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_DIAMOND_QUARRY"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemRemovePrefix("SUPREME_THORNIUM_QUARRY"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItem("SUPREME_SUPREME_NUGGETS_QUARRY", "UNIQUENUGGETS_QUARRY"));
    }

    public static void loadCoreResource(List<CompatibilySupremeLegacyItem> result) {
        String resourcePrefix = "RESOURCE_";
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_COAL", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_IRON", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_GOLD", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_REDSTONE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_LAPIS", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_DIAMOND", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_EMERALD", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_QUARTZ", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_NETHERITE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_STONE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_GRANITE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_DIORITE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_ANDESITE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_GRAVEL", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_SAND", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_ENDSTONE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_CLAY", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_SNOW", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_RED", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_YELLOW", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_PURPLE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_BLUE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_BLACK", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_GREEN", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_PINK", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_GRAY", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_CYAN", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_PORKCHOP", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_BEEF", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_MUTTON", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_CHICKEN", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_SALMON", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_COD", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_STRING", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_SPIDER_EYE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_TEAR", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_POTATO", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_APPLE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_BEETROOT", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_WHEAT", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_SUGAR_CANE", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_SWEET_BERRIES", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_MELON", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_CARROT", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_PUMPKIN", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_OAK_LOG", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_SPRUCE_LOG", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_BIRCH_LOG", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_JUNGLE_LOG", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_ACACIA_LOG", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_DARK_OAK_LOG", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_CRIMSON_STEM", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_WARPED_STEM", "RESOURCE_"));
        result.add(CompatibilySupremeLegacy.addSupremeLegacyItemWithReplace("SUPREME_CORE_WITHER_ROSE", "RESOURCE_"));
    }

    public static CompatibilySupremeLegacyBuilder builder() {
        return new CompatibilySupremeLegacyBuilder();
    }

    public static class CompatibilySupremeLegacyBuilder {
        CompatibilySupremeLegacyBuilder() {
        }

        public CompatibilySupremeLegacy build() {
            return new CompatibilySupremeLegacy();
        }

        public String toString() {
            return "CompatibilySupremeLegacy.CompatibilySupremeLegacyBuilder()";
        }
    }
}

