/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.generic.recipe;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class AbstractItemRecipe {
    private ItemStack[] input;
    private ItemStack[] output;

    public ItemStack[] getInputNotNull() {
        return this.filterNotNull(this.getInput());
    }

    public ItemStack[] getOutputNotNull() {
        return this.filterNotNull(this.getOutput());
    }

    private ItemStack[] filterNotNull(ItemStack[] array) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack itemStack : array) {
            if (itemStack == null) continue;
            list.add(itemStack);
        }
        return list.toArray(new ItemStack[0]);
    }

    public ItemStack getItemInput(int index) {
        return this.input[index];
    }

    public ItemStack getItemOutput(int index) {
        return this.output[index];
    }

    public Material getMaterialInput(int index) {
        return this.getItemInput(index) != null ? this.getItemInput(index).getType() : null;
    }

    public Material getMaterialOutput(int index) {
        return this.getItemOutput(index) != null ? this.getItemOutput(index).getType() : null;
    }

    public ItemStack getFirstItemInput() {
        return this.getItemInput(0);
    }

    public ItemStack getFirstItemOutput() {
        return this.getItemOutput(0);
    }

    public ItemStack getSecondItemInput() {
        return this.getItemInput(1);
    }

    public ItemStack getSecondItemOutput() {
        return this.getItemOutput(1);
    }

    public Material getFirstMaterialInput() {
        return this.getMaterialInput(0);
    }

    public Material getFirstMaterialOutput() {
        return this.getMaterialOutput(0);
    }

    public Material getSecondMaterialInput() {
        return this.getMaterialInput(1);
    }

    public Material getSecondMaterialOutput() {
        return this.getMaterialOutput(1);
    }

    public AbstractItemRecipe(@Nonnull ItemStack input, @Nonnull ItemStack output) {
        this.input = new ItemStack[]{input};
        this.output = new ItemStack[]{output};
    }

    public AbstractItemRecipe(@Nonnull ItemStack[] input, @Nonnull ItemStack output) {
        this.input = input;
        this.output = new ItemStack[]{output};
    }

    public AbstractItemRecipe(@Nonnull ItemStack input, @Nonnull ItemStack[] output) {
        this.input = new ItemStack[]{input};
        this.output = output;
    }

    public AbstractItemRecipe(@Nonnull Material input, @Nonnull Material output) {
        this.input = new ItemStack[]{new ItemStack(input)};
        this.output = new ItemStack[]{new ItemStack(output)};
    }

    public AbstractItemRecipe(@Nonnull ItemStack[] input, @Nonnull Material output) {
        this.input = input;
        this.output = new ItemStack[]{new ItemStack(output)};
    }

    public AbstractItemRecipe(@Nonnull Material input, @Nonnull ItemStack[] output) {
        this.input = new ItemStack[]{new ItemStack(input)};
        this.output = output;
    }

    public AbstractItemRecipe(@Nonnull ItemStack input, @Nonnull Material output) {
        this.input = new ItemStack[]{input};
        this.output = new ItemStack[]{new ItemStack(output)};
    }

    public AbstractItemRecipe(@Nonnull Material input, @Nonnull ItemStack output) {
        this.input = new ItemStack[]{new ItemStack(input)};
        this.output = new ItemStack[]{output};
    }

    public AbstractItemRecipe(@Nonnull ItemStack input1, ItemStack input2, @Nonnull ItemStack output1, ItemStack output2) {
        this.input = new ItemStack[]{input1, input2};
        this.output = new ItemStack[]{output1, output2};
    }

    public AbstractItemRecipe(@Nonnull Material input1, Material input2, @Nonnull Material output1, Material output2) {
        this.input = new ItemStack[]{new ItemStack(input1), input2 == null ? null : new ItemStack(input2)};
        this.output = new ItemStack[]{new ItemStack(output1), output2 == null ? null : new ItemStack(output2)};
    }

    public AbstractItemRecipe(@Nonnull ItemStack input1, ItemStack input2, @Nonnull Material output1, Material output2) {
        this.input = new ItemStack[]{input1, input2};
        this.output = new ItemStack[]{new ItemStack(output1), output2 == null ? null : new ItemStack(output2)};
    }

    public AbstractItemRecipe(@Nonnull Material input1, Material input2, @Nonnull ItemStack output1, ItemStack output2) {
        this.input = new ItemStack[]{new ItemStack(input1), input2 == null ? null : new ItemStack(input2)};
        this.output = new ItemStack[]{output1, output2};
    }

    public ItemStack[] getInput() {
        return this.input;
    }

    public ItemStack[] getOutput() {
        return this.output;
    }

    public void setInput(ItemStack[] input) {
        this.input = input;
    }

    public void setOutput(ItemStack[] output) {
        this.output = output;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemRecipe)) {
            return false;
        }
        AbstractItemRecipe other = (AbstractItemRecipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInput(), other.getInput())) {
            return false;
        }
        return Arrays.deepEquals(this.getOutput(), other.getOutput());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemRecipe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getInput());
        result = result * 59 + Arrays.deepHashCode(this.getOutput());
        return result;
    }

    public String toString() {
        return "AbstractItemRecipe(input=" + Arrays.deepToString(this.getInput()) + ", output=" + Arrays.deepToString(this.getOutput()) + ")";
    }

    public AbstractItemRecipe(ItemStack[] input, ItemStack[] output) {
        this.input = input;
        this.output = output;
    }

    public AbstractItemRecipe() {
    }
}

