/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.generic.machine;

import com.github.relativobr.supreme.generic.recipe.AbstractItemRecipe;
import com.github.relativobr.supreme.generic.recipe.InventoryRecipe;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotHopperable;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MediumContainerMachine
extends AContainer
implements NotHopperable,
RecipeDisplayItem {
    private final Map<Block, MachineRecipe> processing = new HashMap<Block, MachineRecipe>();
    private final Map<Block, Integer> progressItem = new HashMap<Block, Integer>();
    private final Map<Block, Integer> progressTime = new HashMap<Block, Integer>();
    public List<AbstractItemRecipe> machineRecipes = new ArrayList<AbstractItemRecipe>();
    private Integer timeProcess;
    private String machineIdentifier = "MediumContainerMachine";

    public int getSizeProcessInput() {
        return 9;
    }

    @ParametersAreNonnullByDefault
    public MediumContainerMachine(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{this.onBlockBreak()});
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                MediumContainerMachine.this.constructMenu(this);
            }

            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return MediumContainerMachine.this.getOutputSlots();
                }
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return MediumContainerMachine.this.getOutputSlots();
                }
                int fullSlots = 0;
                LinkedList<Integer> slots = new LinkedList<Integer>();
                for (int slot : MediumContainerMachine.this.getInputSlots()) {
                    ItemStack stack = menu.getItemInSlot(slot);
                    if (stack == null || !SlimefunUtils.isItemSimilar((ItemStack)stack, (ItemStack)item, (boolean)false, (boolean)true)) continue;
                    if (stack.getAmount() >= stack.getMaxStackSize()) {
                        ++fullSlots;
                    }
                    slots.add(slot);
                }
                if (slots.isEmpty()) {
                    return MediumContainerMachine.this.getInputSlots();
                }
                if (fullSlots == slots.size()) {
                    return new int[0];
                }
                slots.sort(MediumContainerMachine.this.compareSlots(menu));
                int[] array = new int[slots.size()];
                for (int i = 0; i < slots.size(); ++i) {
                    array[i] = (Integer)slots.get(i);
                }
                return array;
            }
        };
    }

    @Nonnull
    protected BlockBreakHandler onBlockBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), MediumContainerMachine.this.getInputSlots());
                    inv.dropItems(b.getLocation(), MediumContainerMachine.this.getOutputSlots());
                }
                MediumContainerMachine.this.progressTime.remove(b);
                MediumContainerMachine.this.processing.remove(b);
                MediumContainerMachine.this.progressItem.remove(b);
            }
        };
    }

    private void invalidInput(BlockMenu menu) {
        menu.replaceExistingItem(this.getStatusSlot(), (ItemStack)new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cInput a valid material to start", new String[0]));
    }

    private void invalidOutput(BlockMenu menu) {
        menu.replaceExistingItem(this.getStatusSlot(), (ItemStack)new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cOutput is full", new String[0]));
    }

    private void noEnergyStart(BlockMenu menu) {
        menu.replaceExistingItem(this.getStatusSlot(), (ItemStack)new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cConnect energy to start", new String[0]));
    }

    private void noEnergyContinue(BlockMenu menu, ItemStack material) {
        menu.replaceExistingItem(this.getStatusSlot(), (ItemStack)new CustomItemStack(material, "&cConnect energy to continue", new String[0]));
    }

    private void noMaterialContinue(BlockMenu menu, ItemStack material) {
        menu.replaceExistingItem(this.getStatusSlot(), (ItemStack)new CustomItemStack(material, "&cDeposit more materials to continue", new String[0]));
    }

    public MediumContainerMachine setMachineRecipes(@Nonnull List<AbstractItemRecipe> machineRecipes) {
        this.machineRecipes = machineRecipes;
        return this;
    }

    public MediumContainerMachine setTimeProcess(int timeProcess) {
        this.timeProcess = timeProcess;
        return this;
    }

    public int getTimeProcess() {
        if (this.timeProcess == null) {
            this.timeProcess = 15;
        }
        return this.timeProcess;
    }

    @Nonnull
    private Comparator<Integer> compareSlots(@Nonnull DirtyChestMenu menu) {
        return Comparator.comparingInt(slot -> menu.getItemInSlot(slot.intValue()).getAmount());
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : this.getBorderSlots()) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getInputBorderSlots()) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.CYAN_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getOutputBorderSlots()) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(this.getStatusSlot(), (ItemStack)new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    if (cursor == null) {
                        return true;
                    }
                    return cursor.getType() == Material.AIR;
                }
            });
        }
    }

    public ItemStack getProgressBar() {
        return new ItemStack(Material.PISTON);
    }

    public int[] getInputSlots() {
        return InventoryRecipe.MEDIUM_INPUT;
    }

    public int[] getOutputSlots() {
        return InventoryRecipe.MEDIUM_OUTPUT;
    }

    public int getStatusSlot() {
        return 23;
    }

    public int[] getBorderSlots() {
        return InventoryRecipe.MEDIUM_BORDER;
    }

    public int[] getInputBorderSlots() {
        return InventoryRecipe.MEDIUM_INPUT_BORDER;
    }

    public int[] getOutputBorderSlots() {
        return InventoryRecipe.MEDIUM_OUTPUT_BORDER;
    }

    @Nonnull
    public String getMachineIdentifier() {
        return Objects.nonNull(this.machineIdentifier) ? this.machineIdentifier : "MachineIdentifier";
    }

    public MediumContainerMachine setMachineIdentifier(@Nonnull String machineIdentifier) {
        this.machineIdentifier = machineIdentifier;
        return this;
    }

    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        if (this.isProcessing(b)) {
            MachineRecipe machineRecipe = this.processing.get(b);
            if (this.getCharge(b.getLocation()) < this.getEnergyConsumption()) {
                this.noEnergyContinue(inv, machineRecipe.getOutput()[0]);
                return;
            }
            int processItem = this.getProgressItem(b);
            int ticks = this.getProcessing(b).getTicks();
            int ticksLeft = this.getProgressTime(b);
            ItemStack[] result = machineRecipe.getOutput();
            int fullSlots = 0;
            LinkedList<Integer> slots = new LinkedList<Integer>();
            for (int slot : this.getOutputSlots()) {
                ItemStack stack = inv.getItemInSlot(slot);
                if (stack == null || !SlimefunUtils.isItemSimilar((ItemStack)stack, (ItemStack)result[0], (boolean)false, (boolean)false)) continue;
                if (stack.getAmount() >= stack.getMaxStackSize()) {
                    ++fullSlots;
                }
                slots.add(slot);
            }
            if (!slots.isEmpty() && fullSlots == this.getOutputSlots().length) {
                this.invalidOutput(inv);
                return;
            }
            int sizeProcessInput = this.getSizeProcessInput();
            if (sizeProcessInput == -1) {
                sizeProcessInput = machineRecipe.getInput().length;
            }
            if (ticksLeft == ticks && ticksLeft > 0 && this.takeCharge(b.getLocation())) {
                this.startProcessTicks(b, inv, ticks, ticksLeft, result[0]);
            } else if (ticksLeft <= 0 && processItem >= sizeProcessInput && this.takeCharge(b.getLocation())) {
                this.endProcessTicks(b, inv, result);
            } else if (ticksLeft <= 0 && processItem < sizeProcessInput && this.takeCharge(b.getLocation())) {
                this.checkMaterialProgress(b, inv, machineRecipe, processItem, sizeProcessInput, ticks, ticksLeft, result);
            } else {
                this.processTicks(b, inv, machineRecipe, processItem, sizeProcessInput, ticks, ticksLeft, result);
            }
        } else {
            if (this.getCharge(b.getLocation()) < this.getEnergyConsumption()) {
                this.noEnergyStart(inv);
                return;
            }
            MachineRecipe next = this.findNextRecipe(inv);
            if (next != null) {
                this.processing.put(b, next);
                this.progressTime.put(b, next.getTicks());
                this.progressItem.put(b, 0);
            } else {
                this.invalidInput(inv);
            }
        }
    }

    private void processTicks(Block b, BlockMenu inv, MachineRecipe machineRecipe, int processItem, int sizeProcessInput, int ticks, int ticksLeft, ItemStack[] result) {
        ItemStack[] recipeInput = machineRecipe.getInput();
        if (ticksLeft < ticks && ticksLeft > 0 && this.takeCharge(b.getLocation())) {
            ItemStack itemStack;
            int time = ticksLeft - this.getSpeed();
            if (time < 0) {
                time = 0;
            }
            this.progressTime.put(b, time);
            ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)this.getStatusSlot(), (int)ticksLeft, (int)ticks, (ItemStack)result[0]);
            if (processItem < sizeProcessInput && recipeInput[processItem] != null && this.consumeItem(b, itemStack = recipeInput[processItem])) {
                this.progressItem.put(b, processItem + 1);
            }
        }
    }

    private void endProcessTicks(Block b, BlockMenu inv, ItemStack[] result) {
        for (ItemStack itemStack : result) {
            inv.pushItem(itemStack.clone(), this.getOutputSlots());
        }
        this.progressTime.remove(b);
        this.processing.remove(b);
        this.progressItem.remove(b);
        this.invalidInput(inv);
    }

    private void startProcessTicks(Block b, BlockMenu inv, int ticks, int ticksLeft, ItemStack itemStack) {
        ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)this.getStatusSlot(), (int)ticksLeft, (int)ticks, (ItemStack)itemStack);
        int time = ticksLeft - this.getSpeed();
        if (time < 0) {
            time = 0;
        }
        this.progressTime.put(b, time);
        this.progressItem.put(b, 0);
    }

    private void checkMaterialProgress(Block b, BlockMenu inv, MachineRecipe machineRecipe, int processItem, int sizeProcessInput, int ticks, int ticksLeft, ItemStack[] result) {
        this.noMaterialContinue(inv, result[0]);
        for (int i = processItem; i < sizeProcessInput; ++i) {
            ItemStack itemStack = machineRecipe.getInput()[i];
            if (!this.consumeItem(b, itemStack)) continue;
            if (ticksLeft > 0) {
                int time = ticksLeft - this.getSpeed();
                if (time < 0) {
                    time = 0;
                }
                this.progressTime.put(b, time);
            }
            this.progressItem.put(b, i + 1);
            ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)this.getStatusSlot(), (int)ticksLeft, (int)ticks, (ItemStack)result[0]);
        }
    }

    private boolean consumeItem(Block b, ItemStack itemToConsume) {
        int[] inputSlots;
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        for (int slot : inputSlots = this.getInputSlots()) {
            ItemStack item = inv.getItemInSlot(slot);
            if (item == null || !SlimefunUtils.isItemSimilar((ItemStack)item, (ItemStack)itemToConsume, (boolean)false, (boolean)true)) continue;
            inv.consumeItem(slot, itemToConsume.getAmount());
            return true;
        }
        return false;
    }

    protected MachineRecipe findNextRecipe(BlockMenu inv) {
        int[] inputSlots = this.getInputSlots();
        for (AbstractItemRecipe recipe : this.machineRecipes) {
            ItemStack[] recipeInput = recipe.getInput();
            int sizeProcessInput = this.getSizeProcessInput();
            if (sizeProcessInput == -1) {
                recipeInput = recipe.getInputNotNull();
                sizeProcessInput = recipeInput.length;
            }
            int foundSize = 0;
            block1: for (ItemStack itemStack : recipeInput) {
                for (int inputSlot : inputSlots) {
                    if (!SlimefunUtils.isItemSimilar((ItemStack)inv.getItemInSlot(inputSlot), (ItemStack)itemStack, (boolean)false, (boolean)true)) continue;
                    ++foundSize;
                    continue block1;
                }
            }
            if (foundSize != sizeProcessInput) continue;
            return new MachineRecipe(this.getTimeProcess(), recipeInput, recipe.getOutput());
        }
        return null;
    }

    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>();
        this.machineRecipes.forEach(recipe -> {
            displayRecipes.add((ItemStack)new CustomItemStack(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]));
            displayRecipes.add(recipe.getFirstItemOutput());
        });
        return displayRecipes;
    }

    public int getProgressTime(Block b) {
        return this.progressTime.get(b) != null ? this.progressTime.get(b).intValue() : this.getTimeProcess();
    }

    public int getProgressItem(Block b) {
        return this.progressItem.get(b) != null ? this.progressItem.get(b) : 0;
    }

    public MachineRecipe getProcessing(Block b) {
        return this.processing.get(b);
    }

    public boolean isProcessing(Block b) {
        return this.getProcessing(b) != null;
    }
}

