/*
 * Decompiled with CFR 0.152.
 */
package com.github.relativobr.supreme.util;

import com.github.relativobr.supreme.Supreme;
import com.github.relativobr.supreme.machine.AbstractQuarry;
import com.github.relativobr.supreme.machine.AbstractQuarryOutputItem;
import com.github.relativobr.supreme.machine.tech.MobTechGeneric;
import com.github.relativobr.supreme.util.CompatibilySupremeLegacy;
import com.github.relativobr.supreme.util.SupremeQuarryOutput;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactivity;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class ItemUtil {
    public static int getValueGeneratorsWithLimit(int value) {
        return Math.min(Supreme.getSupremeOptions().isLimitProductionGenerators() ? value / 5 : value, 16000000);
    }

    public static SupremeQuarryOutput getOutputQuarry(@Nonnull SlimefunItemStack item) {
        ConfigurationSection typeSection = Supreme.inst().getConfig().getConfigurationSection("quarry-custom-output");
        if (typeSection == null) {
            Supreme.inst().log(Level.SEVERE, "Config section \"quarry-custom-output\" missing, Check your config and report this!");
            return null;
        }
        String itemPath = CompatibilySupremeLegacy.getNewIdSupremeLegacy(item.getItemId()).toLowerCase();
        ConfigurationSection itemSection = typeSection.getConfigurationSection(itemPath);
        ArrayList<AbstractQuarryOutputItem> outputItems = new ArrayList<AbstractQuarryOutputItem>();
        if (itemSection != null) {
            ConfigurationSection itemConfig;
            int checkLimitChance = 0;
            for (int i = 1; i <= 12 && (itemConfig = itemSection.getConfigurationSection(String.valueOf(i))) != null && checkLimitChance < 100; ++i) {
                String itemId;
                int chance = itemConfig.getInt("chance");
                if (checkLimitChance + chance >= 100) {
                    chance = 100 - checkLimitChance;
                }
                if ((itemId = itemConfig.getString("item")) == null) continue;
                if (itemConfig.getBoolean("is-slimefun")) {
                    SlimefunItem slimefunItem = SlimefunItem.getById((String)itemId);
                    if (slimefunItem == null && Supreme.getSupremeOptions().isUseLegacySupremeexpansionItemId()) {
                        slimefunItem = SlimefunItem.getById((String)CompatibilySupremeLegacy.getOldIdSupremeLegacy(itemId));
                    }
                    if (slimefunItem != null) {
                        outputItems.add(AbstractQuarryOutputItem.builder().itemStack(slimefunItem.getItem().clone()).chance(Supreme.getSupremeOptions().isLimitProductionQuarry() ? chance / 2 : chance).build());
                    }
                } else {
                    Material material = Material.matchMaterial((String)itemId);
                    if (material != null) {
                        outputItems.add(AbstractQuarryOutputItem.builder().itemStack(new ItemStack(material, 1)).chance(Supreme.getSupremeOptions().isLimitProductionQuarry() ? chance / 2 : chance).build());
                    }
                }
                checkLimitChance += chance;
            }
        } else {
            Supreme.inst().log(Level.SEVERE, "Config section for " + itemPath + " missing, Check your config and report this!");
        }
        return SupremeQuarryOutput.builder().outputItems(outputItems).build();
    }

    public static void addLoreQuarry(@Nonnull AbstractQuarry quarry) {
        ItemStack item = quarry.getItem();
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(" ");
        Optional<Object> lastElementLore = Optional.empty();
        if (meta.hasLore()) {
            lastElementLore = Optional.of(meta.getLore());
        }
        SupremeQuarryOutput output = quarry.getOutput();
        List outputItems = output.getOutputItems().stream().filter(Objects::nonNull).collect(Collectors.toList());
        for (AbstractQuarryOutputItem outputItem : outputItems) {
            if (outputItem == null || outputItem.getItemStack() == null || outputItem.getItemStack().getItemMeta() == null) continue;
            String name = outputItem.getItemStack().getType().name();
            if (outputItem.getItemStack().getItemMeta().hasDisplayName()) {
                name = outputItem.getItemStack().getItemMeta().getDisplayName();
            } else {
                name = name.replace("_", " ");
                name = name.substring(0, 1).toUpperCase().concat(name.substring(1).toLowerCase());
                name = ChatColor.AQUA + name;
            }
            lore.add(name + " " + ChatColor.YELLOW + outputItem.getChance() + "%");
        }
        if (Supreme.getSupremeOptions().isLimitProductionQuarry()) {
            lore.add(" ");
            lore.add(ChatColor.GOLD + "Limit Production Quarry");
        }
        lastElementLore.ifPresent(lore::addAll);
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public static ItemStack getItemQuarry(SupremeQuarryOutput output, int randomInt) {
        AtomicInteger startValue = new AtomicInteger(0);
        AtomicInteger nextValue = new AtomicInteger(0);
        ItemStack item = null;
        List outputItems = output.getOutputItems().stream().filter(Objects::nonNull).collect(Collectors.toList());
        for (AbstractQuarryOutputItem outputItem : outputItems) {
            nextValue.set(startValue.get() + outputItem.getChance());
            if (startValue.get() <= randomInt && nextValue.get() >= randomInt) {
                item = outputItem.getItemStack();
                break;
            }
            startValue.set(nextValue.get());
        }
        return item;
    }

    public static String buildNameTier(String newName, Integer tier) {
        switch (tier) {
            case 1: {
                return ChatColor.GRAY + newName + " I";
            }
            case 2: {
                return ChatColor.DARK_GREEN + newName + " II";
            }
            case 3: {
                return ChatColor.GREEN + newName + " III";
            }
            case 4: {
                return ChatColor.DARK_BLUE + newName + " IV";
            }
            case 5: {
                return ChatColor.BLUE + newName + " V";
            }
            case 6: {
                return ChatColor.GOLD + newName + " VI";
            }
            case 7: {
                return ChatColor.YELLOW + newName + " VII";
            }
            case 8: {
                return ChatColor.DARK_RED + newName + " VIII";
            }
            case 9: {
                return ChatColor.DARK_PURPLE + newName + " IX";
            }
        }
        return ChatColor.DARK_GRAY + newName;
    }

    public static String buildIdTier(String newName, Integer tier) {
        switch (tier) {
            case 1: {
                return newName + "_I";
            }
            case 2: {
                return newName + "_II";
            }
            case 3: {
                return newName + "_III";
            }
            case 4: {
                return newName + "_IV";
            }
            case 5: {
                return newName + "_V";
            }
            case 6: {
                return newName + "_VI";
            }
            case 7: {
                return newName + "_VII";
            }
            case 8: {
                return newName + "_VIII";
            }
            case 9: {
                return newName + "_IX";
            }
        }
        return newName + "_0";
    }

    public static String buildLoreRadioactivityType(MobTechGeneric.MobTechType mobTechType) {
        Radioactivity radioactivity;
        switch (mobTechType) {
            case MUTATION_INTELLIGENCE: 
            case MUTATION_BERSERK: 
            case MUTATION_LUCK: {
                radioactivity = Radioactivity.VERY_DEADLY;
                break;
            }
            case ROBOTIC_CLONING: 
            case ROBOTIC_ACCELERATION: 
            case ROBOTIC_EFFICIENCY: {
                radioactivity = Radioactivity.HIGH;
                break;
            }
            default: {
                radioactivity = Radioactivity.LOW;
            }
        }
        return radioactivity.getLore();
    }

    public static String buildLoreType(MobTechGeneric.MobTechType mobTechType, Integer tier) {
        String tierString = String.valueOf(tier + 1);
        switch (mobTechType) {
            case MUTATION_BERSERK: 
            case ROBOTIC_ACCELERATION: {
                return ChatColor.GREEN + tierString + "x " + ChatColor.GRAY + "increase speed " + ChatColor.RED + tierString + "0%" + ChatColor.GRAY + " increase energy";
            }
            case MUTATION_LUCK: 
            case ROBOTIC_CLONING: {
                return ItemUtil.buildLoreTypeLuckAndCloning(tier);
            }
            case MUTATION_INTELLIGENCE: 
            case ROBOTIC_EFFICIENCY: {
                return ChatColor.GREEN + tierString + "0% " + ChatColor.GRAY + " decrease energy";
            }
        }
        return ChatColor.GRAY + "Increases processing speed";
    }

    private static String buildLoreTypeLuckAndCloning(Integer tier) {
        if (tier >= 9) {
            return ChatColor.GREEN + "+4 stack" + ChatColor.GRAY + " clone";
        }
        if (tier >= 6) {
            return ChatColor.GREEN + "+3 stack" + ChatColor.GRAY + " clone";
        }
        if (tier >= 4) {
            return ChatColor.GREEN + "+2 stack" + ChatColor.GRAY + " clone";
        }
        return ChatColor.GREEN + "+1 stack" + ChatColor.GRAY + " clone";
    }

    private static String buildLoreTypeAmount(MobTechGeneric.MobTechType mobTechType, Integer tier) {
        String tierString = String.valueOf(tier + 1);
        switch (mobTechType) {
            case MUTATION_INTELLIGENCE: 
            case MUTATION_BERSERK: 
            case ROBOTIC_ACCELERATION: 
            case ROBOTIC_EFFICIENCY: {
                return ChatColor.GRAY + "Value process " + ChatColor.YELLOW + "(" + tierString + " * amount stack * 0.15625)";
            }
            case MUTATION_LUCK: 
            case ROBOTIC_CLONING: {
                return ChatColor.GRAY + "Value process " + ChatColor.YELLOW + "(" + Supreme.getSupremeOptions().getMaxAmountTechGenerator() + "x per stack)";
            }
        }
        return ChatColor.GRAY + "Value process " + ChatColor.YELLOW + "(amount stack * 0.15625)";
    }

    public static SlimefunItemStack buildItemFromMobTechDTO(MobTechGeneric mobTechGeneric, Integer tier) {
        SlimefunItemStack itemStack = new SlimefunItemStack(ItemUtil.buildIdTier(mobTechGeneric.getId(), tier), mobTechGeneric.getTexture(), ItemUtil.buildNameTier(mobTechGeneric.getName(), tier), new String[]{"", ItemUtil.buildLoreRadioactivityType(mobTechGeneric.getMobTechType()), ItemUtil.buildLoreType(mobTechGeneric.getMobTechType(), tier), ItemUtil.buildLoreTypeAmount(mobTechGeneric.getMobTechType(), tier), "", "&3Supreme Component"});
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataAPI.setInt((PersistentDataHolder)itemMeta, (NamespacedKey)new NamespacedKey((Plugin)Supreme.inst(), "mob_tech_tier"), (int)tier);
        PersistentDataAPI.setString((PersistentDataHolder)itemMeta, (NamespacedKey)new NamespacedKey((Plugin)Supreme.inst(), "mob_tech_type"), (String)mobTechGeneric.getMobTechType().name());
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

