/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import java.util.Random;
import java.util.Set;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.spirits.Goal;
import me.justahuman.spiritsunchained.spirits.SpiritDefinition;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.ParticleUtils;
import me.justahuman.spiritsunchained.utils.PlayerUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class PassOnListeners
implements Listener {
    @EventHandler
    public void onItemClick(InventoryClickEvent clickEvent) {
        Player player;
        ItemStack clicking;
        ItemStack clickingWith;
        block7: {
            block6: {
                clickingWith = clickEvent.getCursor();
                clicking = clickEvent.getCurrentItem();
                HumanEntity humanEntity = clickEvent.getWhoClicked();
                if (!(humanEntity instanceof Player)) break block6;
                player = (Player)humanEntity;
                if ((clickEvent.getClick().isLeftClick() || clickEvent.getClick().isRightClick()) && clickingWith != null && SpiritUtils.isSpiritItem(clicking) && !SpiritUtils.isLocked(clicking)) break block7;
            }
            return;
        }
        ItemMeta clickingMeta = clicking.getItemMeta();
        SpiritDefinition definition = SpiritUtils.getSpiritDefinition(clicking);
        Goal goal = definition.getGoal();
        ItemStack requirementStack = goal.getRequiredStack();
        String goalType = goal.getGoalType();
        int amount = goal.getAmount() - PersistentDataAPI.getInt((PersistentDataHolder)clickingMeta, (NamespacedKey)Keys.spiritPassOnKey);
        SlimefunItem clickingWithSF = SlimefunItem.getByItem((ItemStack)clickingWith);
        SlimefunItem requirementStackSF = SlimefunItem.getByItem((ItemStack)requirementStack);
        if (goalType.equals("Item") && clickingWithSF == null && clickingWith.getType() == requirementStack.getType() || goalType.equals("SlimefunItem") && clickingWithSF != null && clickingWithSF == requirementStackSF) {
            int clickingWithAmount = clickingWith.getAmount();
            clickingWith.setAmount(clickingWithAmount - amount);
            clickEvent.setCancelled(true);
            if (amount > clickingWithAmount) {
                PersistentDataAPI.setInt((PersistentDataHolder)clickingMeta, (NamespacedKey)Keys.spiritPassOnKey, (int)(clickingWithAmount + PersistentDataAPI.getInt((PersistentDataHolder)clickingMeta, (NamespacedKey)Keys.spiritPassOnKey)));
                clicking.setItemMeta(clickingMeta);
                SpiritUtils.updateSpiritItemProgress(clicking, 0.0);
            } else {
                clicking.subtract();
                clickEvent.getInventory().close();
                this.passOn(player, definition);
            }
        }
    }

    @EventHandler
    public void onBreedEntity(EntityBreedEvent event) {
        Player player;
        LivingEntity bredEntity;
        block3: {
            block2: {
                bredEntity = event.getEntity();
                LivingEntity livingEntity = event.getBreeder();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (SpiritsUnchained.getSpiritsManager().getGoalRequirements().containsKey(bredEntity.getType())) break block3;
            }
            return;
        }
        this.onSpecialInteract(player, bredEntity, "Breed");
    }

    @EventHandler
    public void onEntityKill(EntityDeathEvent event) {
        LivingEntity killedEntity = event.getEntity();
        Player player = killedEntity.getKiller();
        if (player == null || !SpiritsUnchained.getSpiritsManager().getGoalRequirements().containsKey(killedEntity.getType())) {
            return;
        }
        this.onSpecialInteract(player, killedEntity, "Kill");
    }

    private void onSpecialInteract(Player player, LivingEntity entity, String type) {
        for (EntityType goalFor : SpiritsUnchained.getSpiritsManager().getGoalRequirements().get(entity.getType())) {
            Set<ItemStack> spiritItems = SpiritUtils.getSpiritItems(player, goalFor);
            for (ItemStack spiritItem : spiritItems) {
                int currentAmount;
                if (spiritItem == null || SpiritUtils.isLocked(spiritItem)) continue;
                SpiritDefinition definition = SpiritUtils.getSpiritDefinition(spiritItem);
                if (!definition.getGoal().getGoalType().equals(type)) {
                    return;
                }
                ItemMeta meta = spiritItem.getItemMeta();
                int amount = definition.getGoal().getAmount();
                if (amount > (currentAmount = PersistentDataAPI.getInt((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritPassOnKey) + 1)) {
                    PersistentDataAPI.setInt((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritPassOnKey, (int)currentAmount);
                    spiritItem.setItemMeta(meta);
                    SpiritUtils.updateSpiritItemProgress(spiritItem, 0.0);
                } else {
                    spiritItem.subtract();
                    this.passOn(player, definition);
                }
                return;
            }
        }
    }

    private void passOn(Player player, SpiritDefinition definition) {
        int tier = definition.getTier();
        EntityType type = definition.getType();
        FileConfiguration rewards = SpiritsUnchained.getConfigManager().getRewards();
        String overridePath = "overrides." + type.name();
        String tierPath = "tiered." + tier;
        boolean override = rewards.contains(overridePath);
        List drops = override ? rewards.getStringList(overridePath + ".rewards") : rewards.getStringList(tierPath + ".rewards");
        String drop = (String)drops.get(new Random().nextInt(drops.size()));
        SlimefunItem sfDrop = SlimefunItem.getById((String)drop);
        int min = override ? rewards.getInt(overridePath + ".min") : rewards.getInt(tierPath + ".min");
        int max = override ? rewards.getInt(overridePath + ".max") : rewards.getInt(tierPath + ".max");
        ItemStack toDrop = sfDrop == null ? new ItemStack(Material.valueOf((String)drop)) : sfDrop.getItem().clone();
        toDrop.setAmount(new Random().nextInt(min, max + 1));
        PlayerUtils.addOrDropItem(player, toDrop);
        ParticleUtils.passOnAnimation(player.getLocation());
        player.sendMessage(ChatUtils.humanize((String)type.name()) + " Spirit has Passed on!");
    }
}

