/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.utils;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.ParticleUtils;
import me.justahuman.spiritsunchained.utils.PlayerUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Rotation;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class SpiritTraits {
    static final Map<UUID, Map<String, Long>> Cooldown_Map = new HashMap<UUID, Map<String, Long>>();

    public static String useTrait(Player player, Map<String, Object> traitInfo, ItemStack item) {
        Method traitMethod;
        UUID uuid = player.getUniqueId();
        String type = PersistentDataAPI.getString((PersistentDataHolder)item.getItemMeta(), (NamespacedKey)Keys.spiritItemKey);
        String name = (String)traitInfo.get("name");
        String id = (String)traitInfo.get("id");
        if (!(Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, player.getLocation(), Interaction.INTERACT_BLOCK) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, player.getLocation(), Interaction.PLACE_BLOCK) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, player.getLocation(), Interaction.BREAK_BLOCK) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, player.getLocation(), Interaction.ATTACK_ENTITY) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, player.getLocation(), Interaction.ATTACK_PLAYER) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, player.getLocation(), Interaction.INTERACT_ENTITY))) {
            return "&cYou do not have the required permissions in this area!";
        }
        if (traitInfo.get("type").equals("Passive")) {
            return name + " is a Passive Trait!";
        }
        try {
            traitMethod = SpiritTraits.class.getMethod((String)traitInfo.get("id"), Player.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return name + "'s Trait encountered an Error! Please open a bug report on github!";
        }
        if (Cooldown_Map.containsKey(uuid) && Cooldown_Map.get(uuid).containsKey(id) && Cooldown_Map.get(uuid).get(id) > System.currentTimeMillis()) {
            long cooldown = (Cooldown_Map.get(uuid).get(id) - System.currentTimeMillis()) / 1000L;
            return name + " on Cooldown! (" + cooldown + "s)";
        }
        if (!SpiritUtils.useSpiritItem(player, EntityType.valueOf((String)type), item)) {
            return null;
        }
        try {
            traitMethod.invoke(SpiritTraits.class, player);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return name + "'s Trait encountered an Error! Please open a bug report on github!";
        }
        Map<Object, Object> cooldownMap = Cooldown_Map.containsKey(uuid) ? Cooldown_Map.get(uuid) : new HashMap();
        cooldownMap.put((String)traitInfo.get("id"), System.currentTimeMillis() + (long)((Integer)traitInfo.get("cooldown") * 1000));
        Cooldown_Map.put(uuid, cooldownMap);
        return name + " Used!";
    }

    public static void resetCooldown(Player player) {
        Cooldown_Map.put(player.getUniqueId(), new HashMap());
    }

    public static void Clear_Effects(Player player) {
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_GENERIC_DRINK, 2.0f, 1.0f);
        for (PotionEffect potionEffect : player.getActivePotionEffects()) {
            player.removePotionEffect(potionEffect.getType());
        }
    }

    public static void Eggpult(Player player) {
        SpiritUtils.spawnProjectile(player, Egg.class, "Eggpult");
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_CHICKEN_AMBIENT, 2.0f, 1.0f);
    }

    public static void Aquatic_Creature(Player player) {
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ZOMBIE_CONVERTED_TO_DROWNED, 2.0f, 1.0f);
        player.addPotionEffect(new PotionEffect(PotionEffectType.CONDUIT_POWER, 1200, 0, true));
    }

    public static void Ink_Spray(Player player) {
        Location location = player.getLocation();
        ParticleUtils.spawnParticleRadius(location, Particle.SQUID_INK, 2.0, 20, "", new Object[0]);
        for (Player nearbyPlayer : player.getWorld().getNearbyPlayers(location, 5.0, 5.0, 5.0)) {
            if (nearbyPlayer.getUniqueId() == player.getUniqueId()) continue;
            nearbyPlayer.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 200, 0, true));
        }
        player.getWorld().playSound(location, Sound.ENTITY_SQUID_SQUIRT, 2.0f, 1.0f);
    }

    public static void Hops(Player player) {
        Location location = player.getLocation();
        player.getWorld().playSound(location, Sound.ENTITY_RABBIT_JUMP, 3.0f, 1.0f);
        ParticleUtils.spawnParticleRadius(location.add(0.0, 0.5, 0.0), Particle.COMPOSTER, 3.0, 20, "", new Object[0]);
        player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 600, 1, true));
    }

    public static void Bee_Buddy(Player player) {
        World world = player.getWorld();
        Location location = player.getLocation();
        ItemStack item = Math.random() <= 0.5 ? new ItemStack(Material.HONEYCOMB) : new ItemStack(Material.HONEY_BOTTLE);
        ParticleUtils.spawnParticleRadius(location.add(0.0, 0.5, 0.0), Particle.DRIPPING_HONEY, 3.0, 20, "", new Object[0]);
        item.setAmount(new Random().nextInt(1, 6));
        world.playSound(location, Sound.BLOCK_BEEHIVE_SHEAR, 2.0f, 1.0f);
        PlayerUtils.addOrDropItem(player, item);
    }

    public static void Webber(Player player) {
        Location location = player.getLocation();
        int count = 0;
        for (Player nearbyPlayer : player.getWorld().getNearbyPlayers(location, 5.0, 5.0, 5.0)) {
            Block block;
            if (nearbyPlayer.getUniqueId() == player.getUniqueId() || !(block = nearbyPlayer.getWorld().getBlockAt(nearbyPlayer.getLocation())).getType().isAir() && block.getType().isSolid()) continue;
            if (count >= 3) break;
            Material restoreType = block.getType();
            BlockData restoreData = block.getBlockData();
            block.setType(Material.COBWEB);
            Bukkit.getScheduler().runTaskLater((Plugin)SpiritsUnchained.getInstance(), () -> {
                block.setType(restoreType);
                block.setBlockData(restoreData);
            }, 100L);
            ++count;
        }
    }

    public static void Explode(Player player) {
        Location location = player.getLocation();
        TNTPrimed tnt = (TNTPrimed)player.getWorld().spawnEntity(location, EntityType.PRIMED_TNT);
        tnt.setFuseTicks(1);
        PersistentDataAPI.setString((PersistentDataHolder)tnt, (NamespacedKey)Keys.immuneKey, (String)player.getUniqueId().toString());
        PersistentDataAPI.setString((PersistentDataHolder)tnt, (NamespacedKey)Keys.entityKey, (String)"DullExplosion");
    }

    public static void Infest(Player player) {
        Block lookingAt = player.getTargetBlock(null, 5);
        try {
            Material newMaterial = Material.valueOf((String)("INFESTED_" + lookingAt.getType()));
            lookingAt.setType(newMaterial);
            ParticleUtils.spawnParticleRadius(lookingAt.getLocation(), Particle.ASH, 1.5, 40, "", new Object[0]);
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_SILVERFISH_AMBIENT, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_SILVERFISH_DEATH, 1.0f, 1.0f);
        }
    }

    public static void Echolocation(Player player) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 20, 0, true));
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_BAT_AMBIENT, 1.0f, 1.0f);
        for (LivingEntity entity : player.getWorld().getNearbyLivingEntities(player.getLocation(), 100.0, 100.0, 100.0)) {
            if (entity.getUniqueId() == player.getUniqueId()) continue;
            entity.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 640, 0, true));
        }
    }

    public static void Stew_Maker(Player player) {
        SpiritTraits.fillItems(player, Material.BOWL, new ItemStack(Material.MUSHROOM_STEW), 4);
    }

    public static void Lava_Walker(Player player) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 1200, 0, true));
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_STRIDER_HAPPY, 1.0f, 1.0f);
    }

    public static void Villager_Friend(Player player) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE, 1200, 4, true));
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
    }

    public static void Glow_Up(Player player) {
        Location location = player.getLocation();
        World world = player.getWorld();
        Block block = world.getBlockAt(location);
        for (Block relative : SpiritUtils.getNearbyBlocks(block, 5)) {
            if (!relative.getType().toString().contains("SIGN")) continue;
            Sign sign = (Sign)relative.getState();
            sign.setGlowingText(true);
            sign.update();
            ParticleUtils.spawnParticleRadius(relative.getLocation(), Particle.GLOW_SQUID_INK, 1.5, 24, "", new Object[0]);
            world.playSound(relative.getLocation(), Sound.ENTITY_GLOW_SQUID_SQUIRT, 1.0f, 1.0f);
        }
        for (ItemFrame itemFrame : world.getNearbyEntitiesByType(ItemFrame.class, location, 5.0)) {
            ItemStack item = itemFrame.getItem();
            Rotation rotation = itemFrame.getRotation();
            BlockFace face = itemFrame.getAttachedFace();
            Location frameLocation = itemFrame.getLocation();
            itemFrame.remove();
            GlowItemFrame frame = (GlowItemFrame)world.spawn(frameLocation, GlowItemFrame.class);
            frame.setFacingDirection(face.getOppositeFace());
            frame.setItem(item);
            frame.setRotation(rotation);
            ParticleUtils.spawnParticleRadius(itemFrame.getLocation(), Particle.GLOW_SQUID_INK, 1.5, 24, "", new Object[0]);
            world.playSound(itemFrame.getLocation(), Sound.ENTITY_GLOW_SQUID_SQUIRT, 1.0f, 1.0f);
        }
    }

    public static void Light_It_Up(Player player) {
        Location location = player.getLocation();
        World world = player.getWorld();
        Block block = world.getBlockAt(location);
        for (Block relative : SpiritUtils.getNearbyBlocks(block, 5)) {
            if (relative.getType() != Material.MAGMA_BLOCK) continue;
            Material[] chooseFrom = new Material[]{Material.OCHRE_FROGLIGHT, Material.VERDANT_FROGLIGHT, Material.PEARLESCENT_FROGLIGHT};
            Material newMaterial = chooseFrom[new Random().nextInt(3)];
            relative.setType(newMaterial);
            ParticleUtils.spawnParticleRadius(relative.getLocation(), Particle.END_ROD, 1.5, 24, "Freeze", new Object[0]);
        }
        player.playSound(location, Sound.ENTITY_FROG_AMBIENT, 1.0f, 1.0f);
    }

    public static void High_Jump(Player player) {
        player.setVelocity(new Vector(0.0, 1.5, 0.0));
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_HORSE_JUMP, 2.0f, 1.0f);
    }

    public static void Spitter(Player player) {
        Projectile spit = (Projectile)SpiritUtils.spawnProjectile(player, LlamaSpit.class, "Spitter");
        spit.setShooter((ProjectileSource)player);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_LLAMA_SPIT, 2.0f, 1.0f);
    }

    public static void Goats_Instrument(Player player) {
        Sound[] playFrom = new Sound[]{Sound.ITEM_GOAT_HORN_SOUND_0, Sound.ITEM_GOAT_HORN_SOUND_1, Sound.ITEM_GOAT_HORN_SOUND_2, Sound.ITEM_GOAT_HORN_SOUND_3, Sound.ITEM_GOAT_HORN_SOUND_4, Sound.ITEM_GOAT_HORN_SOUND_5, Sound.ITEM_GOAT_HORN_SOUND_6, Sound.ITEM_GOAT_HORN_SOUND_7};
        player.getWorld().playSound(player.getLocation(), playFrom[new Random().nextInt(0, 8)], 2.0f, 1.0f);
    }

    public static void Poison_Spray(Player player) {
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_LLAMA_SPIT, 2.0f, 1.0f);
        ParticleUtils.spawnParticleRadius(player.getLocation(), Particle.SCULK_CHARGE_POP, 5.0, 100, "Freeze", new Object[0]);
        for (Player nearbyPlayer : player.getWorld().getNearbyPlayers(player.getLocation(), 5.0)) {
            if (nearbyPlayer.getUniqueId() == player.getUniqueId()) continue;
            nearbyPlayer.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 200, 0));
        }
    }

    public static void Crit_hit(Player player) {
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_VINDICATOR_AMBIENT, 2.0f, 1.0f);
        player.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 600, 1, true));
    }

    public static void Mini_Teleport(Player player) {
        if (player.getVehicle() != null) {
            player.leaveVehicle();
        }
        Location location = player.getLocation().clone();
        ParticleUtils.spawnParticleRadius(location, Particle.PORTAL, 1.5, 30, "", new Object[0]);
        for (int i = 0; i < 16; ++i) {
            int x = location.clone().getBlockX() + new Random().nextInt(1, 33);
            int y = location.clone().getBlockY() + new Random().nextInt(1, 33);
            int z = location.clone().getBlockZ() + new Random().nextInt(1, 33);
            Location teleportTo = new Location(location.getWorld(), (double)x, (double)y, (double)z);
            if (!player.teleport(teleportTo, PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT)) continue;
            ParticleUtils.spawnParticleRadius(teleportTo, Particle.PORTAL, 1.5, 30, "", new Object[0]);
            break;
        }
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_CHORUS_FRUIT_TELEPORT, 2.0f, 1.0f);
    }

    public static void Sleep_No_More(Player player) {
        player.setStatistic(Statistic.TIME_SINCE_REST, 0);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_PHANTOM_AMBIENT, 2.0f, 1.0f);
    }

    public static void Magma_Trap(Player player) {
        for (Player nearbyPlayer : player.getWorld().getNearbyPlayers(player.getLocation(), 5.0)) {
            if (nearbyPlayer.getUniqueId() == player.getUniqueId()) continue;
            nearbyPlayer.setFireTicks(200);
        }
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_MAGMA_CUBE_SQUISH, 2.0f, 1.0f);
    }

    public static void Better_Brewer(Player player) {
        PlayerInventory inventory = player.getInventory();
        if (inventory.contains(Material.GLASS_BOTTLE)) {
            ItemStack potion1 = new ItemStack(Material.SPLASH_POTION);
            PotionMeta meta1 = (PotionMeta)potion1.getItemMeta();
            meta1.setBasePotionData(new PotionData(PotionType.REGEN, false, true));
            potion1.setItemMeta((ItemMeta)meta1);
            ItemStack potion2 = new ItemStack(Material.SPLASH_POTION);
            PotionMeta meta2 = (PotionMeta)potion2.getItemMeta();
            meta2.setBasePotionData(new PotionData(PotionType.STRENGTH, false, true));
            potion2.setItemMeta((ItemMeta)meta2);
            ItemStack potion3 = new ItemStack(Material.SPLASH_POTION);
            PotionMeta meta3 = (PotionMeta)potion3.getItemMeta();
            meta3.setBasePotionData(new PotionData(PotionType.INSTANT_HEAL, false, true));
            potion3.setItemMeta((ItemMeta)meta3);
            ItemStack[] potions = new ItemStack[]{potion1, potion2, potion3};
            int amount = new Random().nextInt(5);
            for (int current = 0; current < amount; ++current) {
                SpiritTraits.fillItems(player, Material.GLASS_BOTTLE, potions[new Random().nextInt(3)], 1);
            }
        }
    }

    public static void Heavy_Hit(Player player) {
        PersistentDataAPI.setBoolean((PersistentDataHolder)player, (NamespacedKey)Keys.heavyHitKey, (boolean)true);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_HOGLIN_ATTACK, 2.0f, 1.0f);
    }

    public static void Targeted_Teleport(Player player) {
        RayTraceResult rs = player.getWorld().rayTraceBlocks(player.getEyeLocation(), player.getEyeLocation().getDirection(), 64.0);
        if (rs == null) {
            return;
        }
        Location location = player.getLocation();
        float yaw = location.getYaw();
        float pitch = location.getPitch();
        double D = 1.0;
        double x = -1.0 * Math.sin((double)yaw * Math.PI / 180.0);
        double z = 1.0 * Math.cos((double)yaw * Math.PI / 180.0);
        Location targetLoc = rs.getHitBlock().getLocation().subtract(x, -1.0, z);
        targetLoc.setYaw(yaw);
        targetLoc.setPitch(pitch);
        ParticleUtils.spawnParticleRadius(location, Particle.PORTAL, 1.5, 30, "", new Object[0]);
        player.teleport(targetLoc);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 2.0f, 1.0f);
        ParticleUtils.spawnParticleRadius(targetLoc, Particle.PORTAL, 1.5, 30, "", new Object[0]);
    }

    public static void Tank(Player player) {
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_RAVAGER_ATTACK, 2.0f, 1.0f);
        player.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 300, 1, true));
        player.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 300, 2, true));
    }

    public static void Bullet_Swarm(Player player) {
        World world = player.getWorld();
        Location location = player.getLocation();
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        for (LivingEntity nearbyEntity : world.getNearbyLivingEntities(location, 20.0, 20.0, 20.0)) {
            if (nearbyEntity.getUniqueId() == player.getUniqueId() || nearbyEntity instanceof ArmorStand) continue;
            targets.add(nearbyEntity);
        }
        for (int spawned = 0; spawned < 5; ++spawned) {
            LivingEntity target = !targets.isEmpty() ? (LivingEntity)targets.get(new Random().nextInt(targets.size())) : null;
            int x = new Random().nextInt(0, 5) * (new Random().nextDouble() >= 0.5 ? -1 : 1);
            int z = new Random().nextInt(0, 5) * (new Random().nextDouble() >= 0.5 ? -1 : 1);
            ShulkerBullet bullet = (ShulkerBullet)world.spawnEntity(location.add((double)x, 2.0, (double)z), EntityType.SHULKER_BULLET);
            PersistentDataAPI.setString((PersistentDataHolder)bullet, (NamespacedKey)Keys.immuneKey, (String)player.getUniqueId().toString());
            bullet.setShooter((ProjectileSource)player);
            if (target == null) continue;
            bullet.setTarget((Entity)target);
            targets.remove(target);
        }
    }

    public static void Skull_Fire(Player player) {
        SpiritUtils.spawnProjectile(player, WitherSkull.class, "Skull_Fire");
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WITHER_SHOOT, 2.0f, 1.0f);
    }

    public static void Dragons_Breath(Player player) {
        SpiritTraits.fillItems(player, Material.GLASS_BOTTLE, new ItemStack(Material.DRAGON_BREATH), 8);
    }

    public static void Dark_Aura(Player player) {
        World world = player.getWorld();
        Location location = player.getLocation();
        for (Player nearbyPlayer : world.getNearbyPlayers(location, 30.0, 30.0, 30.0)) {
            if (nearbyPlayer.getUniqueId() == player.getUniqueId()) continue;
            Location nearbyLocation = nearbyPlayer.getLocation();
            nearbyPlayer.addPotionEffect(new PotionEffect(PotionEffectType.DARKNESS, 600, 0, true));
            nearbyPlayer.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 600, 3, true));
            world.playSound(nearbyLocation, Sound.ENTITY_WARDEN_HEARTBEAT, 3.0f, 1.0f);
            ParticleUtils.spawnParticleRadius(nearbyLocation, Particle.SCULK_SOUL, 2.0, 30, "", new Object[0]);
        }
        world.playSound(location, Sound.ENTITY_WARDEN_ROAR, 1.0f, 1.0f);
    }

    public static void fillItems(Player player, Material fill, ItemStack fillWith, int howMany) {
        PlayerInventory inventory = player.getInventory();
        if (inventory.contains(fill)) {
            int fillAmount = 0;
            for (ItemStack item : inventory.getContents()) {
                if (item == null || item.getType() != fill) continue;
                fillAmount = item.getAmount() >= howMany ? new Random().nextInt(1, howMany + 1) : new Random().nextInt(0, item.getAmount());
                item.setAmount(item.getAmount() - fillAmount);
            }
            fillWith.setAmount(fillAmount);
            PlayerUtils.addOrDropItem(player, fillWith);
        }
    }
}

