/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.implementation.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.spirits.SpiritDefinition;
import me.justahuman.spiritsunchained.utils.ParticleUtils;
import me.justahuman.spiritsunchained.utils.PlayerUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ElectricSpiritWriter
extends SlimefunItem
implements EnergyNetComponent {
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 22, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int[] BORDER_INPUT = new int[]{9, 10, 11, 12, 18, 21, 27, 28, 29, 30};
    private static final int[] BORDER_OUTPUT = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};
    private static final int[] INPUT_SLOTS = new int[]{19, 20};
    private static final int[] OUTPUT_SLOTS = new int[]{24, 25};
    private static final int PROGRESS_SLOT = 22;
    private static final Map<BlockPosition, Integer> progress = new HashMap<BlockPosition, Integer>();
    private static final ItemStack PROGRESS_ITEM = new CustomItemStack(Material.BOOK, "&7Progress: 0%", new String[0]);

    @ParametersAreNonnullByDefault
    public ElectricSpiritWriter(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.buildPreset();
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
    }

    private void buildPreset() {
        new BlockMenuPreset(this.getId(), ChatColor.GREEN + "Electric Spirit Writer"){

            public void init() {
                ChestMenuUtils.drawBackground((ChestMenu)this, (int[])BACKGROUND_SLOTS);
                SpiritUtils.fillSlots((ChestMenu)this, BORDER_INPUT, ChestMenuUtils.getInputSlotTexture());
                SpiritUtils.fillSlots((ChestMenu)this, BORDER_OUTPUT, ChestMenuUtils.getOutputSlotTexture());
                this.addItem(22, PROGRESS_ITEM);
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return flow == ItemTransportFlow.INSERT ? ElectricSpiritWriter.this.getInputSlots() : ElectricSpiritWriter.this.getOutputSlots();
            }
        };
    }

    private BlockBreakHandler onBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(@Nonnull Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), ElectricSpiritWriter.this.getInputSlots());
                    inv.dropItems(b.getLocation(), ElectricSpiritWriter.this.getOutputSlots());
                }
                progress.remove(new BlockPosition(b.getWorld(), b.getX(), b.getY(), b.getZ()));
            }
        };
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                ElectricSpiritWriter.this.tick(b);
            }

            public boolean isSynchronized() {
                return true;
            }
        }});
    }

    protected void tick(Block b) {
        if (this.getCharge(b.getLocation()) < ElectricSpiritWriter.getEnergyConsumption()) {
            return;
        }
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        BlockPosition pos = new BlockPosition(b.getWorld(), b.getX(), b.getY(), b.getZ());
        int currentProgress = progress.getOrDefault(pos, 0);
        ItemStack inputSlot1 = inv.getItemInSlot(19);
        ItemStack inputSlot2 = inv.getItemInSlot(20);
        if (inputSlot1 == null || inputSlot2 == null) {
            return;
        }
        if (!(SpiritUtils.isSpiritItem(inputSlot1) && SlimefunItem.getByItem((ItemStack)inputSlot2) != null && SlimefunItem.getByItem((ItemStack)inputSlot2).getId().equals("SU_SPIRIT_BOOK") || SpiritUtils.isSpiritItem(inputSlot2) && SlimefunItem.getByItem((ItemStack)inputSlot1) != null && SlimefunItem.getByItem((ItemStack)inputSlot1).getId().equals("SU_SPIRIT_BOOK"))) {
            return;
        }
        if (inv.getItemInSlot(24) != null || inv.getItemInSlot(25) != null) {
            return;
        }
        ItemStack spiritItem = SpiritUtils.isSpiritItem(inputSlot1) ? inputSlot1 : inputSlot2;
        ItemStack bookItem = SpiritUtils.isSpiritItem(inputSlot1) ? inputSlot2 : inputSlot1;
        SpiritDefinition definition = SpiritUtils.getSpiritDefinition(spiritItem);
        EntityType type = definition.getType();
        int maxTime = 3 * definition.getTier();
        ParticleUtils.spawnParticleRadius(b.getLocation(), Particle.ENCHANTMENT_TABLE, 1.5, 10, "", new Object[0]);
        if (currentProgress < maxTime) {
            progress.put(pos, ++currentProgress);
            ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)22, (int)(maxTime - currentProgress), (int)maxTime, (ItemStack)PROGRESS_ITEM);
            this.removeCharge(b.getLocation(), ElectricSpiritWriter.getEnergyConsumption());
            return;
        }
        inv.pushItem(spiritItem.clone(), this.getOutputSlots());
        inv.pushItem(SpiritUtils.getFilledBook(definition), this.getOutputSlots());
        spiritItem.subtract();
        bookItem.subtract();
        for (Player player : b.getLocation().getNearbyPlayers(10.0)) {
            PlayerUtils.learnKnowledgePiece(player, type, 2);
        }
        progress.put(pos, 0);
        ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)22, (int)1, (int)1, (ItemStack)PROGRESS_ITEM);
        b.getWorld().playSound(b.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 1000;
    }

    public static int getEnergyConsumption() {
        return 125;
    }

    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }
}

