/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.GitHubBuildsUpdater;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.Setup;
import me.justahuman.spiritsunchained.managers.CommandManager;
import me.justahuman.spiritsunchained.managers.ConfigManager;
import me.justahuman.spiritsunchained.managers.ListenerManager;
import me.justahuman.spiritsunchained.managers.RunnableManager;
import me.justahuman.spiritsunchained.managers.SpiritEntityManager;
import me.justahuman.spiritsunchained.managers.SpiritsManager;
import me.justahuman.spiritsunchained.slimefun.ItemStacks;
import me.justahuman.spiritsunchained.slimefun.Researches;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.LogUtils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.FallingBlock;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpiritsUnchained
extends JavaPlugin
implements SlimefunAddon {
    private static SpiritsUnchained instance;
    private static ListenerManager listenerManager;
    private static SpiritsManager spiritsManager;
    private static SpiritEntityManager spiritEntityManager;
    private static ConfigManager configManager;
    private static RunnableManager runnableManager;

    public void onEnable() {
        instance = this;
        this.getLogger().info("========================================");
        this.getLogger().info("    SpiritsUnchained - By JustAHuman    ");
        this.getLogger().info("========================================");
        this.saveDefaultConfig();
        configManager = new ConfigManager();
        runnableManager = new RunnableManager();
        listenerManager = new ListenerManager();
        spiritsManager = new SpiritsManager();
        spiritEntityManager = new SpiritEntityManager();
        Setup.INSTANCE.init();
        if (this.getConfig().getBoolean("options.auto-update")) {
            GitHubBuildsUpdater updater = new GitHubBuildsUpdater((Plugin)this, this.getFile(), "JustAHuman-xD/SpiritsUnchained/master");
            updater.start();
        }
        if (this.getConfig().getBoolean("options.enable-researches")) {
            Researches.init();
        }
        this.getCommand("spirits").setExecutor((CommandExecutor)new CommandManager());
    }

    @Nonnull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    public String getBugTrackerURL() {
        return "https://github.com/JustAHuman-xD/SpiritsUnchained/issues";
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static SlimefunItemStack getSlimefunItem(String id) {
        try {
            return (SlimefunItemStack)((SlimefunItem)Slimefun.getRegistry().getSlimefunItemIds().get(id)).getItem();
        }
        catch (ClassCastException | NullPointerException e) {
            e.printStackTrace();
            LogUtils.logInfo(id);
            return ItemStacks.SU_ECTOPLASM;
        }
    }

    public void onDisable() {
        configManager.save();
        for (World world : Bukkit.getWorlds()) {
            for (FallingBlock fallingBlock : world.getEntitiesByClass(FallingBlock.class)) {
                if (!PersistentDataAPI.hasString((PersistentDataHolder)fallingBlock, (NamespacedKey)Keys.entityKey)) continue;
                fallingBlock.remove();
            }
        }
    }

    public static SpiritsUnchained getInstance() {
        return instance;
    }

    public static ListenerManager getListenerManager() {
        return listenerManager;
    }

    public static SpiritsManager getSpiritsManager() {
        return spiritsManager;
    }

    public static SpiritEntityManager getSpiritEntityManager() {
        return spiritEntityManager;
    }

    public static ConfigManager getConfigManager() {
        return configManager;
    }

    public static RunnableManager getRunnableManager() {
        return runnableManager;
    }
}

