/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.managers;

import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.implementation.mobs.AbstractCustomMob;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class SpiritEntityManager
implements Listener {
    public final Map<String, AbstractCustomMob<?>> entityMap = new HashMap();
    public final Collection<LivingEntity> entityCollection = new ArrayList<LivingEntity>();

    public SpiritEntityManager() {
        SpiritsUnchained instance = SpiritsUnchained.getInstance();
        FileConfiguration config = instance.getConfig();
        int tickRate = Math.min(config.getInt("tick-rate", 2), 20);
        int spawnRate = config.getInt("spawn-rate", 10) * 20;
        instance.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)instance);
        Bukkit.getScheduler().runTaskTimer((Plugin)instance, this::tick, (long)tickRate, (long)Math.max(1, tickRate));
        Bukkit.getScheduler().runTaskTimer((Plugin)instance, this::spawnTick, 1L, (long)spawnRate);
    }

    public void register(AbstractCustomMob<?> customMob) {
        if (this.entityMap.containsKey(customMob.getId())) {
            throw new IllegalArgumentException("Custom Entity Already Registered!" + customMob.getId());
        }
        this.entityMap.put(customMob.getId(), customMob);
    }

    public AbstractCustomMob<?> getCustomClass(Entity entity, String key) {
        String getKey = entity != null && PersistentDataAPI.hasString((PersistentDataHolder)entity, (NamespacedKey)Keys.entityKey) ? PersistentDataAPI.getString((PersistentDataHolder)entity, (NamespacedKey)Keys.entityKey) : key;
        return getKey == null ? null : this.entityMap.get(getKey);
    }

    private void tick() {
        for (AbstractCustomMob<?> customMob : this.entityMap.values()) {
            customMob.onUniqueTick();
        }
        for (World world : Bukkit.getWorlds()) {
            for (LivingEntity entity : world.getLivingEntities()) {
                AbstractCustomMob<?> customMob = this.getCustomClass((Entity)entity, null);
                if (customMob == null) continue;
                customMob.onEntityTick(entity);
            }
        }
    }

    private void spawnTick() {
        for (World world : Bukkit.getWorlds()) {
            if (SpiritsUnchained.getInstance().getConfig().getStringList("disabled-worlds").contains(world.getName())) continue;
            for (Player player : world.getPlayers()) {
                Block b;
                String maybeSpirit;
                int spiritCount = SpiritUtils.getNearbySpirits(player.getLocation()).size();
                ItemStack helmetItem = player.getInventory().getHelmet();
                if (helmetItem == null || !SpiritUtils.imbuedCheck(helmetItem) || !SpiritUtils.canSpawn() || spiritCount >= SpiritUtils.getPlayerCap() || !SpiritUtils.chance(10) || (maybeSpirit = SpiritUtils.getSpawnMob((b = SpiritUtils.getSpawnBlock(player.getLocation())).getLocation())) == null || this.entityMap.get("UNIDENTIFIED_SPIRIT") == null) continue;
                this.entityMap.get("UNIDENTIFIED_SPIRIT").spawn(b.getLocation(), player.getWorld(), "Natural", maybeSpirit);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onEntityTarget(@Nonnull EntityTargetEvent e) {
        AbstractCustomMob<?> customMob = this.getCustomClass(e.getEntity(), null);
        if (customMob != null) {
            customMob.onTarget(e);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    private void onEntityInteract(@Nonnull PlayerInteractEntityEvent e) {
        AbstractCustomMob<?> customMob = this.getCustomClass(e.getRightClicked(), null);
        if (customMob != null) {
            customMob.onInteract(e);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onEntityHit(@Nonnull EntityDamageByEntityEvent e) {
        AbstractCustomMob<?> customMob = this.getCustomClass(e.getEntity(), null);
        if (customMob != null) {
            customMob.onHit(e);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onEntityDie(@Nonnull EntityDeathEvent e) {
        AbstractCustomMob<?> customMob = this.getCustomClass((Entity)e.getEntity(), null);
        if (customMob != null) {
            customMob.onDeath(e);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onEntityCombust(@Nonnull EntityCombustEvent e) {
        AbstractCustomMob<?> customMob = this.getCustomClass(e.getEntity(), null);
        if (customMob != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onEntityDamage(@Nonnull EntityDamageEvent e) {
        AbstractCustomMob<?> customMob = this.getCustomClass(e.getEntity(), null);
        if (customMob != null) {
            customMob.onDamage(e);
        }
    }
}

