/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.implementation.mobs;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.implementation.mobs.AbstractCustomMob;
import me.justahuman.spiritsunchained.slimefun.ItemStacks;
import me.justahuman.spiritsunchained.spirits.SpiritDefinition;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.ParticleUtils;
import me.justahuman.spiritsunchained.utils.PlayerUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Spirit
extends AbstractCustomMob<Allay> {
    private static final int particleCount = 4;
    private final SpiritDefinition definition;

    public Spirit(String id, String name, EntityType soulType) {
        super(Allay.class, id, name, 10.0);
        this.definition = SpiritsUnchained.getSpiritsManager().getSpiritMap().get(soulType);
    }

    @Override
    @Nonnull
    public final Allay spawn(@Nonnull Location loc, @Nonnull World world, String reason, String revealState) {
        double health = this.getMaxHealth() * (double)this.definition.getTier();
        String state = reason.equals("Natural") ? this.definition.getStates().get(new Random().nextInt(this.definition.getStates().size())) : (reason.equals("Reveal") ? revealState : reason);
        Allay mob = (Allay)world.spawn(loc, this.getClazz());
        SpiritsUnchained.getSpiritEntityManager().entityCollection.add((LivingEntity)mob);
        SpiritUtils.spiritIdMap.put(mob.getEntityId(), (Entity)mob);
        PersistentDataAPI.setString((PersistentDataHolder)mob, (NamespacedKey)Keys.entityKey, (String)this.getId());
        PersistentDataAPI.setString((PersistentDataHolder)mob, (NamespacedKey)Keys.spiritStateKey, (String)state);
        Objects.requireNonNull(mob.getAttribute(Attribute.GENERIC_MAX_HEALTH)).setBaseValue(health);
        mob.setHealth(health);
        mob.setRemoveWhenFarAway(true);
        mob.setCanPickupItems(false);
        this.onSpawn(mob);
        return mob;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onSpawn(Allay allay) {
        allay.setCollidable(false);
        allay.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 20000000, 1, true, false));
        allay.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 20000000, 1, true, false));
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onTick(Allay allay) {
        String state = PersistentDataAPI.getString((PersistentDataHolder)allay, (NamespacedKey)Keys.spiritStateKey);
        ParticleUtils.spawnParticleRadius(allay.getLocation(), Particle.SPELL_INSTANT, 0.1, 4, "Spirit", new Object[0]);
        SpiritUtils.spawnStateParticle(state, allay.getLocation());
        for (Player player : allay.getWorld().getPlayers()) {
            if (!player.canSee((Entity)allay)) continue;
            player.hideEntity((Plugin)SpiritsUnchained.getInstance(), (Entity)allay);
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onDeath(EntityDeathEvent event) {
        ItemStack toDrop = ItemStacks.SU_ECTOPLASM.clone();
        toDrop.setAmount(this.definition.getTier() + 1);
        event.getDrops().add(toDrop);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHit(EntityDamageByEntityEvent event) {
        event.setCancelled(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @ParametersAreNonnullByDefault
    public void onInteract(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        EquipmentSlot hand = event.getHand();
        Entity entity = event.getRightClicked();
        EntityType type = this.definition.getType();
        ItemStack item = player.getInventory().getItem(hand);
        int tier = this.definition.getTier();
        if (item.getType() == Material.AIR) {
            return;
        }
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)item);
        if (slimefunItem != null && slimefunItem.getId().equals(ItemStacks.SU_SPIRIT_NET.getItemId())) {
            if (new Random().nextInt(1, 100) <= SpiritUtils.getTierChance(tier)) {
                ParticleUtils.catchAnimation(entity.getLocation());
                entity.remove();
                PlayerUtils.addOrDropItem(player, SpiritUtils.spiritItem(PersistentDataAPI.getString((PersistentDataHolder)entity, (NamespacedKey)Keys.spiritStateKey), this.definition));
                PlayerUtils.learnKnowledgePiece(player, type, 1);
            } else {
                player.sendMessage("The Spirit Escaped the Net!");
            }
            item.subtract();
            return;
        }
        if (slimefunItem != null && slimefunItem.getId().equals(ItemStacks.SU_SPIRIT_BOOK.getItemId())) {
            if (new Random().nextInt(1, 100) <= SpiritUtils.getTierChance(tier)) {
                if (PlayerUtils.hasKnowledgePiece(player, type, 2)) {
                    player.sendMessage("You can't gain anymore knowledge from a Book!");
                    return;
                }
                PlayerUtils.addOrDropItem(player, SpiritUtils.getFilledBook(this.definition));
                PlayerUtils.learnKnowledgePiece(player, type, 2);
            } else {
                player.sendMessage("The Spirit rips the Book to Shreds!");
            }
            item.subtract();
            return;
        }
        if (item.getType() != Material.GLASS_BOTTLE) return;
        if (!item.getItemMeta().getPersistentDataContainer().isEmpty()) return;
        ParticleUtils.bottleAnimation(entity.getLocation());
        entity.remove();
        item.subtract();
        PlayerUtils.addOrDropItem(player, new ItemStack[]{ItemStacks.SU_SPIRIT_BOTTLE});
    }

    public static int getParticleCount() {
        return 4;
    }

    public SpiritDefinition getDefinition() {
        return this.definition;
    }
}

