/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.spirits;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Goal {
    private final ItemStack displayStack;
    private final String goalType;
    private final String requiredType;
    private final ItemStack requiredStack;
    private final int amount;

    public Goal(String goalType, String requiredType, int amount) {
        this.goalType = goalType;
        this.requiredType = requiredType;
        this.amount = amount;
        this.requiredStack = this.createRequirementStack();
        this.displayStack = this.createDisplayStack();
    }

    private ItemStack createDisplayStack() {
        String addition = this.amount > 1 ? "s" : "";
        String loreEnd = this.amount + " " + ChatUtils.humanize((String)this.requiredType);
        String name = "&bPass on Task:";
        CustomItemStack kill = new CustomItemStack(Material.DIAMOND_SWORD, "&bPass on Task:", new String[]{"", "&bType: &7Kill Mob" + addition, "&bTask: &7Kill " + loreEnd + addition});
        CustomItemStack item = new CustomItemStack(Material.STICK, "&bPass on Task:", new String[]{"", "&bType: &7Give Item" + addition, "&bTask: &7Give " + loreEnd});
        if (this.goalType.equals("Item")) {
            try {
                item.setType(Material.valueOf((String)this.requiredType));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        CustomItemStack slimefunItem = new CustomItemStack(Material.SLIME_BALL, "&bPass on Task:", new String[]{"", "&bType: &7Give Slimefun Item" + addition, "&bTask: &7Give " + loreEnd});
        if (this.goalType.equals("SlimefunItem")) {
            try {
                ItemStack properSlimefunItem = SpiritsUnchained.getSlimefunItem(this.requiredType).clone();
                List newLore = slimefunItem.lore();
                ItemMeta newMeta = properSlimefunItem.getItemMeta();
                newLore.set(2, Component.text((String)ChatColors.color((String)(ChatColor.AQUA + "Task: " + ChatColor.GRAY + "Give " + this.amount + " " + properSlimefunItem.getItemMeta().getDisplayName()))));
                newMeta.displayName((Component)Component.text((String)ChatColors.color((String)(ChatColor.AQUA + "Pass On Task:"))));
                properSlimefunItem.setItemMeta(newMeta);
                properSlimefunItem.lore(newLore);
                slimefunItem = properSlimefunItem;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        CustomItemStack breed = new CustomItemStack(Material.WHEAT, "&eBreed Mobs", new String[]{"", "&7Breed " + loreEnd + addition});
        return switch (this.goalType) {
            case "Item" -> item;
            case "SlimefunItem" -> slimefunItem;
            case "Breed" -> breed;
            default -> kill;
        };
    }

    private ItemStack createRequirementStack() {
        ItemStack toReturn = new ItemStack(Material.AIR);
        if (this.goalType.equals("Item")) {
            toReturn = new ItemStack(Material.valueOf((String)this.requiredType));
        } else if (this.goalType.equals("SlimefunItem")) {
            toReturn = SlimefunItem.getById((String)this.requiredType).getItem().clone();
        }
        return toReturn;
    }

    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    public String getGoalType() {
        return this.goalType;
    }

    public String getRequiredType() {
        return this.requiredType;
    }

    public ItemStack getRequiredStack() {
        return this.requiredStack;
    }

    public int getAmount() {
        return this.amount;
    }
}

