/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.implementation.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.implementation.mobs.AbstractCustomMob;
import me.justahuman.spiritsunchained.implementation.mobs.Spirit;
import me.justahuman.spiritsunchained.implementation.mobs.UnIdentifiedSpirit;
import me.justahuman.spiritsunchained.managers.SpiritEntityManager;
import me.justahuman.spiritsunchained.slimefun.ItemStacks;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.ParticleUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Vibration;
import org.bukkit.block.Block;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ElectricSpiritCatcher
extends SlimefunItem
implements EnergyNetComponent {
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 22, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int[] BORDER_INPUT = new int[]{9, 10, 11, 12, 18, 21, 27, 28, 29, 30};
    private static final int[] BORDER_OUTPUT = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};
    private static final int[] INPUT_SLOTS = new int[]{19, 20};
    private static final int[] OUTPUT_SLOTS = new int[]{24, 25};
    private final SpiritEntityManager spiritEntityManager = SpiritsUnchained.getSpiritEntityManager();
    private static final Map<BlockPosition, Boolean> catching = new HashMap<BlockPosition, Boolean>();

    @ParametersAreNonnullByDefault
    public ElectricSpiritCatcher(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.buildPreset();
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
    }

    private void buildPreset() {
        new BlockMenuPreset(this.getId(), ChatColor.GREEN + "Electric Spirit Catcher"){

            public void init() {
                ChestMenuUtils.drawBackground((ChestMenu)this, (int[])BACKGROUND_SLOTS);
                SpiritUtils.fillSlots((ChestMenu)this, BORDER_INPUT, ChestMenuUtils.getInputSlotTexture());
                SpiritUtils.fillSlots((ChestMenu)this, BORDER_OUTPUT, ChestMenuUtils.getOutputSlotTexture());
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                int[] toReturn = new int[]{};
                if (flow == ItemTransportFlow.INSERT) {
                    toReturn = ElectricSpiritCatcher.this.getInputSlots();
                }
                if (flow == ItemTransportFlow.WITHDRAW) {
                    toReturn = ElectricSpiritCatcher.this.getOutputSlots();
                }
                return toReturn;
            }
        };
    }

    private BlockBreakHandler onBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(@Nonnull Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), ElectricSpiritCatcher.this.getInputSlots());
                    inv.dropItems(b.getLocation(), ElectricSpiritCatcher.this.getOutputSlots());
                }
            }
        };
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                ElectricSpiritCatcher.this.tick(b);
            }

            public boolean isSynchronized() {
                return true;
            }
        }});
    }

    protected void tick(Block b) {
        Location location = b.getLocation();
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        BlockPosition pos = new BlockPosition(b.getWorld(), b.getX(), b.getY(), b.getZ());
        boolean isCatching = catching.getOrDefault(pos, false);
        if (isCatching || this.getCharge(location) < this.getCapacity()) {
            return;
        }
        String id = ItemStacks.SU_SPIRIT_NET.getItemId();
        SlimefunItem input1 = SlimefunItem.getByItem((ItemStack)inv.getItemInSlot(19));
        SlimefunItem input2 = SlimefunItem.getByItem((ItemStack)inv.getItemInSlot(20));
        if (input1 == null && input2 == null || input1 != null && !input1.getId().equals(id) && input2 != null && !input2.getId().equals(id)) {
            return;
        }
        if (inv.getItemInSlot(24) != null && inv.getItemInSlot(25) != null) {
            return;
        }
        ItemStack spiritNet = input1 != null && input1.getId().equals(id) ? inv.getItemInSlot(19) : inv.getItemInSlot(20);
        int outputSlot = inv.getItemInSlot(24) == null ? 24 : 25;
        LivingEntity target = null;
        for (LivingEntity livingEntity : this.spiritEntityManager.entityCollection) {
            if (!(location.distance(livingEntity.getLocation()) <= 10.0) || PersistentDataAPI.hasBoolean((PersistentDataHolder)livingEntity, (NamespacedKey)Keys.spiritLocked)) continue;
            target = livingEntity;
            break;
        }
        if (target == null) {
            return;
        }
        PersistentDataAPI.setBoolean(target, (NamespacedKey)Keys.spiritLocked, (boolean)true);
        ((Allay)target).setAware(false);
        Vibration vibration = new Vibration(target.getLocation(), (Vibration.Destination)new Vibration.Destination.BlockDestination(location), 20);
        location.getWorld().spawnParticle(Particle.VIBRATION, target.getLocation(), 1, (Object)vibration);
        Vector direction = location.clone().subtract(target.getLocation().clone()).toVector();
        target.setVelocity(direction.normalize().multiply(0.5));
        ItemStack toReturn = new ItemStack(Material.AIR);
        int tier = 1;
        if (this.spiritEntityManager.getCustomClass((Entity)target, null) instanceof UnIdentifiedSpirit) {
            toReturn = ItemStacks.SU_UNIDENTIFIED_SPIRIT.clone();
        } else {
            AbstractCustomMob<?> abstractCustomMob = this.spiritEntityManager.getCustomClass((Entity)target, null);
            if (abstractCustomMob instanceof Spirit) {
                Spirit spirit = (Spirit)abstractCustomMob;
                toReturn = SpiritUtils.spiritItem(PersistentDataAPI.getString((PersistentDataHolder)target, (NamespacedKey)Keys.spiritStateKey), spirit.getDefinition());
                tier = spirit.getDefinition().getTier();
            }
        }
        this.removeCharge(location, ElectricSpiritCatcher.getEnergyConsumption() * tier);
        catching.put(pos, true);
        LivingEntity finalTarget = target;
        ItemStack finalToReturn = toReturn;
        Bukkit.getScheduler().runTaskLater((Plugin)SpiritsUnchained.getInstance(), () -> {
            ParticleUtils.spawnParticleRadius(location, Particle.SPELL_INSTANT, 1.5, 10, "", new Object[0]);
            finalTarget.getWorld().playSound(finalTarget.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_BREAK, 1.0f, 1.0f);
            finalTarget.remove();
            spiritNet.subtract();
            catching.put(pos, false);
            inv.replaceExistingItem(outputSlot, finalToReturn);
        }, 20L);
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 2000;
    }

    public static int getEnergyConsumption() {
        return 500;
    }

    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }
}

