/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.managers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.utils.LogUtils;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final FileConfiguration spirits = this.loadConfig("spirits.yml", true);
    private final FileConfiguration traits = this.loadConfig("traits.yml", true);
    private final FileConfiguration playerData;
    private final FileConfiguration biomeGroups = this.loadConfig("biome-groups.yml", true);
    private final FileConfiguration rewards;
    private final FileConfiguration books;
    private final Map<String, List<String>> biomeMap;

    public ConfigManager() {
        this.playerData = this.loadConfig("player-data.yml", false);
        this.rewards = this.loadConfig("rewards.yml", true);
        this.books = this.loadConfig("books.yml", true);
        this.biomeMap = this.fillBiomeMap();
    }

    @Nonnull
    private FileConfiguration loadConfig(@Nonnull String name, boolean override) {
        SpiritsUnchained plugin = SpiritsUnchained.getInstance();
        File file = new File(plugin.getDataFolder(), name);
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        try {
            configuration.load(file);
            if (override) {
                this.overrideConfiguration((FileConfiguration)configuration, file, name);
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    @ParametersAreNonnullByDefault
    private void overrideConfiguration(FileConfiguration config, File file, String fileName) throws IOException {
        InputStream inputStream = SpiritsUnchained.getInstance().getResource(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        YamlConfiguration defaults = YamlConfiguration.loadConfiguration((Reader)reader);
        config.addDefaults((Configuration)defaults);
        config.options().copyDefaults(true);
        config.save(file);
    }

    public void save() {
        LogUtils.logInfo("Saving Player Data");
        File file = new File(SpiritsUnchained.getInstance().getDataFolder(), "player-data.yml");
        try {
            this.playerData.save(file);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private Map<String, List<String>> fillBiomeMap() {
        HashMap<String, List<String>> finalMap = new HashMap<String, List<String>>();
        for (String group : this.biomeGroups.getKeys(false)) {
            finalMap.put(group, this.biomeGroups.getStringList(group));
        }
        return finalMap;
    }

    public FileConfiguration getSpirits() {
        return this.spirits;
    }

    public FileConfiguration getTraits() {
        return this.traits;
    }

    public FileConfiguration getPlayerData() {
        return this.playerData;
    }

    public FileConfiguration getBiomeGroups() {
        return this.biomeGroups;
    }

    public FileConfiguration getRewards() {
        return this.rewards;
    }

    public FileConfiguration getBooks() {
        return this.books;
    }

    public Map<String, List<String>> getBiomeMap() {
        return this.biomeMap;
    }
}

