/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.utils;

import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ParticleUtils {
    private static double[][] sphere;

    public static void setup() {
        sphere = new double[84][];
        int sphereLoc = 0;
        for (double i = 0.0; i <= Math.PI; i += 0.5235987755982988) {
            double radius = Math.sin(i);
            double y = Math.cos(i);
            for (double a = 0.0; a < Math.PI * 2; a += 0.5235987755982988) {
                double x = Math.cos(a) * radius;
                double z = Math.sin(a) * radius;
                ParticleUtils.sphere[sphereLoc] = new double[]{x, y, z};
                ++sphereLoc;
            }
        }
    }

    public static void spawnParticleRadius(Location location, Particle particle, double radius, int amount, String type, Object ... other) {
        block10: for (int i = 0; i < amount; ++i) {
            double x = ThreadLocalRandom.current().nextDouble(-radius, radius + 0.1);
            double y = ThreadLocalRandom.current().nextDouble(-radius, radius + 0.1);
            double z = ThreadLocalRandom.current().nextDouble(-radius, radius + 0.1);
            World world = location.getWorld();
            switch (type) {
                case "Colored": {
                    world.spawnParticle(particle, location.clone().add(x, y, z), 1, 0.0, 0.0, 0.0, (Object)((Particle.DustOptions)other[0]));
                    continue block10;
                }
                case "Freeze": {
                    world.spawnParticle(particle, location.clone().add(x, y, z), 1, 0.0, 0.0, 0.0, 0.0);
                    continue block10;
                }
                case "Spirit": {
                    Collection<Player> collection = SpiritUtils.getNearImbued(location);
                    for (Player player : collection) {
                        player.spawnParticle(particle, location.clone().add(x, y, z), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    continue block10;
                }
                default: {
                    world.spawnParticle(particle, location.clone().add(x, y, z), 1);
                }
            }
        }
    }

    public static void catchAnimation(Location location) {
        World world = location.getWorld();
        world.playSound(location, Sound.ENTITY_ENDER_EYE_DEATH, 1.0f, 1.0f);
        for (double[] offsets : sphere) {
            Location particleLocation = location.clone().add(offsets[0], offsets[1], offsets[2]);
            Vector direction = location.clone().subtract(particleLocation.clone()).toVector();
            world.spawnParticle(Particle.END_ROD, particleLocation, 0, direction.getX(), direction.getY(), direction.getZ(), 0.1);
        }
    }

    public static void bottleAnimation(Location location) {
        World world = location.getWorld();
        world.playSound(location, Sound.ENTITY_ENDER_EYE_DEATH, 1.0f, 1.0f);
        double[] speeds = new double[]{0.1, 0.15, 0.2, 0.25};
        for (double[] offsets : sphere) {
            world.spawnParticle(Particle.END_ROD, location.clone().add(offsets[0], offsets[1], offsets[2]), 0, 0.0, 5.0, 0.0, speeds[new Random().nextInt(0, speeds.length)]);
        }
    }

    public static void passOnAnimation(Location location) {
        World world = location.getWorld();
        location = location.clone().add(0.0, 0.5, 0.0);
        world.playSound(location, Sound.ENTITY_ENDER_EYE_DEATH, 1.0f, 1.0f);
        for (double[] offsets : sphere) {
            Location particleLocation = location.clone().add(offsets[0], offsets[1], offsets[2]);
            Vector direction = particleLocation.clone().subtract(location.clone()).toVector();
            world.spawnParticle(Particle.END_ROD, particleLocation, 0, direction.getX(), direction.getY(), direction.getZ(), 0.25);
        }
    }
}

