/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.implementation.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.justahuman.spiritsunchained.spirits.SpiritDefinition;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.ParticleUtils;
import me.justahuman.spiritsunchained.utils.PlayerUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.util.Vector;

public class SpiritualAltar
extends SlimefunItem {
    private final Map<Vector, SlimefunItemStack> blocks;
    private final int tier;
    private final int multiplier;
    private static final String COMPLETE = "complete";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public SpiritualAltar(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Map<Vector, SlimefunItemStack> blocks, int tier, int multiplier) {
        super(itemGroup, item, recipeType, recipe);
        this.blocks = blocks;
        this.tier = tier;
        this.multiplier = multiplier;
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return true;
            }

            public void tick(Block block, SlimefunItem slimefunItem, Config config) {
                SpiritualAltar.this.tick(block);
            }
        }});
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{this.onPlace(), this.onUse(), this.onBreak()});
    }

    protected void tick(@Nonnull Block block) {
        Location location = block.getLocation();
        Collection players = block.getWorld().getNearbyPlayers(location, 2.0);
        if (players.isEmpty() || SpiritualAltar.isNotComplete(block)) {
            return;
        }
        this.particle(this.multiplier * 2, location);
        for (Player player : players) {
            ItemStack itemStack = SpiritualAltar.getSpiritItem(player);
            if (itemStack == null) continue;
            SpiritDefinition spiritDefinition = SpiritUtils.getSpiritDefinition(itemStack);
            SpiritUtils.updateSpiritItemProgress(itemStack, (double)this.multiplier / (double)spiritDefinition.getTier());
            if (!PersistentDataAPI.getString((PersistentDataHolder)itemStack.getItemMeta(), (NamespacedKey)Keys.spiritStateKey).equals("Friendly")) continue;
            PlayerUtils.learnKnowledgePiece(player, spiritDefinition.getType(), 3);
        }
    }

    private void particle(Integer times, Location start) {
        ParticleUtils.spawnParticleRadius(start.clone().add(0.0, 1.5, 0.0), Particle.END_ROD, 2.0, times, "Freeze", new Object[0]);
    }

    @Nullable
    private static ItemStack getSpiritItem(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (!SpiritUtils.isSpiritItem(item) || PersistentDataAPI.getString((PersistentDataHolder)item.getItemMeta(), (NamespacedKey)Keys.spiritStateKey).equals("Friendly") && PersistentDataAPI.getDouble((PersistentDataHolder)item.getItemMeta(), (NamespacedKey)Keys.spiritProgressKey) == 100.0) continue;
            return item;
        }
        return null;
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent event) {
                Block block = event.getBlockPlaced();
                if (SpiritualAltar.this.checkComplete(block)) {
                    BlockStorage.addBlockInfo((Block)block, (String)SpiritualAltar.COMPLETE, (String)SpiritualAltar.TRUE);
                    event.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.completed." + SpiritualAltar.this.tier));
                } else {
                    BlockStorage.addBlockInfo((Block)block, (String)SpiritualAltar.COMPLETE, (String)SpiritualAltar.FALSE);
                    event.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.complete_prompt"));
                }
            }
        };
    }

    private BlockUseHandler onUse() {
        return event -> {
            Block block;
            Block block2 = block = event.getClickedBlock().isPresent() ? (Block)event.getClickedBlock().get() : null;
            if (block != null && SpiritualAltar.isNotComplete(block)) {
                if (this.checkComplete(block)) {
                    BlockStorage.addBlockInfo((Block)block, (String)COMPLETE, (String)TRUE);
                    event.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.completed." + this.tier));
                } else {
                    BlockStorage.addBlockInfo((Block)block, (String)COMPLETE, (String)FALSE);
                    event.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.not_completed"));
                }
            }
            event.cancel();
        };
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent event, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                BlockStorage.addBlockInfo((Block)event.getBlock(), (String)SpiritualAltar.COMPLETE, null);
                BlockStorage.clearBlockInfo((Block)event.getBlock());
                event.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.broken"));
            }
        };
    }

    private boolean checkComplete(@Nonnull Block block) {
        for (Map.Entry<Vector, SlimefunItemStack> entry : this.blocks.entrySet()) {
            Vector relative = entry.getKey();
            SlimefunItemStack relativeItemStack = entry.getValue();
            String relativeId = relativeItemStack.getItemId();
            Material relativeMaterial = relativeItemStack.getType();
            Block relativeBlock = block.getRelative(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ());
            if (relativeBlock.getType() == relativeMaterial && this.isAltarPiece(relativeBlock, relativeId)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNotComplete(Block block) {
        String storage = BlockStorage.getLocationInfo((Location)block.getLocation(), (String)COMPLETE);
        return !Boolean.parseBoolean(storage);
    }

    private boolean isAltarPiece(@Nonnull Block block, String relativeId) {
        String id = BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"id");
        if (id == null) {
            return false;
        }
        return id.equals(relativeId);
    }

    public Map<Vector, SlimefunItemStack> getBlocks() {
        return this.blocks;
    }
}

