/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.listeners;

import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.papermc.paper.event.entity.ElderGuardianAppearanceEvent;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.slimefun.ItemStacks;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.PlayerUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PigZombieAngerEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;

public class TraitListeners
implements Listener {
    SpiritsUnchained instance = SpiritsUnchained.getInstance();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProjectileHit(ProjectileHitEvent event) {
        String key;
        Projectile projectile = event.getEntity();
        String string = key = PersistentDataAPI.hasString((PersistentDataHolder)projectile, (NamespacedKey)Keys.entityKey) ? PersistentDataAPI.getString((PersistentDataHolder)projectile, (NamespacedKey)Keys.entityKey) : "";
        if (key.equalsIgnoreCase("Eggpult")) {
            TNTPrimed tnt = (TNTPrimed)projectile.getWorld().spawnEntity(projectile.getLocation(), EntityType.PRIMED_TNT);
            tnt.setFuseTicks(1);
            PersistentDataAPI.setString((PersistentDataHolder)tnt, (NamespacedKey)Keys.entityKey, (String)"DullExplosion");
            PersistentDataAPI.setString((PersistentDataHolder)tnt, (NamespacedKey)Keys.immuneKey, (String)PersistentDataAPI.getString((PersistentDataHolder)projectile, (NamespacedKey)Keys.ownerKey));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTntExplode(EntityExplodeEvent event) {
        Entity exploding = event.getEntity();
        if (!PersistentDataAPI.hasString((PersistentDataHolder)exploding, (NamespacedKey)Keys.entityKey)) {
            return;
        }
        if (PersistentDataAPI.getString((PersistentDataHolder)exploding, (NamespacedKey)Keys.entityKey).equals("DullExplosion") || PersistentDataAPI.getString((PersistentDataHolder)exploding, (NamespacedKey)Keys.entityKey).equals("Skull_Fire")) {
            event.blockList().clear();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerShoot(EntityShootBowEvent event) {
        Player player;
        LivingEntity livingEntity;
        block6: {
            block5: {
                livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block5;
                player = (Player)livingEntity;
                livingEntity = event.getProjectile();
                if (livingEntity instanceof Arrow) break block6;
            }
            return;
        }
        Arrow arrow1 = (Arrow)livingEntity;
        if (SpiritUtils.chance(35) && this.isUsed(player, EntityType.PILLAGER)) {
            Arrow arrow2 = (Arrow)SpiritUtils.spawnProjectile(player, Arrow.class, "Multishoot");
            Arrow arrow3 = (Arrow)SpiritUtils.spawnProjectile(player, Arrow.class, "Multishoot");
            arrow2.setPickupStatus(AbstractArrow.PickupStatus.CREATIVE_ONLY);
            arrow3.setPickupStatus(AbstractArrow.PickupStatus.CREATIVE_ONLY);
            arrow2.setShooter((ProjectileSource)player);
            arrow3.setShooter((ProjectileSource)player);
            arrow2.setColor(arrow1.getColor());
            arrow3.setColor(arrow1.getColor());
            arrow2.setVelocity(arrow1.getVelocity().rotateAroundY(Math.toRadians(10.0)));
            arrow3.setVelocity(arrow1.getVelocity().rotateAroundY(Math.toRadians(-10.0)));
            arrow2.setDamage(arrow1.getDamage());
            arrow3.setDamage(arrow1.getDamage());
            arrow2.setCritical(arrow1.isCritical());
            arrow3.setCritical(arrow1.isCritical());
            for (PotionEffect effect : arrow1.getCustomEffects()) {
                arrow2.addCustomEffect(effect, true);
                arrow3.addCustomEffect(effect, true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        AbstractArrow arrow;
        Entity entity;
        Player attackingPlayer;
        Entity entity2;
        Entity entity3;
        Player maybe;
        Entity entity4 = event.getEntity();
        if (!(entity4 instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity5 = (LivingEntity)entity4;
        LivingEntity livingEntity = entity5;
        Player player = livingEntity instanceof Player ? (maybe = (Player)livingEntity) : null;
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cause == EntityDamageEvent.DamageCause.FALL && this.isUsed(player, EntityType.SLIME)) {
            event.setDamage(event.getDamage() / 2.0);
        }
        if (cause == EntityDamageEvent.DamageCause.CONTACT && this.isUsed(player, EntityType.FOX)) {
            event.setDamage(0.0);
            return;
        }
        if (cause == EntityDamageEvent.DamageCause.FREEZE && this.isUsed(player, EntityType.SNOWMAN)) {
            event.setCancelled(true);
            return;
        }
        if (cause == EntityDamageEvent.DamageCause.WITHER && this.isUsed(player, EntityType.WITHER_SKELETON)) {
            event.setCancelled(true);
            return;
        }
        EntityDamageEvent entityDamageEvent = event;
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent otherEvent = (EntityDamageByEntityEvent)entityDamageEvent;
            entity3 = otherEvent.getDamager();
        } else {
            entity3 = null;
        }
        Entity attacker = entity3;
        AttributeInstance attributeInstance = entity5.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        double finalHealth = entity5.getHealth() - event.getFinalDamage();
        double maxHealth = attributeInstance != null ? attributeInstance.getValue() : 1.0;
        double finalHealthPercentage = finalHealth / maxHealth;
        if (attacker != null && PersistentDataAPI.hasString((PersistentDataHolder)attacker, (NamespacedKey)Keys.immuneKey) && PersistentDataAPI.getString((PersistentDataHolder)attacker, (NamespacedKey)Keys.immuneKey).equals(entity5.getUniqueId().toString())) {
            event.setCancelled(true);
            return;
        }
        if (attacker != null && PersistentDataAPI.hasBoolean((PersistentDataHolder)attacker, (NamespacedKey)Keys.heavyHitKey) && PersistentDataAPI.getBoolean((PersistentDataHolder)attacker, (NamespacedKey)Keys.heavyHitKey)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.instance, () -> entity5.setVelocity(new Vector(0, 1, 0)), 2L);
            PersistentDataAPI.setBoolean((PersistentDataHolder)attacker, (NamespacedKey)Keys.heavyHitKey, (boolean)false);
        }
        if (attacker instanceof ThrownPotion && this.isUsed(player, EntityType.ZOMBIE, EntityType.ZOMBIE_VILLAGER)) {
            event.setCancelled(true);
            player.setHealth(Math.min(player.getHealth() + event.getFinalDamage(), maxHealth));
            player.sendHealthUpdate();
        }
        if ((entity2 = attacker) instanceof Player) {
            attackingPlayer = (Player)entity2;
            if (event.getCause() == EntityDamageEvent.DamageCause.THORNS && SpiritUtils.chance(25) && this.isUsed(attackingPlayer, EntityType.PUFFERFISH)) {
                entity5.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 200, 1, true));
            }
        }
        if ((entity2 = attacker) instanceof Player) {
            attackingPlayer = (Player)entity2;
            if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && SpiritUtils.chance(25) && this.isUsed(attackingPlayer, EntityType.HUSK)) {
                entity5.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 600, 1, true));
            }
        }
        if ((entity = attacker) instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity).getShooter()) instanceof Player) {
            attackingPlayer = (Player)entity;
            if (event.getCause() == EntityDamageEvent.DamageCause.PROJECTILE && SpiritUtils.chance(25) && this.isUsed(attackingPlayer, EntityType.STRAY)) {
                entity5.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 600, 1, true));
            }
        }
        if (attacker != null && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && SpiritUtils.chance(50) && this.isUsed(player, EntityType.GUARDIAN)) {
            EntityDamageByEntityEvent newEvent = new EntityDamageByEntityEvent((Entity)entity5, attacker, EntityDamageEvent.DamageCause.THORNS, (double)SpiritUtils.random(1, 5));
            newEvent.callEvent();
        }
        if (attacker != null && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && SpiritUtils.chance(25) && this.isUsed(player, EntityType.BLAZE)) {
            attacker.setFireTicks(100);
        }
        if ((entity2 = attacker) instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)entity2;
            if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && SpiritUtils.chance(25) && this.isUsed(player, EntityType.PUFFERFISH)) {
                livingEntity2.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 200, 1, true));
            }
        }
        if (finalHealthPercentage <= 0.5 && this.notOnCooldown(entity5, Keys.strongBones) && this.isUsed(player, EntityType.SKELETON)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 900, 1, true));
            this.startCooldown(player, Keys.strongBones, 90, "messages.traits.cooldown.strong_bones");
        }
        if (finalHealthPercentage <= 0.25 && this.notOnCooldown(entity5, Keys.playDead) && this.isUsed(player, EntityType.AXOLOTL)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 300, 1, true));
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 300, 1, true));
            this.startCooldown(player, Keys.playDead, 60, "messages.traits.cooldown.play_dead");
        }
        if (finalHealthPercentage <= 0.1 && this.notOnCooldown(entity5, Keys.speedyEscape) && this.isUsed(player, EntityType.OCELOT)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 300, 5, true));
            this.startCooldown(player, Keys.speedyEscape, 60, "messages.traits.cooldown.speed_escape");
        }
        if (event.getFinalDamage() >= entity5.getHealth() && this.isUsed(player, EntityType.EVOKER)) {
            ItemStack offHand = player.getInventory().getItemInOffHand().clone();
            player.getInventory().setItemInOffHand(new ItemStack(Material.TOTEM_OF_UNDYING));
            Bukkit.getScheduler().runTaskLater((Plugin)this.instance, () -> player.getInventory().setItemInOffHand(offHand), 1L);
        }
        if (SpiritUtils.chance(10) && this.isUsed(player, EntityType.TURTLE)) {
            player.getWorld().dropItemNaturally(player.getLocation(), new ItemStack(Material.SCUTE));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerSleep(PlayerDeepSleepEvent event) {
        Player player = event.getPlayer();
        if (this.notOnCooldown((LivingEntity)player, Keys.morningGift) && this.isUsed(player, EntityType.CAT)) {
            PlayerUtils.addOrDropItem(player, new ItemStack[]{ItemStacks.SU_ECTOPLASM});
            this.startCooldown(player, Keys.morningGift, 1200, "messages.traits.cooldown.morning_gift");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAngerPigZombie(PigZombieAngerEvent event) {
        Entity entity = event.getTarget();
        Entity entity2 = entity;
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            if (this.isUsed(player, EntityType.ZOMBIFIED_PIGLIN)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerGetFatigue(ElderGuardianAppearanceEvent event) {
        if (this.isUsed(event.getAffectedPlayer(), EntityType.ELDER_GUARDIAN)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onConsumeItem(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (!this.isUsed(player, EntityType.ZOMBIE, EntityType.ZOMBIE_VILLAGER)) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return;
        }
        PotionMeta potionMeta = (PotionMeta)itemMeta;
        PotionData base = potionMeta.getBasePotionData();
        for (PotionEffect effect : potionMeta.getCustomEffects()) {
            if (effect.getType() != PotionEffectType.HARM) continue;
            effect = new PotionEffect(PotionEffectType.HEAL, effect.getDuration(), effect.getAmplifier(), effect.isAmbient());
            potionMeta.removeCustomEffect(PotionEffectType.HARM);
            potionMeta.addCustomEffect(effect, true);
        }
        if (base.getType() == PotionType.INSTANT_DAMAGE) {
            base = new PotionData(PotionType.INSTANT_HEAL, base.isExtended(), base.isUpgraded());
        }
        potionMeta.setBasePotionData(base);
        item.setItemMeta((ItemMeta)potionMeta);
        event.setItem(item);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHungerChange(FoodLevelChangeEvent event) {
        HumanEntity entity = event.getEntity();
        HumanEntity humanEntity = entity;
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (SpiritUtils.chance(30) && this.isUsed(player, EntityType.WOLF)) {
            event.setFoodLevel(event.getFoodLevel() * 2);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerShear(PlayerShearEntityEvent event) {
        Entity entity = event.getEntity();
        Player player = event.getPlayer();
        if (entity instanceof Sheep && SpiritUtils.chance(75) && this.isUsed(player, EntityType.SHEEP)) {
            event.getItem().setAmount(event.getItem().getAmount() * 2);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerEnter(EntityMountEvent event) {
        Entity rider = event.getEntity();
        Entity mount = event.getMount();
        Entity entity = rider;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Entity entity2 = mount;
        if (entity2 instanceof Pig) {
            Pig pig = (Pig)entity2;
            if (!this.isUsed(player, EntityType.PIG)) {
                return;
            }
            pig.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 9, true));
            PersistentDataAPI.setBoolean((PersistentDataHolder)pig, (NamespacedKey)Keys.entityKey, (boolean)true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerLeave(EntityDismountEvent event) {
        Entity rider = event.getEntity();
        Entity dismount = event.getDismounted();
        Entity entity = rider;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Entity entity2 = dismount;
        if (entity2 instanceof Pig) {
            Pig pig = (Pig)entity2;
            if (!this.isUsed(player, EntityType.PIG)) {
                return;
            }
            if (PersistentDataAPI.hasBoolean((PersistentDataHolder)pig, (NamespacedKey)Keys.entityKey) && PersistentDataAPI.getBoolean((PersistentDataHolder)pig, (NamespacedKey)Keys.entityKey)) {
                pig.removePotionEffect(PotionEffectType.SPEED);
            }
        }
    }

    private boolean isUsed(Player player, EntityType ... types) {
        if (player == null) {
            return false;
        }
        for (EntityType type : types) {
            if (!SpiritUtils.useSpiritItem(player, type, null)) continue;
            return true;
        }
        return false;
    }

    private boolean notOnCooldown(LivingEntity entity, NamespacedKey key) {
        return !PersistentDataAPI.hasLong((PersistentDataHolder)entity, (NamespacedKey)key) || PersistentDataAPI.getLong((PersistentDataHolder)entity, (NamespacedKey)key) <= System.currentTimeMillis();
    }

    private void startCooldown(Player player, NamespacedKey key, int when, String path) {
        player.sendActionBar((Component)Component.text((String)SpiritUtils.getTranslation(path)));
        PersistentDataAPI.setLong((PersistentDataHolder)player, (NamespacedKey)key, (long)(System.currentTimeMillis() + (long)when * 1000L));
    }
}

