/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.implementation.mobs.AbstractCustomMob;
import me.justahuman.spiritsunchained.implementation.mobs.Spirit;
import me.justahuman.spiritsunchained.implementation.mobs.UnIdentifiedSpirit;
import me.justahuman.spiritsunchained.slimefun.ItemStacks;
import me.justahuman.spiritsunchained.spirits.SpiritDefinition;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;

public class IdentifyingGlassListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onSpyglassLook(PlayerStatisticIncrementEvent event) {
        Player player = event.getPlayer();
        if (event.getStatistic() != Statistic.USE_ITEM || event.getMaterial() != Material.SPYGLASS || !Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, player.getLocation(), Interaction.INTERACT_ENTITY)) {
            return;
        }
        SlimefunItem slimefunItem1 = SlimefunItem.getByItem((ItemStack)player.getInventory().getItemInMainHand());
        SlimefunItem slimefunItem2 = SlimefunItem.getByItem((ItemStack)player.getInventory().getItemInOffHand());
        if (!(slimefunItem1 != null && slimefunItem1.getId().equals(ItemStacks.SU_IDENTIFYING_GLASS.getItemId()) || slimefunItem2 != null && slimefunItem2.getId().equals(ItemStacks.SU_IDENTIFYING_GLASS.getItemId()))) {
            return;
        }
        for (Entity currentEntity : SpiritUtils.getLookingList(player)) {
            Entity entity = currentEntity;
            if (!(entity instanceof Allay)) continue;
            Allay allay = (Allay)entity;
            AbstractCustomMob<?> maybeSpirit = SpiritsUnchained.getSpiritEntityManager().getCustomClass(currentEntity, null);
            if (maybeSpirit instanceof UnIdentifiedSpirit && !PersistentDataAPI.getBoolean((PersistentDataHolder)currentEntity, (NamespacedKey)Keys.spiritIdentified)) {
                PersistentDataAPI.setBoolean((PersistentDataHolder)currentEntity, (NamespacedKey)Keys.spiritIdentified, (boolean)true);
                maybeSpirit.reveal(allay, player);
                continue;
            }
            AbstractCustomMob<?> abstractCustomMob = maybeSpirit;
            if (!(abstractCustomMob instanceof Spirit)) continue;
            Spirit spirit = (Spirit)abstractCustomMob;
            SpiritDefinition definition = spirit.getDefinition();
            ChatColor tierColor = SpiritUtils.tierColor(definition.getTier());
            ChatColor stateColor = SpiritUtils.stateColor(PersistentDataAPI.getString((PersistentDataHolder)currentEntity, (NamespacedKey)Keys.spiritStateKey));
            String actionBarMessage = SpiritUtils.getTranslation("messages.identifying_glass.use").replace("{tier_color}", tierColor.toString()).replace("{spirit_name}", ChatUtils.humanize((String)definition.getType().name())).replace("{state_color}", stateColor.toString()).replace("{state_name}", PersistentDataAPI.getString((PersistentDataHolder)currentEntity, (NamespacedKey)Keys.spiritStateKey)).replace("{tier}", String.valueOf(definition.getTier()));
            player.sendActionBar((Component)Component.text((String)actionBarMessage));
        }
    }
}

