/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.implementation.tools;

import io.github.bakedlibs.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemDropHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class SpiritRune
extends SimpleSlimefunItem<ItemDropHandler> {
    private static final double RANGE = 1.5;
    private static final String IMBUED_LORE = SpiritUtils.getTranslation("names.items.spirit_rune.tag");

    public SpiritRune(ItemGroup category, SlimefunItemStack item, RecipeType type, ItemStack[] recipe) {
        super(category, item, type, recipe);
    }

    @Nonnull
    public ItemDropHandler getItemHandler() {
        return (event, player, item) -> {
            if (this.isItem(item.getItemStack())) {
                if (this.canUse(player, true)) {
                    Slimefun.runSync(() -> {
                        try {
                            this.addSpiritTag(player, item);
                        }
                        catch (Exception x) {
                            this.error("An Exception occurred while trying to apply an Spirit Rune", x);
                        }
                    }, (long)20L);
                }
                return true;
            }
            return false;
        };
    }

    private void addSpiritTag(@Nonnull Player player, @Nonnull Item rune) {
        if (!rune.isValid()) {
            return;
        }
        Location location = rune.getLocation();
        Collection entities = location.getWorld().getNearbyEntities(location, 1.5, 1.5, 1.5, this::findCompatibleItem);
        Optional optional = entities.stream().findFirst();
        if (optional.isPresent()) {
            Item item = (Item)optional.get();
            ItemStack itemStack = item.getItemStack();
            ItemStack runeStack = rune.getItemStack();
            if (!itemStack.getType().name().endsWith("HELMET")) {
                player.sendMessage(SpiritUtils.getTranslation("messages.spirit_rune.not_helmet"));
                return;
            }
            if (itemStack.getAmount() == 1 && runeStack.getAmount() == 1) {
                location.getWorld().strikeLightningEffect(location);
                Slimefun.runSync(() -> {
                    if (rune.isValid() && runeStack.getAmount() == 1 && item.isValid() && itemStack.getAmount() == 1 && !PersistentDataAPI.hasByte((PersistentDataHolder)itemStack.getItemMeta(), Keys.imbuedKey)) {
                        location.getWorld().spawnParticle(Particle.CRIT_MAGIC, location, 1);
                        location.getWorld().playSound(location, Sound.ENTITY_ZOMBIE_VILLAGER_CURE, 1.0f, 1.0f);
                        item.remove();
                        rune.remove();
                        SpiritRune.setImbued(itemStack);
                        location.getWorld().dropItemNaturally(location, itemStack);
                        player.sendMessage(SpiritUtils.getTranslation("messages.spirit_rune.imbued"));
                    }
                }, (long)10L);
            } else if (itemStack.getAmount() != 1) {
                player.sendMessage(SpiritUtils.getTranslation("messages.spirit_rune.multiple_helmets"));
            } else if (runeStack.getAmount() != 1) {
                player.sendMessage(SpiritUtils.getTranslation("messages.spirit_rune.multiple_runes"));
            }
        }
    }

    public static void setImbued(@Nullable ItemStack item) {
        if (item != null && item.getType() != Material.AIR && !PersistentDataAPI.hasByte((PersistentDataHolder)item.getItemMeta(), Keys.imbuedKey)) {
            ItemMeta meta = item.getItemMeta();
            PersistentDataAPI.setByte((PersistentDataHolder)meta, Keys.imbuedKey, (byte)2);
            List lore = meta.hasLore() ? meta.lore() : new ArrayList();
            lore.add(Component.text((String)IMBUED_LORE));
            meta.lore(lore);
            item.setItemMeta(meta);
        }
    }

    private boolean findCompatibleItem(Entity entity) {
        Entity entity2 = entity;
        if (entity2 instanceof Item) {
            Item item = (Item)entity2;
            return !PersistentDataAPI.hasByte((PersistentDataHolder)item.getItemStack().getItemMeta(), Keys.imbuedKey);
        }
        return false;
    }
}

