/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.managers;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.spirits.Goal;
import me.justahuman.spiritsunchained.spirits.SpiritDefinition;
import me.justahuman.spiritsunchained.utils.LogUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;

public class SpiritsManager {
    private final Map<EntityType, SpiritDefinition> spiritMap = new EnumMap<EntityType, SpiritDefinition>(EntityType.class);
    private final List<List<EntityType>> tierMaps = new ArrayList<List<EntityType>>();
    private final Map<EntityType, List<EntityType>> goalRequirements = new EnumMap<EntityType, List<EntityType>>(EntityType.class);

    public SpiritsManager() {
        this.tierMaps.add(new ArrayList());
        this.tierMaps.add(new ArrayList());
        this.tierMaps.add(new ArrayList());
        this.tierMaps.add(new ArrayList());
        this.fillSpiritMap();
    }

    private void fillSpiritMap() {
        FileConfiguration spirits = SpiritsUnchained.getConfigManager().getSpirits();
        for (String key : spirits.getKeys(false)) {
            EntityType type;
            try {
                type = EntityType.valueOf((String)key);
            }
            catch (IllegalArgumentException e) {
                LogUtils.logInfo("Not a Valid Entity Type: " + key);
                e.printStackTrace();
                continue;
            }
            ConfigurationSection spirit = spirits.getConfigurationSection(key);
            if (spirit == null) {
                LogUtils.logInfo("Missing Spirit's Section: " + key);
                continue;
            }
            int tier = spirit.getInt("Tier");
            List states = spirit.getStringList("States");
            List listGoal = spirit.getStringList("Pass On");
            List biomeGroup = spirit.getStringList("Biomes");
            List times = spirit.getStringList("Time");
            String dimension = spirit.getString("Dimension", "NORMAL");
            String trait = spirit.getString("Trait", "Bee_Buddy");
            Goal goal = new Goal((String)listGoal.get(0), (String)listGoal.get(1), Integer.parseInt((String)listGoal.get(2)));
            HashMap<String, List<EntityType>> relations = new HashMap<String, List<EntityType>>();
            ArrayList<EntityType> scare = new ArrayList<EntityType>();
            ArrayList<EntityType> afraid = new ArrayList<EntityType>();
            ConfigurationSection relationSection = spirit.getConfigurationSection("Relations");
            if (relationSection != null) {
                for (String relation : relationSection.getKeys(false)) {
                    for (String with : relationSection.getStringList(relation)) {
                        try {
                            if (relation.equals("Scare")) {
                                scare.add(EntityType.valueOf((String)with));
                            }
                            if (!relation.equals("Afraid")) continue;
                            afraid.add(EntityType.valueOf((String)with));
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            relations.put("Scare", scare);
            relations.put("Afraid", afraid);
            if (((String)listGoal.get(0)).equals("Kill") || ((String)listGoal.get(0)).equals("Breed")) {
                try {
                    EntityType requirementType = EntityType.valueOf((String)((String)listGoal.get(1)));
                    ArrayList<EntityType> requiredFor = this.goalRequirements.containsKey(requirementType) ? this.goalRequirements.get(requirementType) : new ArrayList<EntityType>();
                    requiredFor.add(type);
                    this.goalRequirements.put(requirementType, requiredFor);
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
            SpiritDefinition spiritDefinition = new SpiritDefinition(type, tier, states, goal, relations, trait, dimension, biomeGroup, times);
            this.spiritMap.put(type, spiritDefinition);
            this.tierMaps.get(tier - 1).add(type);
        }
        LogUtils.logInfo("Loaded " + this.spiritMap.size() + " Spirits!");
    }

    public Map<EntityType, SpiritDefinition> getSpiritMap() {
        return this.spiritMap;
    }

    public List<List<EntityType>> getTierMaps() {
        return this.tierMaps;
    }

    public Map<EntityType, List<EntityType>> getGoalRequirements() {
        return this.goalRequirements;
    }
}

