/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.implementation.mobs;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.implementation.mobs.AbstractCustomMob;
import me.justahuman.spiritsunchained.slimefun.ItemStacks;
import me.justahuman.spiritsunchained.spirits.SpiritDefinition;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.ParticleUtils;
import me.justahuman.spiritsunchained.utils.PlayerUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Spirit
extends AbstractCustomMob<Allay> {
    private static final int particleCount = 4;
    private final SpiritDefinition definition;

    public Spirit(String id, EntityType entityType) {
        super(Allay.class, id);
        this.definition = SpiritsUnchained.getSpiritsManager().getSpiritMap().get(entityType);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onSpawn(Allay allay, String state, String unused) {
        PersistentDataAPI.setLong((PersistentDataHolder)allay, (NamespacedKey)Keys.despawnKey, (long)(System.currentTimeMillis() + (long)SpiritUtils.random((int)((double)(this.definition.getTier() * 60) * 0.75), this.definition.getTier() * 60 * SpiritUtils.random(1, 3)) * 1000L));
        if (state.equals("Natural")) {
            state = this.definition.getStates().get(SpiritUtils.random(0, this.definition.getStates().size()));
        }
        PersistentDataAPI.setString((PersistentDataHolder)allay, (NamespacedKey)Keys.spiritStateKey, (String)state);
        for (Player player : allay.getWorld().getPlayers()) {
            if (!player.canSee((Entity)allay)) continue;
            player.hideEntity((Plugin)SpiritsUnchained.getInstance(), (Entity)allay);
        }
        allay.setCollidable(false);
        allay.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 20000000, 1, true, false));
        allay.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 20000000, 1, true, false));
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onTick(Allay allay) {
        Location location = allay.getLocation();
        String state = PersistentDataAPI.getString((PersistentDataHolder)allay, (NamespacedKey)Keys.spiritStateKey);
        ParticleUtils.spawnParticleRadius(location, Particle.SPELL_INSTANT, 0.1, 4, "Spirit", new Object[0]);
        SpiritUtils.spawnStateParticle(state, location);
        if (PersistentDataAPI.hasLong((PersistentDataHolder)allay, (NamespacedKey)Keys.despawnKey) && System.currentTimeMillis() >= PersistentDataAPI.getLong((PersistentDataHolder)allay, (NamespacedKey)Keys.despawnKey)) {
            ParticleUtils.passOnAnimation(location);
            allay.remove();
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHit(EntityDamageByEntityEvent event) {
        event.setCancelled(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @ParametersAreNonnullByDefault
    public void onInteract(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        EquipmentSlot hand = event.getHand();
        Entity entity = event.getRightClicked();
        EntityType type = this.definition.getType();
        ItemStack item = player.getInventory().getItem(hand);
        int tier = this.definition.getTier();
        if (item.getType() == Material.AIR) {
            return;
        }
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)item);
        if (slimefunItem != null && slimefunItem.getId().equals(ItemStacks.SU_SPIRIT_NET.getItemId())) {
            if (SpiritUtils.chance(SpiritUtils.getTierChance(tier))) {
                entity.remove();
                ParticleUtils.catchAnimation(entity.getLocation());
                PlayerUtils.addOrDropItem(player, SpiritUtils.spiritItem(PersistentDataAPI.getString((PersistentDataHolder)entity, (NamespacedKey)Keys.spiritStateKey), this.definition));
                PlayerUtils.learnKnowledgePiece(player, type, 1);
            } else {
                player.sendMessage(SpiritUtils.getTranslation("messages.spirits.escape"));
                ParticleUtils.breakParticles(entity.getLocation(), item.clone());
            }
            item.subtract();
            return;
        }
        if (slimefunItem != null && slimefunItem.getId().equals(ItemStacks.SU_SPIRIT_BOOK.getItemId())) {
            if (SpiritUtils.chance(SpiritUtils.getTierChance(tier))) {
                if (PlayerUtils.hasKnowledgePiece(player, type, 2)) {
                    player.sendMessage(SpiritUtils.getTranslation("messages.spirits.max_knowledge"));
                    return;
                }
                PlayerUtils.addOrDropItem(player, SpiritUtils.getFilledBook(this.definition));
                PlayerUtils.learnKnowledgePiece(player, type, 2);
            } else {
                player.sendMessage(SpiritUtils.getTranslation("messages.spirits.rip_book"));
                ParticleUtils.breakParticles(entity.getLocation(), item.clone());
            }
            item.subtract();
            return;
        }
        if (item.getType() != Material.GLASS_BOTTLE) return;
        if (!item.getItemMeta().getPersistentDataContainer().isEmpty()) return;
        item.subtract();
        entity.remove();
        ParticleUtils.bottleAnimation(entity.getLocation());
        PlayerUtils.addOrDropItem(player, new ItemStack[]{ItemStacks.SU_SPIRIT_BOTTLE});
    }

    public static int getParticleCount() {
        return 4;
    }

    public SpiritDefinition getDefinition() {
        return this.definition;
    }
}

