/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.sefilib.slimefun.blocks;

import io.github.bakedlibs.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.sefilib.slimefun.blocks.SefiBlock;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public abstract class OwnedBlock<T extends SefiBlock<T>>
extends SefiBlock<T> {
    private static final String OWNER_KEY = "block_owner";
    private final Map<BlockPosition, UUID> owners = new HashMap<BlockPosition, UUID>();

    protected OwnedBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    protected OwnedBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, @Nullable ItemStack recipeOutput) {
        super(itemGroup, item, recipeType, recipe, recipeOutput);
    }

    @Override
    public T getThis() {
        return (T)((Object)this);
    }

    @Override
    protected void onBlockPlaced(@Nonnull BlockPlaceEvent event) {
        BlockStorage.addBlockInfo((Block)event.getBlock(), (String)OWNER_KEY, (String)event.getPlayer().getUniqueId().toString());
        this.afterBlockPlaced(event);
    }

    protected void afterBlockPlaced(@Nonnull BlockPlaceEvent event) {
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void onTick(Block block, SlimefunItem item, Config data) {
        BlockPosition blockPosition = new BlockPosition(block);
        if (!this.owners.containsKey(blockPosition)) {
            String ownerString = BlockStorage.getLocationInfo((Location)block.getLocation(), (String)OWNER_KEY);
            try {
                UUID uuid = UUID.fromString(ownerString);
                this.owners.put(blockPosition, uuid);
            }
            catch (IllegalArgumentException exception) {
                Logger logger = this.addon.getLogger();
                logger.severe("A block has no valid registered owner and will likely error.");
                logger.severe("The block is located at: " + block.getLocation());
            }
        }
        this.onTickAfterOwner(block, item, data);
    }

    @ParametersAreNonnullByDefault
    protected void onTickAfterOwner(Block block, SlimefunItem item, Config data) {
    }

    @Nullable
    public OfflinePlayer getOwner(@Nonnull Block block) {
        return this.getOwner(new BlockPosition(block));
    }

    @Nullable
    public OfflinePlayer getOwner(@Nonnull BlockPosition blockPosition) {
        return Bukkit.getOfflinePlayer((UUID)this.owners.get(blockPosition));
    }

    public void setOwner(@Nonnull Block block, @Nonnull Player player) {
        this.setOwner(new BlockPosition(block), player);
    }

    public void setOwner(@Nonnull BlockPosition blockPosition, @Nonnull Player player) {
        BlockStorage.addBlockInfo((Location)blockPosition.toLocation(), (String)OWNER_KEY, (String)player.getUniqueId().toString());
        this.owners.put(blockPosition, player.getUniqueId());
    }
}

