/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.managers;

import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.implementation.mobs.AbstractCustomMob;
import me.justahuman.spiritsunchained.listeners.PlayerArmorListener;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class SpiritEntityManager
implements Listener {
    public final Map<String, AbstractCustomMob<?>> entityMap = new HashMap();
    public final Set<UUID> entitySet = new HashSet<UUID>();

    public SpiritEntityManager() {
        SpiritsUnchained instance = SpiritsUnchained.getInstance();
        FileConfiguration config = instance.getConfig();
        int tickRate = Math.min(config.getInt("options.tick-rate", 2), 20);
        int spawnRate = config.getInt("options.spawn-rate", 10) * 20;
        instance.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)instance);
        Bukkit.getScheduler().runTaskTimer((Plugin)instance, this::tick, (long)tickRate, (long)Math.max(1, tickRate));
        Bukkit.getScheduler().runTaskTimer((Plugin)instance, this::spawnTick, 1L, (long)spawnRate);
    }

    public void register(AbstractCustomMob<?> customMob) {
        if (this.entityMap.containsKey(customMob.getId())) {
            throw new IllegalArgumentException("Custom Entity Already Registered!" + customMob.getId());
        }
        this.entityMap.put(customMob.getId(), customMob);
    }

    public AbstractCustomMob<?> getCustomClass(Entity entity, String key) {
        String getKey = entity != null && PersistentDataAPI.hasString((PersistentDataHolder)entity, (NamespacedKey)Keys.entityKey) ? PersistentDataAPI.getString((PersistentDataHolder)entity, (NamespacedKey)Keys.entityKey) : key;
        return getKey == null ? null : this.entityMap.get(getKey);
    }

    public Set<LivingEntity> getCustomLivingEntities() {
        HashSet<LivingEntity> toReturn = new HashSet<LivingEntity>();
        for (UUID uuid : this.entitySet) {
            Entity entity = Bukkit.getEntity((UUID)uuid);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            toReturn.add(livingEntity);
        }
        return toReturn;
    }

    private void tick() {
        for (LivingEntity livingEntity : this.getCustomLivingEntities()) {
            AbstractCustomMob<?> customMob = this.getCustomClass((Entity)livingEntity, null);
            if (customMob == null) continue;
            customMob.onEntityTick(livingEntity);
        }
    }

    private void spawnTick() {
        for (UUID uuid : PlayerArmorListener.getCanSeeUUIDList()) {
            Block b;
            String maybeSpirit;
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || player.getGameMode() != GameMode.SURVIVAL || SpiritsUnchained.getInstance().getConfig().getStringList("options.disabled-worlds").contains(player.getWorld().getName())) continue;
            int spiritCount = SpiritUtils.getNearbySpirits(player.getLocation(), 64).size();
            if (!SpiritUtils.canSpawn() || spiritCount >= SpiritUtils.getPlayerCap() || !SpiritUtils.chance(10) || (maybeSpirit = SpiritUtils.getSpawnMob((b = SpiritUtils.getSpawnBlock(player.getLocation())).getLocation())) == null || this.entityMap.get("UNIDENTIFIED_SPIRIT") == null) continue;
            this.entityMap.get("UNIDENTIFIED_SPIRIT").spawn(b.getLocation(), player.getWorld(), "Natural", maybeSpirit);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onEntityTarget(@Nonnull EntityTargetEvent event) {
        AbstractCustomMob<?> customMob = this.getCustomClass(event.getEntity(), null);
        if (customMob != null) {
            customMob.onTarget(event);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    private void onEntityInteract(@Nonnull PlayerInteractEntityEvent event) {
        AbstractCustomMob<?> customMob = this.getCustomClass(event.getRightClicked(), null);
        if (customMob != null) {
            customMob.onInteract(event);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onEntityHit(@Nonnull EntityDamageByEntityEvent event) {
        AbstractCustomMob<?> customMob = this.getCustomClass(event.getEntity(), null);
        if (customMob != null) {
            customMob.onHit(event);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onEntityDie(@Nonnull EntityDeathEvent event) {
        AbstractCustomMob<?> customMob = this.getCustomClass((Entity)event.getEntity(), null);
        if (customMob != null) {
            customMob.onDeath(event);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onEntityCombust(@Nonnull EntityCombustEvent event) {
        AbstractCustomMob<?> customMob = this.getCustomClass(event.getEntity(), null);
        if (customMob != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onEntityDamage(@Nonnull EntityDamageEvent event) {
        AbstractCustomMob<?> customMob = this.getCustomClass(event.getEntity(), null);
        if (customMob != null) {
            customMob.onDamage(event);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onEntityRemove(@Nonnull EntityRemoveFromWorldEvent event) {
        Entity entity = event.getEntity();
        UUID uuid = entity.getUniqueId();
        this.entitySet.remove(uuid);
    }
}

