/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.utils;

import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.managers.ConfigManager;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerUtils {
    static final ConfigManager configManager = SpiritsUnchained.getConfigManager();

    @ParametersAreNonnullByDefault
    public static void learnKnowledgePiece(Player player, EntityType type, int knowledgeType) {
        FileConfiguration playerData = configManager.getPlayerData();
        String currentKnowledge = playerData.getString(player.getUniqueId() + "." + type, "ABC");
        String newKnowledge = currentKnowledge.replace(currentKnowledge.charAt(--knowledgeType), 'Y');
        playerData.set(player.getUniqueId() + "." + type, (Object)newKnowledge);
        if (!currentKnowledge.equals(newKnowledge)) {
            player.sendMessage("You have gained new knowledge about your " + ChatUtils.humanize((String)type.name()) + " Spirit!");
        }
    }

    @ParametersAreNonnullByDefault
    public static boolean hasKnowledgePiece(Player player, EntityType type, int knowledgeType) {
        FileConfiguration playerData = configManager.getPlayerData();
        String currentKnowledge = playerData.getString(player.getUniqueId() + "." + type, "NNN");
        return currentKnowledge.charAt(--knowledgeType) == 'Y';
    }

    @ParametersAreNonnullByDefault
    public static void addOrDropItem(Player player, ItemStack ... itemStacks) {
        HashMap remaining = player.getInventory().addItem(itemStacks);
        if (remaining.size() > 0) {
            for (ItemStack itemStack : remaining.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), itemStack);
            }
        }
    }
}

