/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.implementation.mobs;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.implementation.mobs.AbstractCustomMob;
import me.justahuman.spiritsunchained.slimefun.ItemStacks;
import me.justahuman.spiritsunchained.spirits.SpiritDefinition;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.ParticleUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class UnIdentifiedSpirit
extends AbstractCustomMob<Allay> {
    public UnIdentifiedSpirit() {
        super(Allay.class, "UNIDENTIFIED_SPIRIT", "&7Unidentified Spirit", 10.0);
    }

    @Override
    @Nonnull
    public Allay spawn(@Nonnull Location loc, @Nonnull World world, String reason, String type) {
        Allay mob = (Allay)world.spawn(loc, this.getClazz());
        SpiritsUnchained.getSpiritEntityManager().entitySet.add(mob.getUniqueId());
        SpiritDefinition definition = SpiritsUnchained.getSpiritsManager().getSpiritMap().get(EntityType.valueOf((String)type));
        String state = reason.equals("Natural") ? definition.getStates().get(SpiritUtils.random(0, definition.getStates().size())) : reason;
        type = type == null ? "COW_SPIRIT" : (String)type + "_SPIRIT";
        PersistentDataAPI.setString((PersistentDataHolder)mob, (NamespacedKey)Keys.entityKey, (String)this.getId());
        PersistentDataAPI.setString((PersistentDataHolder)mob, (NamespacedKey)Keys.spiritStateKey, (String)state);
        PersistentDataAPI.setString((PersistentDataHolder)mob, (NamespacedKey)Keys.spiritTypeKey, (String)type);
        PersistentDataAPI.setBoolean((PersistentDataHolder)mob, (NamespacedKey)Keys.spiritIdentified, (boolean)false);
        PersistentDataAPI.setLong((PersistentDataHolder)mob, (NamespacedKey)Keys.despawnKey, (long)(System.currentTimeMillis() + (long)SpiritUtils.random((int)((double)((long)definition.getTier() * 60L) * 0.75), definition.getTier() * 60 * SpiritUtils.random(1, 3)) * 1000L));
        mob.setRemoveWhenFarAway(true);
        mob.setCanPickupItems(false);
        this.onSpawn(mob);
        return mob;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onSpawn(Allay allay) {
        for (Player player : allay.getWorld().getPlayers()) {
            if (!player.canSee((Entity)allay)) continue;
            player.hideEntity((Plugin)SpiritsUnchained.getInstance(), (Entity)allay);
        }
        allay.setCollidable(false);
        allay.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 20000000, 1, true, false));
        allay.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 20000000, 1, true, false));
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onTick(Allay allay) {
        Location location = allay.getLocation();
        ParticleUtils.spawnParticleRadius(location, Particle.SPELL_INSTANT, 0.1, 5, "Spirit", new Object[0]);
        if (PersistentDataAPI.hasLong((PersistentDataHolder)allay, (NamespacedKey)Keys.despawnKey) && System.currentTimeMillis() >= PersistentDataAPI.getLong((PersistentDataHolder)allay, (NamespacedKey)Keys.despawnKey)) {
            ParticleUtils.passOnAnimation(location);
            this.getSpiritEntityManager().entitySet.remove(allay.getUniqueId());
            allay.remove();
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onDeath(EntityDeathEvent event) {
        Allay allay = (Allay)event.getEntity();
        if (allay.getKiller() != null) {
            event.getDrops().add(ItemStacks.SU_ECTOPLASM);
            return;
        }
        event.setShouldPlayDeathSound(false);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onInteract(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        EquipmentSlot hand = event.getHand();
        ItemStack item = player.getInventory().getItem(hand);
        if (item.getType() == Material.AIR) {
            return;
        }
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)item);
        if (slimefunItem != null && slimefunItem.getId().equals(ItemStacks.SU_SPIRIT_NET.getItemId())) {
            ParticleUtils.catchAnimation(entity.getLocation());
            entity.remove();
            item.setAmount(item.getAmount() - 1);
            player.getInventory().addItem(new ItemStack[]{ItemStacks.SU_UNIDENTIFIED_SPIRIT});
        } else if (item.getType() == Material.GLASS_BOTTLE && item.getItemMeta().getPersistentDataContainer().isEmpty()) {
            ParticleUtils.bottleAnimation(entity.getLocation());
            entity.remove();
            item.setAmount(item.getAmount() - 1);
            player.getInventory().addItem(new ItemStack[]{ItemStacks.SU_SPIRIT_BOTTLE});
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHit(EntityDamageByEntityEvent event) {
        event.setCancelled(true);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void reveal(Allay allay, Player player) {
        SpiritsUnchained.getSpiritEntityManager().getCustomClass(null, PersistentDataAPI.getString((PersistentDataHolder)allay, (NamespacedKey)Keys.spiritTypeKey)).spawn(allay.getLocation(), allay.getWorld(), "Reveal", PersistentDataAPI.getString((PersistentDataHolder)allay, (NamespacedKey)Keys.spiritStateKey));
        allay.remove();
    }
}

