/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.listeners;

import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PlayerArmorListener
implements Listener {
    private static final Set<UUID> canSeeUUIDList = new HashSet<UUID>();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerArmorChange(PlayerArmorChangeEvent event) {
        Player player = event.getPlayer();
        ItemStack newItem = event.getNewItem();
        PlayerArmorChangeEvent.SlotType slotType = event.getSlotType();
        if (slotType != PlayerArmorChangeEvent.SlotType.HEAD) {
            return;
        }
        if (!SpiritUtils.imbuedCheck(newItem)) {
            canSeeUUIDList.remove(player.getUniqueId());
            return;
        }
        canSeeUUIDList.add(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDispenseArmor(BlockDispenseArmorEvent event) {
        LivingEntity entity = event.getTargetEntity();
        ItemStack newItem = event.getItem();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!SpiritUtils.imbuedCheck(newItem)) {
            canSeeUUIDList.remove(player.getUniqueId());
            return;
        }
        canSeeUUIDList.add(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemBreak(PlayerItemBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack brokenItem = event.getBrokenItem();
        if (SpiritUtils.imbuedCheck(brokenItem)) {
            canSeeUUIDList.remove(player.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPostRespawn(PlayerPostRespawnEvent event) {
        PlayerArmorListener.updatePlayer(event.getPlayer());
    }

    public static void updatePlayer(Player player) {
        ItemStack helmetItem = player.getInventory().getItem(EquipmentSlot.HEAD);
        if (SpiritUtils.imbuedCheck(helmetItem)) {
            canSeeUUIDList.add(player.getUniqueId());
        } else {
            canSeeUUIDList.remove(player.getUniqueId());
        }
    }

    public static Set<UUID> getCanSeeUUIDList() {
        return canSeeUUIDList;
    }
}

