/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.implementation.mobs;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.implementation.mobs.AbstractCustomMob;
import me.justahuman.spiritsunchained.slimefun.ItemStacks;
import me.justahuman.spiritsunchained.spirits.SpiritDefinition;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.ParticleUtils;
import me.justahuman.spiritsunchained.utils.PlayerUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Spirit
extends AbstractCustomMob<Allay> {
    private static final int particleCount = 4;
    private final SpiritDefinition definition;

    public Spirit(String id, String name, EntityType soulType) {
        super(Allay.class, id, name, 10.0);
        this.definition = SpiritsUnchained.getSpiritsManager().getSpiritMap().get(soulType);
    }

    @Override
    @Nonnull
    public final Allay spawn(@Nonnull Location loc, @Nonnull World world, String reason, String revealState) {
        String state = reason.equals("Natural") ? this.definition.getStates().get(SpiritUtils.random(0, this.definition.getStates().size())) : (reason.equals("Reveal") ? revealState : reason);
        Allay mob = (Allay)world.spawn(loc, this.getClazz());
        SpiritsUnchained.getSpiritEntityManager().entitySet.add(mob.getUniqueId());
        PersistentDataAPI.setString((PersistentDataHolder)mob, (NamespacedKey)Keys.entityKey, (String)this.getId());
        PersistentDataAPI.setString((PersistentDataHolder)mob, (NamespacedKey)Keys.spiritStateKey, (String)state);
        PersistentDataAPI.setLong((PersistentDataHolder)mob, (NamespacedKey)Keys.despawnKey, (long)(System.currentTimeMillis() + (long)SpiritUtils.random((int)((double)(this.definition.getTier() * 60) * 0.75), this.definition.getTier() * 60 * SpiritUtils.random(1, 3)) * 1000L));
        mob.setRemoveWhenFarAway(true);
        mob.setCanPickupItems(false);
        this.onSpawn(mob);
        return mob;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onSpawn(Allay allay) {
        for (Player player : allay.getWorld().getPlayers()) {
            if (!player.canSee((Entity)allay)) continue;
            player.hideEntity((Plugin)SpiritsUnchained.getInstance(), (Entity)allay);
        }
        allay.setCollidable(false);
        allay.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 20000000, 1, true, false));
        allay.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 20000000, 1, true, false));
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onTick(Allay allay) {
        Location location = allay.getLocation();
        String state = PersistentDataAPI.getString((PersistentDataHolder)allay, (NamespacedKey)Keys.spiritStateKey);
        ParticleUtils.spawnParticleRadius(location, Particle.SPELL_INSTANT, 0.1, 4, "Spirit", new Object[0]);
        SpiritUtils.spawnStateParticle(state, location);
        if (PersistentDataAPI.hasLong((PersistentDataHolder)allay, (NamespacedKey)Keys.despawnKey) && System.currentTimeMillis() >= PersistentDataAPI.getLong((PersistentDataHolder)allay, (NamespacedKey)Keys.despawnKey)) {
            ParticleUtils.passOnAnimation(location);
            allay.remove();
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onDeath(EntityDeathEvent event) {
        ItemStack toDrop = ItemStacks.SU_ECTOPLASM.clone();
        toDrop.setAmount(this.definition.getTier() + 1);
        event.getDrops().add(toDrop);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHit(EntityDamageByEntityEvent event) {
        event.setCancelled(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @ParametersAreNonnullByDefault
    public void onInteract(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        EquipmentSlot hand = event.getHand();
        Entity entity = event.getRightClicked();
        EntityType type = this.definition.getType();
        ItemStack item = player.getInventory().getItem(hand);
        int tier = this.definition.getTier();
        if (item.getType() == Material.AIR) {
            return;
        }
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)item);
        if (slimefunItem != null && slimefunItem.getId().equals(ItemStacks.SU_SPIRIT_NET.getItemId())) {
            if (SpiritUtils.chance(SpiritUtils.getTierChance(tier))) {
                ParticleUtils.catchAnimation(entity.getLocation());
                entity.remove();
                PlayerUtils.addOrDropItem(player, SpiritUtils.spiritItem(PersistentDataAPI.getString((PersistentDataHolder)entity, (NamespacedKey)Keys.spiritStateKey), this.definition));
                PlayerUtils.learnKnowledgePiece(player, type, 1);
            } else {
                player.sendMessage(SpiritUtils.getTranslation("messages.spirits.escape"));
            }
            item.subtract();
            return;
        }
        if (slimefunItem != null && slimefunItem.getId().equals(ItemStacks.SU_SPIRIT_BOOK.getItemId())) {
            if (SpiritUtils.chance(SpiritUtils.getTierChance(tier))) {
                if (PlayerUtils.hasKnowledgePiece(player, type, 2)) {
                    player.sendMessage(SpiritUtils.getTranslation("messages.spirits.max_knowledge"));
                    return;
                }
                PlayerUtils.addOrDropItem(player, SpiritUtils.getFilledBook(this.definition));
                PlayerUtils.learnKnowledgePiece(player, type, 2);
            } else {
                player.sendMessage(SpiritUtils.getTranslation("messages.spirits.rip_book"));
            }
            item.subtract();
            return;
        }
        if (item.getType() != Material.GLASS_BOTTLE) return;
        if (!item.getItemMeta().getPersistentDataContainer().isEmpty()) return;
        ParticleUtils.bottleAnimation(entity.getLocation());
        entity.remove();
        item.subtract();
        PlayerUtils.addOrDropItem(player, new ItemStack[]{ItemStacks.SU_SPIRIT_BOTTLE});
    }

    public static int getParticleCount() {
        return 4;
    }

    public SpiritDefinition getDefinition() {
        return this.definition;
    }
}

