/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.spirits;

import io.github.bakedlibs.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.slimefun.Groups;
import me.justahuman.spiritsunchained.spirits.SpiritDefinition;
import me.justahuman.spiritsunchained.utils.PlayerUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class SpiritsFlexGroup
extends FlexItemGroup {
    private static final int GUIDE_BACK = 1;
    private static final int PAGE_PREVIOUS = 46;
    private static final int PAGE_NEXT = 52;
    private static final int PAGE_SIZE = 36;
    private static final int[] HEADER = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] FOOTER = new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53};
    private static final int[] DIVIDER = new int[]{13, 22, 31, 40, 49};
    private static final int[] AFRAID = new int[]{9, 10, 11, 12};
    private static final int[] AFRAID_ENTRIES = new int[]{18, 19, 20, 21, 27, 28, 29, 30, 36, 37, 38, 39, 45, 46, 47, 48};
    private static final int[] SCARE = new int[]{14, 15, 16, 17};
    private static final int[] SCARE_ENTRIES = new int[]{23, 24, 25, 26, 32, 33, 34, 35, 41, 42, 43, 44, 50, 51, 52, 53};
    private static final int SPIRIT_SLOT = 22;
    private static final int GOAL_SLOT = 30;
    private static final int RELATIONS_SLOT = 32;
    private static final int TRAIT_SLOT = 40;
    private static final String backLore = "&7" + Slimefun.getLocalization().getMessage("guide.back.guide");
    private static final ItemStack notEnoughKnowledge = new CustomItemStack(Material.WRITABLE_BOOK, SpiritsFlexGroup.name("missing_knowledge"), SpiritsFlexGroup.lore("missing_knowledge", new String[0]));
    private static final ItemStack afraidItemStack = new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, SpiritsFlexGroup.name("afraid_item"), SpiritsFlexGroup.lore("afraid_item", new String[0]));
    private static final ItemStack scareItemStack = new CustomItemStack(Material.PURPLE_STAINED_GLASS_PANE, SpiritsFlexGroup.name("scare_item"), SpiritsFlexGroup.lore("scare_item", new String[0]));

    private static String translate(String path) {
        return SpiritUtils.getTranslation("names.spirit_group." + path);
    }

    public static String name(String path) {
        return SpiritsFlexGroup.translate(path + ".name");
    }

    private static String[] lore(String path, String ... replace) {
        String[] originalLore = (String[])SpiritUtils.getTranslationList("names.spirit_group." + path + ".lore").toArray(String[]::new);
        String[] lore = new String[originalLore.length];
        int l = 0;
        for (String line : originalLore) {
            int i = 0;
            for (String piece : replace) {
                if (i % 2 == 0) {
                    line = line.replace(piece, replace[i + 1]);
                }
                ++i;
            }
            lore[l] = line;
            ++l;
        }
        return lore;
    }

    @ParametersAreNonnullByDefault
    public SpiritsFlexGroup(NamespacedKey key, ItemStack item) {
        super(key, item);
    }

    @ParametersAreNonnullByDefault
    public boolean isVisible(Player player, PlayerProfile playerProfile, SlimefunGuideMode guideMode) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public void open(Player player, PlayerProfile profile, SlimefunGuideMode mode) {
        ChestMenu menu = new ChestMenu(SpiritUtils.getTranslation("names.groups.spirits"));
        for (int slot : HEADER) {
            menu.addItem(slot, ChestMenuUtils.getBackground(), (player1, i1, itemStack, clickAction) -> false);
        }
        for (int slot : FOOTER) {
            menu.addItem(slot, ChestMenuUtils.getBackground(), (player1, i1, itemStack, clickAction) -> false);
        }
        menu.setEmptySlotsClickable(false);
        this.prepare(player, profile, mode, menu, 1);
        menu.open(new Player[]{player});
    }

    @ParametersAreNonnullByDefault
    private void prepare(Player player, PlayerProfile profile, SlimefunGuideMode mode, ChestMenu menu, int page) {
        ArrayList<SpiritDefinition> spiritList = new ArrayList<SpiritDefinition>(SpiritsUnchained.getSpiritsManager().getSpiritMap().values());
        int spiritCount = spiritList.size();
        int totalPages = (int)Math.ceil((double)spiritCount / 36.0);
        int start = (page - 1) * 36;
        int end = Math.min(start + 36, spiritCount);
        spiritList.sort(Comparator.comparing(definition -> definition.getType().name()));
        spiritList.sort(Comparator.comparing(SpiritDefinition::getTier));
        List spiritSubList = spiritList.subList(start, end);
        this.pageControls(player, profile, mode, menu, page, totalPages);
        menu.replaceExistingItem(1, ChestMenuUtils.getBackButton((Player)player, (String[])new String[]{backLore}));
        menu.addMenuClickHandler(1, (player1, slot, itemStack, clickAction) -> {
            SlimefunGuide.openItemGroup((PlayerProfile)profile, (ItemGroup)Groups.SU_MAIN_GROUP, (SlimefunGuideMode)mode, (int)1);
            return false;
        });
        for (int i = 0; i < 36; ++i) {
            int slot2 = i + 9;
            if (i + 1 <= spiritSubList.size()) {
                SpiritDefinition definition2 = (SpiritDefinition)spiritSubList.get(i);
                menu.replaceExistingItem(slot2, this.getSpiritMenuItem(definition2));
                menu.addMenuClickHandler(slot2, (player1, i1, itemStack1, clickAction) -> {
                    this.displayDefinition(player1, profile, mode, menu, page, definition2);
                    return false;
                });
                continue;
            }
            menu.replaceExistingItem(slot2, null);
            menu.addMenuClickHandler(slot2, (player1, i1, itemStack1, clickAction) -> false);
        }
    }

    private void pageControls(Player player, PlayerProfile profile, SlimefunGuideMode mode, ChestMenu menu, int page, int totalPages) {
        for (int slot2 : FOOTER) {
            menu.replaceExistingItem(slot2, ChestMenuUtils.getBackground());
            menu.addMenuClickHandler(slot2, (player1, i, itemStack, clickAction) -> false);
        }
        menu.replaceExistingItem(46, ChestMenuUtils.getPreviousButton((Player)player, (int)page, (int)totalPages));
        menu.addMenuClickHandler(46, (player1, slot, itemStack, clickAction) -> {
            int previousPage = page - 1;
            if (previousPage >= 1) {
                this.prepare(player1, profile, mode, menu, previousPage);
            }
            return false;
        });
        menu.replaceExistingItem(52, ChestMenuUtils.getNextButton((Player)player, (int)page, (int)totalPages));
        menu.addMenuClickHandler(52, (player1, slot, itemStack, clickAction) -> {
            int nextPage = page + 1;
            if (nextPage <= totalPages) {
                this.prepare(player1, profile, mode, menu, nextPage);
            }
            return false;
        });
    }

    @ParametersAreNonnullByDefault
    private void displayDefinition(Player player, PlayerProfile profile, SlimefunGuideMode mode, ChestMenu menu, int returnPage, SpiritDefinition definition) {
        EntityType entityType = definition.getType();
        menu.replaceExistingItem(1, ChestMenuUtils.getBackButton((Player)player, (String[])new String[]{backLore}));
        menu.addMenuClickHandler(1, (player1, slot, itemStack, clickAction) -> {
            this.prepare(player1, profile, mode, menu, returnPage);
            return false;
        });
        this.clearDisplay(menu);
        menu.replaceExistingItem(22, this.getSpiritMenuItem(definition));
        if (PlayerUtils.hasKnowledgePiece(player, entityType, 1) || mode == SlimefunGuideMode.CHEAT_MODE) {
            menu.replaceExistingItem(30, definition.getGoal().getDisplayStack());
        } else {
            menu.replaceExistingItem(30, notEnoughKnowledge);
        }
        if (PlayerUtils.hasKnowledgePiece(player, entityType, 2) || mode == SlimefunGuideMode.CHEAT_MODE) {
            menu.replaceExistingItem(32, (ItemStack)new CustomItemStack(Material.WRITTEN_BOOK, SpiritsFlexGroup.name("relation_book"), SpiritsFlexGroup.lore("relation_book", new String[0])));
            menu.addMenuClickHandler(32, (player1, slot, itemStack, clickAction) -> {
                this.displayRelationsTree(player1, profile, mode, menu, returnPage, definition);
                return false;
            });
        } else {
            menu.replaceExistingItem(32, notEnoughKnowledge);
        }
        if (PlayerUtils.hasKnowledgePiece(player, entityType, 3) || mode == SlimefunGuideMode.CHEAT_MODE) {
            Map<String, Object> traitList = SpiritUtils.getTraitInfo(definition.getTrait());
            CustomItemStack traitItemStack = new CustomItemStack(Material.GLASS, SpiritsFlexGroup.name("trait_item"), SpiritsFlexGroup.lore("trait_item", "{trait_name}", (String)traitList.get("name")));
            menu.replaceExistingItem(40, (ItemStack)traitItemStack);
            menu.addMenuClickHandler(40, (player1, slot, itemStack, clickAction) -> {
                boolean showingDescription;
                boolean bl = showingDescription = itemStack.getItemMeta().hasLore() && itemStack.lore().size() != 3;
                if (showingDescription) {
                    menu.replaceExistingItem(40, (ItemStack)traitItemStack);
                } else {
                    ItemStack descriptionItemStack = traitItemStack.clone();
                    List currentLore = descriptionItemStack.lore();
                    currentLore.remove(2);
                    for (String line : (List)traitList.get("lore")) {
                        currentLore.add(Component.text((String)ChatColors.color((String)(ChatColor.GRAY + line))));
                    }
                    currentLore.add(Component.text((String)""));
                    currentLore.add(Component.text((String)SpiritsFlexGroup.translate("trait_item.open")));
                    descriptionItemStack.lore(currentLore);
                    menu.replaceExistingItem(40, descriptionItemStack);
                }
                return false;
            });
        } else {
            menu.replaceExistingItem(40, notEnoughKnowledge);
        }
    }

    @ParametersAreNonnullByDefault
    private void displayRelationsTree(Player player, PlayerProfile profile, SlimefunGuideMode mode, ChestMenu menu, int returnPage, SpiritDefinition definition) {
        menu.replaceExistingItem(1, ChestMenuUtils.getBackButton((Player)player, (String[])new String[]{backLore}));
        menu.addMenuClickHandler(1, (player1, slot, itemStack, clickAction) -> {
            this.displayDefinition(player1, profile, mode, menu, returnPage, definition);
            return false;
        });
        this.clearDisplay(menu);
        for (int SLOT : DIVIDER) {
            menu.replaceExistingItem(SLOT, ChestMenuUtils.getBackground());
        }
        for (int SLOT : AFRAID) {
            menu.replaceExistingItem(SLOT, afraidItemStack);
        }
        for (int SLOT : SCARE) {
            menu.replaceExistingItem(SLOT, scareItemStack);
        }
        int currentA = 0;
        int currentS = 0;
        for (Map.Entry<String, List<EntityType>> Entry2 : definition.getRelations().entrySet()) {
            String relation = Entry2.getKey();
            for (EntityType mobType : Entry2.getValue()) {
                SpiritDefinition currentRelator = SpiritsUnchained.getSpiritsManager().getSpiritMap().get(mobType);
                int slot2 = relation.equals("Afraid") ? AFRAID_ENTRIES[currentA] : SCARE_ENTRIES[currentS];
                currentA = relation.equals("Afraid") ? currentA + 1 : currentA;
                currentS = relation.equals("Scare") ? currentS + 1 : currentS;
                menu.replaceExistingItem(slot2, this.getSpiritMenuItem(currentRelator));
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void clearDisplay(ChestMenu menu) {
        for (int i = 0; i < 45; ++i) {
            int slot = i + 9;
            menu.replaceExistingItem(slot, null);
            menu.addMenuClickHandler(slot, (player1, i1, itemStack1, clickAction) -> false);
        }
    }

    @ParametersAreNonnullByDefault
    private ItemStack getSpiritMenuItem(SpiritDefinition definition) {
        ItemStack itemStack = new ItemStack(Material.FIREWORK_STAR);
        ItemMeta itemMeta = itemStack.getItemMeta();
        ChatColor chatColor = SpiritUtils.tierColor(definition.getTier());
        String spiritType = ChatUtils.humanize((String)definition.getType().name());
        itemMeta.displayName((Component)Component.text((String)SpiritsFlexGroup.name("spirit_item").replace("{tier_color}", chatColor.toString()).replace("{mob_type}", spiritType)));
        ((FireworkEffectMeta)itemMeta).setEffect(SpiritUtils.effectColor(definition.getType()));
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        for (String line : SpiritsFlexGroup.lore("spirit_item", "{mob_type}", spiritType, "{tier_color}", chatColor.toString(), "{tier}", String.valueOf(definition.getTier()))) {
            lore.add(Component.text((String)line));
        }
        itemMeta.lore(lore);
        PersistentDataAPI.setString((PersistentDataHolder)itemMeta, (NamespacedKey)new NamespacedKey((Plugin)SpiritsUnchained.getInstance(), "spirit_type"), (String)spiritType);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DYE, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_POTION_EFFECTS});
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

